package com.elitesland.fin.common;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Jason(zhao jun hui)
 * @date 2021/4/13
 */
public enum UdcEnum {
    //中台产品状态UDC
    APPLY_STATUS_DRAFT("yst-supp", "APPLY_STATUS", "申请单状态", "DRAFT", "待提交"),
    APPLY_STATUS_DOING("yst-supp", "APPLY_STATUS", "申请单状态", "DOING", "审批中"),
    APPLY_STATUS_REJECTED("yst-supp", "APPLY_STATUS", "申请单状态", "REJECTED", "审批拒绝"),
    APPLY_STATUS_COMPLETE("yst-supp", "APPLY_STATUS", "申请单状态", "COMPLETE", "审批通过"),
    APPLY_STATUS_VOID("yst-supp", "APPLY_STATUS", "申请单状态", "VOID", "作废"),
    APPLY_STATUS_EXPIRED("yst-supp", "APPLY_STATUS", "申请单状态", "EXPIRED", "失效"),
    APPLY_STATUS_ACTIVE("yst-supp", "APPLY_STATUS", "申请单状态", "ACTIVE", "生效"),
    APPLY_STATUS_INV_SUCCESS("yst-supp", "APPLY_STATUS", "申请单状态", "INV_SUCCESS", "开票成功"),
    APPLY_STATUS_INV_FAIL("yst-supp", "APPLY_STATUS", "申请单状态", "INV_FAIL", "开票失败"),
    APPLY_STATUS_RED_SUCCESS("yst-supp", "APPLY_STATUS", "申请单状态", "RED_SUCCESS", "已红冲"),

    //核销状态
    FIN_VERIFY_STATUS_PART("FIN", "VERIFY_STATUS", "核销状态", "PART", "部分核销"),
    FIN_VERIFY_STATUS_YES("FIN", "VERIFY_STATUS", "核销状态", "YES", "完全核销"),
    FIN_VERIFY_STATUS_NO("FIN", "VERIFY_STATUS", "核销状态", "NO", "无需核销"),
    FIN_VERIFY_STATUS_AWAIT("FIN", "VERIFY_STATUS", "核销状态", "AWAIT", "待核销"),

    //传输状态
    FIN_TRANSFER_STATE_SUCCESS("FIN", "TRANSFER_STATE", "传输状态", "SUCCESS", "传输成功"),
    FIN_TRANSFER_STATE_NO("FIN", "TRANSFER_STATE", "传输状态", "NO", "无需传输"),
    FIN_TRANSFER_STATE_AWAIT("FIN", "TRANSFER_STATE", "传输状态", "AWAIT", "待传输"),
    FIN_TRANSFER_STATE_FAIL("FIN", "TRANSFER_STATE", "传输状态", "FAIL", "传输失败"),

    //发票类型
    FIN_INV_TYPE_VANA("FIN", "INV_TYPE", "发票类型", "VANA", "增值税专票"),
    FIN_INV_TYPE_ELECTRONN("FIN", "INV_TYPE", "发票类型", "ELECTRON", "电子增值税普票"),
    FIN_INV_TYPE_PRODUCE("FIN", "INV_TYPE", "发票类型", "PRODUCE", "农产品收购发票和农产品销售发票"),
    FIN_INV_TYPE_VATN("FIN", "INV_TYPE", "发票类型", "VATN", "增值税普票"),
    FIN_INV_TYPE_NO("FIN", "INV_TYPE", "发票类型", "NO", "无"),

    //开票状态
    INV_STATE_SUCCESS("yst-fin", "INV_STATE", "开票状态", "SUCCESS", "开票成功"),
    INV_STATE_CANCEL_SUCCESS("yst-fin", "INV_STATE", "作废成功", "CANCEL_SUCCESS", "作废成功"),
    INV_STATE_ING("yst-fin", "INV_STATE", "待开发票状态", "ING", "开票中"),
    INV_STATE_WAIT("yst-fin", "INV_STATE", "待开发票状态", "WAIT", "待开票"),
    INV_STATE_REJECT("yst-fin", "INV_STATE", "待开发票状态", "REJECT", "开票拒绝"),
    INV_STATE_FAIL("yst-fin", "INV_STATE", "待开发票状态", "FAIL", "开票失败"),
    INV_STATE_IN_CANCEL("yst-fin", "INV_STATE", "待开发票状态", "IN_CANCEL", "发票作废中"),
    INV_STATE_RED_SUCCESS("yst-fin", "INV_STATE", "开票状态", "RED_SUCCESS", "已红冲"),

    // 	待开发票状态
    INVOICE_AWAIT_STATUS_SUCCESS("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "SUCCESS", "开票成功"),
    INVOICE_AWAIT_STATUS_CANCEL_SUCCESS("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "CANCEL_SUCCESS", "作废成功"),
    INVOICE_AWAIT_STATUS_ING("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "ING", "开票中"),
    INVOICE_AWAIT_STATUS_WAIT("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "WAIT", "待开票"),
    INVOICE_AWAIT_STATUS_REJECT("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "REJECT", "开票拒绝"),
    INVOICE_AWAIT_STATUS_FAIL("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "FAIL", "开票失败"),
    INVOICE_AWAIT_STATUS_RED_SUCCESS("yst-fin", "INVOICE_AWAIT_STATUS", "待开发票状态", "RED_SUCCESS", "已红冲"),


    //付款方式
    PUR_PAY_TYPE_TT("PUR", "PAY_TYPE", "付款方式", "TT", "银行转账"),
    PUR_PAY_TYPE_COMM_ACCE("PUR", "PAY_TYPE", "付款方式", "COMM_ACCE", "商业汇票"),
    PUR_PAY_TYPE_BANK_ACCE("PUR", "PAY_TYPE", "付款方式", "BANK_ACCE", "银行汇票"),
    PUR_PAY_TYPE_YX("PUR", "PAY_TYPE", "付款方式", "YX", "云信"),
    PUR_PAY_TYPE_WX("PUR", "PAY_TYPE", "付款方式", "WX", "微信"),
    PUR_PAY_TYPE_ALIPAY("PUR", "PAY_TYPE", "付款方式", "ALIPAY", "支付宝"),
    PUR_PAY_TYPE_CASH7("PUR", "PAY_TYPE", "付款方式", "CASH", "现金"),

    //收款方式
    COM_PAY_METHOD_CASH("COM", "PAY_METHOD", "收款方式", "CASH", "现金收款"),
    COM_PAY_METHOD_TT("COM", "PAY_METHOD", "收款方式", "TT", "银行转账"),
    COM_PAY_METHOD_CASH_CHEQUE("COM", "PAY_METHOD", "收款方式", "CASH_CHEQUE", "现金支票"),
    COM_PAY_METHOD_TRANS_CHEQUE("COM", "PAY_METHOD", "收款方式", "TRANS_CHEQUE", "转账支票"),
    COM_PAY_METHOD_BANK_ACCE("COM", "PAY_METHOD", "收款方式", "BANK_ACCE", "银行承兑汇票"),
    COM_PAY_METHOD_COMM_ACCE("COM", "PAY_METHOD", "收款方式", "COMM_ACCE", "商业承兑汇票"),
    COM_PAY_METHOD_OTHER_ELEC_BILL("COM", "PAY_METHOD", "收款方式", "OTHER_ELEC_BILL", "其他电子票据"),
    COM_PAY_METHOD_WX("COM", "PAY_METHOD", "收款方式", "WX", "微信"),
    COM_PAY_METHOD_ALIPAY("COM", "PAY_METHOD", "收款方式", "ALIPAY", "支付宝"),
    COM_PAY_METHOD_POINTS("COM", "PAY_METHOD", "收款方式", "POINTS", "积分"),
    COM_PAY_METHOD_DISC_COUPON("COM", "PAY_METHOD", "收款方式", "DISC_COUPON", "优惠券"),
    COM_PAY_METHOD_SHOP_CARD("COM", "PAY_METHOD", "收款方式", "SHOP_CARD", "购物卡"),
    COM_PAY_METHOD_GIFT_CARD("COM", "PAY_METHOD", "收款方式", "GIFT_CARD", "提货券"),
    COM_PAY_METHOD_VALUE_CARD("COM", "PAY_METHOD", "收款方式", "VALUE_CARD", "预储值卡"),

    //费用类型
    FIN_EXPENSES_TYPE_SCF("FIN", "EXPENSES_TYPE", "费用类型", "SCF", "市场费"),
    FIN_EXPENSES_TYPE_FLF("FIN", "EXPENSES_TYPE", "费用类型", "FLF", "福利费"),
    FIN_EXPENSES_TYPE_BGF("FIN", "EXPENSES_TYPE", "费用类型", "BGF", "办公费"),
    FIN_EXPENSES_TYPE_CLF("FIN", "EXPENSES_TYPE", "费用类型", "CLF", "差旅费"),
    FIN_EXPENSES_TYPE_YFF("FIN", "EXPENSES_TYPE", "费用类型", "YFF", "研发费用"),
    FIN_EXPENSES_TYPE_YWZDF("FIN", "EXPENSES_TYPE", "费用类型", "YWZDF", "业务招待费"),
    FIN_EXPENSES_TYPE_WLF("FIN", "EXPENSES_TYPE", "费用类型", "WLF", "物流费"),
    FIN_EXPENSES_TYPE_SHWXF("FIN", "EXPENSES_TYPE", "费用类型", "SHWXF", "售后维修费"),
    FIN_EXPENSES_TYPE_OTHER("FIN", "EXPENSES_TYPE", "费用类型", "OTHER", "其他费用"),

    //查验状态
    FIN_EXAM_TYPE_NO("FIN", "EXAM_TYPE", "查验状态", "NO", "未查验"),
    FIN_EXAM_TYPE_SUCCESS("FIN", "EXAM_TYPE", "查验状态", "SUCCESS", "已查验"),
    FIN_EXAM_TYPE_FAIL("FIN", "EXAM_TYPE", "查验状态", "FAIL", "查验失败"),

    //核销方式
    FIN_VERIFY_TYPE_MANU("FIN", "VERIFY_TYPE", "核销方式", "MANU", "手工核销"),
    FIN_VERIFY_TYPE_AUTO("FIN", "VERIFY_TYPE", "核销方式", "AUTO", "自动核销"),

    //工作流状态
    COM_APPR_STATUS_APPROVING("COM", "APPR_STATUS", "工作流状态", "APPROVING", "审批中"),
    COM_APPR_STATUS_APPROVED("COM", "APPR_STATUS", "工作流状态", "APPROVED", "审批通过"),
    COM_APPR_STATUS_REJECTED("COM", "APPR_STATUS", "工作流状态", "REJECTED", "审批拒绝"),
    COM_APPR_STATUS_INVALID("COM", "APPR_STATUS", "工作流状态", "INVALID", "作废"),
    COM_APPR_STATUS_INTERRUPT("COM", "APPR_STATUS", "工作流状态", "INTERRUPT", "中断执行"),
    COM_APPR_STATUS_DELETE("COM", "APPR_STATUS", "工作流状态", "DELETE", "删除"),
    COM_APPR_STATUS_NOTSUBMIT("COM", "APPR_STATUS", "工作流状态", "NOTSUBMIT", "未提交"),

    //红（蓝）票
    FIN_OPEN_TYPE_LP("FIN", "OPEN_TYPE", "红（蓝）票", "LP", "蓝票"),
    FIN_OPEN_TYPE_HP("FIN", "OPEN_TYPE", "红（蓝）票", "HP", "红票"),

    //应付单来源
    FIN_AP_DOC_CLS_MANU("FIN", "AP_DOC_CLS", "应付单来源", "MANU", "手工"),
    FIN_AP_DOC_CLS_PO("FIN", "AP_DOC_CLS", "应付单来源", "PO", "采购订单"),
    FIN_AP_DOC_CLS_GR("FIN", "AP_DOC_CLS", "应付单来源", "GR", "采购收货单"),
    FIN_AP_DOC_CLS_CGTHD("FIN", "AP_DOC_CLS", "应付单来源", "CGTHD", "采购退货单"),
    FIN_AP_DOC_CLS_PACCK("FIN", "AP_DOC_CLS", "应付单来源", "PACCK", "对账单"),
    FIN_AP_DOC_CLS_PINV("FIN", "AP_DOC_CLS", "应付单来源", "PINV", "采购发票"),

    //付款单来源
    FIN_PAY_DOC_CLS_MANU("FIN", "PAY_DOC_CLS", "付款单来源", "MANU", "手工"),
    FIN_PAY_DOC_CLS_PO("FIN", "PAY_DOC_CLS", "付款单来源", "PO", "采购订单"),
    FIN_PAY_DOC_CLS_AP("FIN", "PAY_DOC_CLS", "付款单来源", "AP", "应付单"),

    //收款单来源
    FIN_REC_DOC_CLS_MANU("FIN", "REC_DOC_CLS", "收款单来源", "MANU", "手工"),
    FIN_REC_DOC_CLS_SO("FIN", "REC_DOC_CLS", "收款单来源", "SO", "销售订单"),
    FIN_REC_DOC_CLS_AR("FIN", "REC_DOC_CLS", "收款单来源", "AR", "应收单"),
    FIN_REC_DOC_CLS_SVO("FIN", "REC_DOC_CLS", "收款单来源", "SVO", "储值订单"),

    //应收单来源-改成用yst-supp DOC_CLS
    FIN_AR_DOC_CLS_MANU("FIN", "AR_DOC_CLS", "应收单来源", "MANU", "手工"),
    FIN_AR_DOC_CLS_SO("FIN", "AR_DOC_CLS", "应收单来源", "SO", "销售订单"),
    //FIN_AR_DOC_CLS_DO("FIN", "AR_DOC_CLS", "应收单来源", "DO", "销售出库单"),
    //FIN_AR_DOC_CLS_SACCK("FIN", "AR_DOC_CLS", "应收单来源", "SACCK", "对账单"),
    FIN_AR_DOC_CLS_SINV("FIN", "AR_DOC_CLS", "应收单来源", "SINV", "销售发票"),

    //进项发票来源
    FIN_PINV_CREATE_MODE_PACCK("FIN", "PINV_CREATE_MODE", "进项发票来源", "PACCK", "对账单"),
    FIN_PINV_CREATE_MODE_AP("FIN", "PINV_CREATE_MODE", "进项发票来源", "AP", "应付单"),
    FIN_PINV_CREATE_MODE_GR("FIN", "PINV_CREATE_MODE", "进项发票来源", "GR", "采购收货单"),
    FIN_PINV_CREATE_MODE_MANU("FIN", "PINV_CREATE_MODE", "进项发票来源", "MANU", "手工"),

    //收款类型
    SAL_RECEIPT_TYPE_DEPOSIT("SAL", "RECEIPT_TYPE", "收款类型", "DEPOSIT", "收取押金"),
    SAL_RECEIPT_TYPE_VIRTUAL("SAL", "RECEIPT_TYPE", "收款类型", "VIRTUAL", "虚拟收款"),
    SAL_RECEIPT_TYPE_DEP_PRE("SAL", "RECEIPT_TYPE", "收款类型", "DEP_PRE", "押金转预收"),
    SAL_RECEIPT_TYPE_OFF_PRE("SAL", "RECEIPT_TYPE", "收款类型", "OFF_PRE", "B端商城线下收款"),
    SAL_RECEIPT_TYPE_ONLINE_PRE("SAL", "RECEIPT_TYPE", "收款类型", "ONLINE_PRE", "B端商城线上收款"),
    SAL_RECEIPT_TYPE_MAR_PRE("SAL", "RECEIPT_TYPE", "收款类型", "MAR_PRE", "保证金收款"),
    SAL_RECEIPT_TYPE_SER_PRE("SAL", "RECEIPT_TYPE", "收款类型", "SER_PRE", "服务费收款"),
    SAL_RECEIPT_TYPE_FINE_PRE("SAL", "RECEIPT_TYPE", "收款类型", "FINE_PRE", "罚款收款"),
    SAL_RECEIPT_TYPE_STORAGE("SAL", "RECEIPT_TYPE", "收款类型", "STORAGE", "储值收款"),


    // 销项发票申请来源单据
    FIN_SINV_CREATE_MODE_SACCK("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "SACCK", "销售对账单"),
    FIN_SINV_CREATE_MODE_AR("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "AR", "应收单"),
    FIN_SINV_CREATE_MODE_DO("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "DO", "销售发货单"),
    FIN_SINV_CREATE_MODE_RDO("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "RDO", "退货入库单"),
    FIN_SINV_CREATE_MODE_MANU("FIN", "SINV_CREATE_MODE", "销项发票申请来源", "MANU", "手工"),

    // 红冲状态
    RED_STATE_NO("yst-fin", "RED_STATE", "红冲状态", "NO", "未红冲"),
    RED_STATE_ING("yst-fin", "RED_STATE", "红冲状态", "ING", "发票红冲中"),
    RED_STATE_SUCCESS("yst-fin", "RED_STATE", "红冲状态", "SUCCESS", "已红冲"),

    // 发票性质
    FIN_INV_NATURE_0("FIN", "INV_NATURE", "发票性质", "0", "正常行"),
    FIN_INV_NATURE_1("FIN", "INV_NATURE", "发票性质", "1", "折扣行"),
    FIN_INV_NATURE_2("FIN", "INV_NATURE", "发票性质", "2", "被折扣行"),

    // 推送方式
    FIN_PUSH_METHOD_NO("FIN", "PUSH_METHOD", "推送方式", "-1", "不推送"),
    FIN_PUSH_METHOD_0("FIN", "PUSH_METHOD", "推送方式", "0", "邮箱"),
    FIN_PUSH_METHOD_1("FIN", "PUSH_METHOD", "推送方式", "1", "手机"),
    FIN_PUSH_METHOD_2("FIN", "PUSH_METHOD", "推送方式", "2", "邮箱/手机"),

    // 导入状态
    FIN_IMP_STATE_SUCCESS("FIN", "IMP_STATE", "导入状态", "SUCCESS", "导入成功"),
    FIN_IMP_STATE_FAIL("FIN", "IMP_STATE", "导入状态", "FAIL", "导入失败"),

    // 提现状态
    FIN_WITHDRAW_STATE_WITHDRAWNO("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAWNO", "未提现"),
    FIN_WITHDRAW_STATE_WITHDRAED("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAED", "提现成功"),
    FIN_WITHDRAW_STATE_WITHDRAWING("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAWING", "提现中"),
    FIN_WITHDRAW_STATE_WITHDRAFALSE("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAFALSE", "提现失败"),
    FIN_WITHDRAW_STATE_WITHDRAREJECTED("FIN", "WITHDRAW_STATE", "提现状态", "WITHDRAREJECTED", "提现驳回"),


    //账户类型
    ACCOUNT_TYPE_STORE("yst-fin", "ACCOUNT_TYPE", "账户类型", "STORE", "储值账户"),
    ACCOUNT_TYPE_FLZH("yst-fin", "ACCOUNT_TYPE", "账户类型", "FLZH", "返利账户"),
    FIN_ACCOUNT_TYPE_ZCCZZH("FIN", "ACCOUNT_TYPE", "账户类型", "ZCCZZH", "整车储值账户"),
    FIN_ACCOUNT_TYPE_PJCZZH("FIN", "ACCOUNT_TYPE", "账户类型", "PJCZZH", "配件储值账户"),
    FIN_ACCOUNT_TYPE_FJCZZH("FIN", "ACCOUNT_TYPE", "账户类型", "FJCZZH", "附件包储值账户"),
    FIN_ACCOUNT_TYPE_ZCFLZH("FIN", "ACCOUNT_TYPE", "账户类型", "ZCFLZH", "整车返利账户"),
    FIN_ACCOUNT_TYPE_PJFLZH("FIN", "ACCOUNT_TYPE", "账户类型", "PJFLZH", "配件返利账户"),
    FIN_ACCOUNT_TYPE_ZCFLJZZH("FIN", "ACCOUNT_TYPE", "账户类型", "ZCFLJZZH", "整车返利记账账户"),
    FIN_ACCOUNT_TYPE_PJFLJZZH("FIN", "ACCOUNT_TYPE", "账户类型", "PJFLJZZH", "配件返利记账账户"),
    FIN_ACCOUNT_TYPE_TCZH("FIN", "ACCOUNT_TYPE", "账户类型", "TCZH", "统筹账户"),
    FIN_ACCOUNT_TYPE_FLZH("FIN", "ACCOUNT_TYPE", "账户类型", "FLZH", "返利账户"),
    FIN_ACCOUNT_TYPE_ZJZH("FIN", "ACCOUNT_TYPE", "账户类型", "ZJZH", "资金账户"),
    FIN_ACCOUNT_TYPE_FYZH("FIN", "ACCOUNT_TYPE", "账户类型", "FYZH", "费用账户"),

    //充值单UDC/收款单（立马）
    FIN_CG_ORDER_TYPE_ZC0001("FIN", "CG_ORDER_TYPE", "充值单类型", "ZC0001", "整车收款单"),
    FIN_CG_ORDER_TYPE_PJ0001("FIN", "CG_ORDER_TYPE", "充值单类型", "PJ0001", "配件收款单"),
    FIN_CG_ORDER_TYPE_FJ0001("FIN", "CG_ORDER_TYPE", "充值单类型", "FJ0001", "附件包收款单"),
    FIN_CG_ORDER_TYPE_BZJ0001("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0001", "充值装修保证金"),
    FIN_CG_ORDER_TYPE_BZJ0002("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0002", "充值定制品保证金"),
    FIN_CG_ORDER_TYPE_BZJ0003("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0003", "充值新品保证金"),
    FIN_CG_ORDER_TYPE_BZJ0004("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0004", "充值电池保证金"),
    FIN_CG_ORDER_TYPE_BZJ0005("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0005", "账户扣款电池保证金"),
    FIN_CG_ORDER_TYPE_BZJ0006("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0006", "账户扣款装修保证金"),
    FIN_CG_ORDER_TYPE_BZJ0007("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0007", "账户扣款定制品保证金"),
    FIN_CG_ORDER_TYPE_BZJ0008("FIN", "CG_ORDER_TYPE", "充值单类型", "BZJ0008", "账户扣款新品保证金"),
    FIN_CG_ORDER_TYPE_RBZJ0001("FIN", "CG_ORDER_TYPE", "充值单类型", "RBZJ0001", "装修保证金退款单"),
    FIN_CG_ORDER_TYPE_RBZJ0002("FIN", "CG_ORDER_TYPE", "充值单类型", "RBZJ0002", "定制品保证金退款单"),
    FIN_CG_ORDER_TYPE_RBZJ0003("FIN", "CG_ORDER_TYPE", "充值单类型", "RBZJ0003", "新品保证金退款单"),
    FIN_CG_ORDER_TYPE_RBZJ0004("FIN", "CG_ORDER_TYPE", "充值单类型", "RBZJ0004", "电池保证金退款单"),

    FIN_CHARGE_ORDER_TYPE1_ZCCZ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "ZCCZ", "整车充值"),
    FIN_CHARGE_ORDER_TYPE1_PJCZ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "PJCZ", "配件充值"),
    FIN_CHARGE_ORDER_TYPE1_FJBCZ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "FJBCZ", "附件包充值"),
    FIN_CHARGE_ORDER_TYPE1_DCBZJ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "DCBZJ", "电池保证金"),
    FIN_CHARGE_ORDER_TYPE1_ZXBZJ("FIN", "CHARGE_ORDER_TYPE1", "充值类型", "ZXBZJ", "装修保证金"),
    FIN_CHARGE_ORDER_TYPE1_DZPBZJ("FIN", "CHARGE_ORDER_TYPE1", "充单类型", "DZPBZJ", "定制品保证金"),
    FIN_CHARGE_ORDER_TYPE1_XPBZJ("FIN", "CHARGE_ORDER_TYPE1", "充单类型", "XPBZJ", "新品保证金"),

    FIN_CHARGE_ORDER_TYPE2_DCBZJ("FIN", "CHARGE_ORDER_TYPE2", "充值类型", "DCBZJ", "电池保证金"),
    FIN_CHARGE_ORDER_TYPE2_ZXBZJ("FIN", "CHARGE_ORDER_TYPE2", "充值类型", "ZXBZJ", "装修保证金"),
    FIN_CHARGE_ORDER_TYPE2_DZPBZJ("FIN", "CHARGE_ORDER_TYPE2", "充单类型", "DZPBZJ", "定制品保证金"),
    FIN_CHARGE_ORDER_TYPE2_XPBZJ("FIN", "CHARGE_ORDER_TYPE2", "充单类型", "XPBZJ", "新品保证金"),
    FIN_CHARGE_ORDER_TYPE2_DCBZJT("FIN", "CHARGE_ORDER_TYPE2", "充值类型", "DCBZJT", "电池保证金-退还"),
    FIN_CHARGE_ORDER_TYPE2_ZXBZJT("FIN", "CHARGE_ORDER_TYPE2", "充值类型", "ZXBZJT", "装修保证金-退还"),
    FIN_CHARGE_ORDER_TYPE2_DZPBZJT("FIN", "CHARGE_ORDER_TYPE2", "充单类型", "DZPBZJT", "定制品保证金-退还"),
    FIN_CHARGE_ORDER_TYPE2_XPBZJT("FIN", "CHARGE_ORDER_TYPE2", "充单类型", "XPBZJT", "新品保证金-退还"),

    //账户流水数据来源
    FIN_DATA_SOURCE_TYPE_DD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD01", "整车/配件/附件下单（只占用）"),
    FIN_DATA_SOURCE_TYPE_DD02("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD02", "整车/配件/附件订单修改（先释放后占用）"),
    FIN_DATA_SOURCE_TYPE_DD021("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD021", "整车/配件/附件订单修改（先释放）"),
    FIN_DATA_SOURCE_TYPE_DD022("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD022", "整车/配件/附件订单修改（后占用）"),
    FIN_DATA_SOURCE_TYPE_DD03("FIN", "DATA_SOURCE_TYPE", "数据来源", "DD03", "订单关闭（只释放）"),
    FIN_DATA_SOURCE_TYPE_FHD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "FHD01", "整车/配件/附件发货单已发货（释放/扣减）"),
    FIN_DATA_SOURCE_TYPE_FHD02("FIN", "DATA_SOURCE_TYPE", "数据来源", "FHD02", "撤销发货"),
    FIN_DATA_SOURCE_TYPE_THD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "THD01", "整车/配件/附件审核通过已退款的退货单"),
    FIN_DATA_SOURCE_TYPE_SKD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "SKD01", "整车/配件/附件收款单审核通过"),
    FIN_DATA_SOURCE_TYPE_BZJ01("FIN", "DATA_SOURCE_TYPE", "数据来源", "BZJ01", "提交账户扣款的保证金"),
    FIN_DATA_SOURCE_TYPE_BZJ02("FIN", "DATA_SOURCE_TYPE", "数据来源", "BZJ02", "收款方式=账户扣款的保证金收款单审核拒绝"),
    FIN_DATA_SOURCE_TYPE_BZJ03("FIN", "DATA_SOURCE_TYPE", "数据来源", "BZJ03", "收款方式=账户扣款的保证金收款单审核通过"),
    FIN_DATA_SOURCE_TYPE_BZJ04("FIN", "DATA_SOURCE_TYPE", "数据来源", "BZJ04", "保证金退款单审核通过"),
    FIN_DATA_SOURCE_TYPE_TZD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "TZD01", "调整类型=调出的调整单提交"),
    FIN_DATA_SOURCE_TYPE_TZD02("FIN", "DATA_SOURCE_TYPE", "数据来源", "TZD02", "调整类型=调出的调整单审核拒绝"),
    FIN_DATA_SOURCE_TYPE_TZD03("FIN", "DATA_SOURCE_TYPE", "数据来源", "TZD03", "调整类型=调出的调整单审核通过"),
    FIN_DATA_SOURCE_TYPE_TZD04("FIN", "DATA_SOURCE_TYPE", "数据来源", "TZD04", "调整类型=调进的调整单审核通过"),
    FIN_DATA_SOURCE_TYPE_TJD01("FIN", "DATA_SOURCE_TYPE", "数据来源", "TJD01", "调整类型=调出的调剂单提交"),
    FIN_DATA_SOURCE_TYPE_TJD02("FIN", "DATA_SOURCE_TYPE", "数据来源", "TJD02", "调整类型=调出的调剂单审批拒绝"),
    FIN_DATA_SOURCE_TYPE_TJD03("FIN", "DATA_SOURCE_TYPE", "数据来源", "TJD03", "调剂单审核通过"),
    //FIN_DATA_SOURCE_TYPE_TJD04("FIN", "DATA_SOURCE_TYPE", "数据来源", "TJD04", "调整类型=调进的调剂单审核通过"),
    FIN_DATA_SOURCE_TYPE_FHHC01("FIN", "DATA_SOURCE_TYPE", "数据来源", "FHHC01", "发货红冲（释放/扣减）"),

    //账户流水交易类型
    FIN_TRANSACTION_TYPE_DDZY("FIN", "TRANSACTION_TYPE", "交易类型", "DDZY", "订单占用"),
    FIN_TRANSACTION_TYPE_DDSF("FIN", "TRANSACTION_TYPE", "交易类型", "DDSF", "订单释放"),
    FIN_TRANSACTION_TYPE_FHSF("FIN", "TRANSACTION_TYPE", "交易类型", "FHSF", "发货释放"),
    FIN_TRANSACTION_TYPE_FHKJ("FIN", "TRANSACTION_TYPE", "交易类型", "FHKJ", "发货扣减"),
    FIN_TRANSACTION_TYPE_CXFHTH("FIN", "TRANSACTION_TYPE", "交易类型", "CXFHTH", "撤销发货退还"),
    FIN_TRANSACTION_TYPE_CXFHZY("FIN", "TRANSACTION_TYPE", "交易类型", "CXFHZY", "撤销发货占用"),
    FIN_TRANSACTION_TYPE_THTK("FIN", "TRANSACTION_TYPE", "交易类型", "THTK", "退货退款"),
    FIN_TRANSACTION_TYPE_CZ("FIN", "TRANSACTION_TYPE", "交易类型", "CZ", "充值"),
    FIN_TRANSACTION_TYPE_BZJZY("FIN", "TRANSACTION_TYPE", "交易类型", "BZJZY", "保证金占用"),
    FIN_TRANSACTION_TYPE_BZJSF("FIN", "TRANSACTION_TYPE", "交易类型", "BZJSF", "保证金释放"),
    FIN_TRANSACTION_TYPE_BZJKK("FIN", "TRANSACTION_TYPE", "交易类型", "BZJKK", "保证金扣款"),
    FIN_TRANSACTION_TYPE_BZJTK("FIN", "TRANSACTION_TYPE", "交易类型", "BZJTK", "保证金退款"),
    FIN_TRANSACTION_TYPE_TZDZY("FIN", "TRANSACTION_TYPE", "交易类型", "TZDZY", "调整单占用"),
    FIN_TRANSACTION_TYPE_TZDSF("FIN", "TRANSACTION_TYPE", "交易类型", "TZDSF", "调整单释放"),
    //FIN_TRANSACTION_TYPE_TZDTC("FIN", "TRANSACTION_TYPE", "交易类型", "TZDTC", "调整单的调整原因-调出"),
    //FIN_TRANSACTION_TYPE_TZDTJ("FIN", "TRANSACTION_TYPE", "交易类型", "TZDTJ", "调整单的调整原因-调进"),
    FIN_TRANSACTION_TYPE_TJDZY("FIN", "TRANSACTION_TYPE", "交易类型", "TJDZY", "调剂单占用"),
    FIN_TRANSACTION_TYPE_TJDSF("FIN", "TRANSACTION_TYPE", "交易类型", "TJDSF", "调剂单释放"),
    //FIN_TRANSACTION_TYPE_TJDTC("FIN", "TRANSACTION_TYPE", "交易类型", "TJDTC", "调剂单的调整原因—调出"),
    //FIN_TRANSACTION_TYPE_TJDTJ("FIN", "TRANSACTION_TYPE", "交易类型", "TJDTJ", "调剂单的调整原因—调进"),
    FIN_TRANSACTION_TYPE_FHSFCH("FIN", "TRANSACTION_TYPE", "交易类型", "FHSFCH", "发货释放冲回"),
    FIN_TRANSACTION_TYPE_FHHC("FIN", "TRANSACTION_TYPE", "交易类型", "FHHC", "发货红冲"),

    //账户流水来源单据
    FIN_SOURCE_DOC_TYPE_ORDER("FIN", "SOURCE_DOC_TYPE", "来源单据", "ORDER", "订单"),
    FIN_SOURCE_DOC_TYPE_DISPATCH("FIN", "SOURCE_DOC_TYPE", "来源单据", "DISPATCH", "发货单"),
    FIN_SOURCE_DOC_TYPE_RETURN("FIN", "SOURCE_DOC_TYPE", "来源单据", "RETURN", "退货单"),
    FIN_SOURCE_DOC_TYPE_RECEIPT("FIN", "SOURCE_DOC_TYPE", "来源单据", "RECEIPT", "收款单"),
    FIN_SOURCE_DOC_TYPE_BZJSKD("FIN", "SOURCE_DOC_TYPE", "来源单据", "BZJSKD", "保证金收款单"),
    FIN_SOURCE_DOC_TYPE_BZJTKD("FIN", "SOURCE_DOC_TYPE", "来源单据", "BZJTKD", "保证金退款单"),
    FIN_SOURCE_DOC_TYPE_ADJUST("FIN", "SOURCE_DOC_TYPE", "来源单据", "ADJUST", "调整单"),
    FIN_SOURCE_DOC_TYPE_TJD("FIN", "SOURCE_DOC_TYPE", "来源单据", "TJD", "调剂单"),

    //账户流水来源平台
    FIN_SOURCE_PLATFORM_TYPE_FIN("FIN", "SOURCE_PLATFORM_TYPE", "来源平台", "FIN", "财务"),
    FIN_SOURCE_PLATFORM_TYPE_ORDER("FIN", "SOURCE_PLATFORM_TYPE", "来源平台", "ORDER", "订单"),
    FIN_SOURCE_PLATFORM_TYPE_OTHER("FIN", "SOURCE_PLATFORM_TYPE", "来源平台", "OTHER", "其它"),

    //调整单类型
    ADJUST_TYPE_1("yst-fin", "ADJUST_TYPE", "调整类型", "1", "调入"),
    ADJUST_TYPE_2("yst-fin", "ADJUST_TYPE", "调整类型", "2", "调出"),

    FIN_ADJUST_REASON_1("yst-fin", "ADJUST_REASON", "调整原因", "1", "同账户调整"),
    FIN_ADJUST_REASON_2("yst-fin", "ADJUST_REASON", "调整原因", "2", "异账户调整"),
    FIN_ADJUST_REASON_DIFF_ADJ("yst-fin", "ADJUST_REASON", "调整原因", "1", "差异调整"),
    FIN_ADJUST_REASON_ABNORMAL_ADJ("yst-fin", "ADJUST_REASON", "调整原因", "2", "异常调整"),

    FIN_ACTIVE_STATUS_ACTIVE("yst-fin", "ACTIVE_STATUS", "启用/禁用状态", "ACTIVE", "启用"),
    FIN_ACTIVE_STATUS_CLOSED("yst-fin", "ACTIVE_STATUS", "启用/禁用状态", "CLOSED", "禁用"),

    ACCOUNT_PERIOD_CONTROL_STATUS_NOT_OPEN("yst-fin", "ACCOUNT_PERIOD_CONTROL_STATUS", "会计期间控制状态", "NOT_OPEN", "未打开"),
    ACCOUNT_PERIOD_CONTROL_STATUS_OPEN("yst-fin", "ACCOUNT_PERIOD_CONTROL_STATUS", "会计期间控制状态", "OPEN", "已打开"),
    ACCOUNT_PERIOD_CONTROL_STATUS_CLOSED("yst-fin", "ACCOUNT_PERIOD_CONTROL_STATUS", "会计期间控制状态", "CLOSED", "关闭"),

    EVENT_TABLE_CONDITION_EQUAL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "=", "="),
    EVENT_TABLE_CONDITION_GREATER("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", ">", ">"),
    EVENT_TABLE_CONDITION_LESS("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "<", "<"),
    EVENT_TABLE_CONDITION_GREATER_EQUAL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", ">=", ">="),
    EVENT_TABLE_CONDITION_LESS_EQUAL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "<=", "<="),
    EVENT_TABLE_CONDITION_IS_NULL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "is null", "is null"),
    EVENT_TABLE_CONDITION_IS_NOT_NULL("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "is not null", "is not null"),
    EVENT_TABLE_CONDITION_IN("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "in", "in"),
    EVENT_TABLE_CONDITION_NOT_IN("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "not in", "not in"),
    EVENT_TABLE_CONDITION_BETWEEN_AND("yst-fin", "EVENT_TABLE_CONDITION", "事件表单条件", "between and", "between and"),



    //账户事务
    IO_TYPE_I("yst-fin", "IO_TYPE", "事务类型", "I", "账户增加"),
    IO_TYPE_O("yst-fin", "IO_TYPE", "事务类型", "O", "账户扣减"),
    IO_TYPE_T("yst-fin", "IO_TYPE", "事务类型", "T", "账户占用"),
    IO_TYPE_R("yst-fin", "IO_TYPE", "事务类型", "R", "占用释放"),

    CREDIT_IO_TYPE_I("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "I", "账户增加"),
    CREDIT_IO_TYPE_O("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "O", "账户扣减"),
    CREDIT_IO_TYPE_T("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "T", "账户占用"),
    CREDIT_IO_TYPE_R("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "R", "占用释放"),
    CREDIT_IO_TYPE_U("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "U", "使用增加"),
    CREDIT_IO_TYPE_D("yst-fin", "CREDIT_IO_TYPE", "信用账户事务配置", "D", "使用减少"),


    DOC_CLS_SO_C("yst-supp", "DOC_TYPE", "单据类型", "SO_C", "铺货订单"),
    DOC_TYPE_DO("yst-supp", "DOC_TYPE", "单据类型", "DO", "发货单"),
    DOC_TYPE_SAINV("yst-supp", "DOC_TYPE", "单据类型", "SINV", "销售发票"),
    DOC_CLS_SAINV("yst-supp", "DOC_CLS", "来源单据", "SINV", "销售发票"),
    DOC_STATUS_SAINV("yst-supp", "DOC_STATUS", "来源单据状态", "CONFIRM", "销售发票确认"),

    DOC_STATUS_RSO_CL("yst-supp", "DOC_STATUS", "订单状态", "RSO_CL", "已取消"),

    DOC_STATUS_SACCK_CONFIRM("yst-supp", "DOC_STATUS", "订单状态", "SACCK_CONFIRM", "对账单已确认"),


    //单据类别
    DOC_CLS_SVO("yst-supp", "DOC_CLS", "单据类别", "SVO", "储值订单"),
    DOC_CLS_SO("yst-supp", "DOC_CLS", "单据类别", "SO", "销售订单"),
    DOC_CLS_CREDIT("yst-supp", "DOC_CLS", "单据类别", "CREDIT", "信用订单"),
    DOC_CLS_AO("yst-supp", "DOC_CLS", "单据类别", "AO", "调整单"),
    DOC_CLS_ATO("yst-supp", "DOC_CLS", "单据类别", "ATO", "调剂单"),
    DOC_CLS_SACCK("yst-supp", "DOC_CLS", "单据类别", "SACCK", "对账单"),

    //主体类型
    PRINCIPAL_TYPE_INVOICE("yst-fin", "PRINCIPAL_TYPE", "主体类型", "INVOICE", "开票主体"),

    //单据类型
    DOC_TYPE_AO_1("yst-supp", "DOC_TYPE", "单据类型", "AO_1", "账户余额调整单调入"),
    DOC_TYPE_AO_2("yst-supp", "DOC_TYPE", "单据类型", "AO_2", "账户余额调整单调出"),
    DOC_TYPE_SACCK("yst-supp", "DOC_TYPE", "单据类型", "SACCK_SACCK", "销售对账单"),



    //订单状态
    DOC_STATUS_SO_NOPAY("yst-supp", "DOC_STATUS", "订单状态", "SO_NOPAY", "待支付"),

    //开户银行
    UNION_PAY_700000000000001("yst-fin", "UNION_PAY", "开户银行", "700000000000001", "中国银行"),

    INVOICE_REDRAFT_APPLY_STATUS_DR("yst-fin", "DR", "重新开票状态", "DR", "草稿"),
    INVOICE_REDRAFT_APPLY_STATUS_INVALID("yst-fin", "INVALID", "重新开票状态", "INVALID", "作废"),
    INVOICE_REDRAFT_APPLY_STATUS_APPROVING("yst-fin", "APPROVING", "重新开票状态", "APPROVING", "审批中"),
    INVOICE_REDRAFT_APPLY_STATUS_DONE("yst-fin", "DONE", "重新开票状态", "DONE", "已完成"),

    WORK_FLOW_STATUS_APPROVING("COM", "APPR_STATUS", "工作流状态", "APPROVING", "审批中"),
    WORK_FLOW_STATUS_APPROVED("COM", "APPR_STATUS", "工作流状态", "APPROVED", "审批通过"),
    WORK_FLOW_STATUS_REJECTED("COM", "APPR_STATUS", "工作流状态", "REJECTED", "审批拒绝"),
    WORK_FLOW_STATUS_INVALID("COM", "APPR_STATUS", "工作流状态", "INVALID", "作废"),
    WORK_FLOW_STATUS_INTERRUPT("COM", "APPR_STATUS", "工作流状态", "INTERRUPT", "中断执行"),
    WORK_FLOW_STATUS_DELETE("COM", "APPR_STATUS", "工作流状态", "DELETE", "删除"),
    WORK_FLOW_STATUS_NOTSUBMIT("COM", "APPR_STATUS", "工作流状态", "NOTSUBMIT", "未提交"),

    // 信用账户类型
    CREDIT_ACCOUNT_TYPE_CREDIT("yst-fin", "CREDIT_ACCOUNT_TYPE", "信用账户类型", "CREDIT", "信用账户"),

    // 对象类型
    OBJECT_TYPE_CUST_GROUP("yst-fin", "OBJECT_TYPE", "对象类型", "CUST_GROUP", "客户组"),
    OBJECT_TYPE_CUST("yst-fin", "OBJECT_TYPE", "对象类型", "CUST", "客户"),


    INITIAL_STATUS_DRAFT("yst-fin", "INITIAL_STATUS", "期初额度导入状态", "DRAFT", "草稿"),
    INITIAL_STATUS_FINISHED("yst-fin", "INITIAL_STATUS", "期初额度导入状态", "FINISHED", "结束初始化"),

    DEDUCTION_ACCOUNT_TYPE_CREDIT("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "CREDIT", "信用账户"),
    DEDUCTION_ACCOUNT_TYPE_STORE("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "STORE", "储值账户"),
    DEDUCTION_ACCOUNT_TYPE_ZJZH("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "ZJZH", "资金账户"),
    DEDUCTION_ACCOUNT_TYPE_FYZH("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "FYZH", "费用账户"),
    DEDUCTION_ACCOUNT_TYPE_FLZH("yst-fin", "DEDUCTION_ACCOUNT_TYPE", "扣款账户类型", "FLZH", "返利账户"),

    //授信类型
    CREDIT_TYPE_1("yst-fin", "CREDIT_TYPE", "授信类型", "1", "长期"),
    CREDIT_TYPE_2("yst-fin", "CREDIT_TYPE", "授信类型", "2", "临时"),

    //流水修复状态
    FLOW_REPAIR_STATUS_DRAFT("yst-fin", "FLOW_REPAIR_STATUS", "流水修复状态", "DRAFT", "草稿"),
    FLOW_REPAIR_STATUS_FIXED("yst-fin", "FLOW_REPAIR_STATUS", "流水修复状态", "FIXED", "已修复"),

    ADJUST_ORDER_TYPE_YETZ("yst-fin", "ADJUST_ORDER_TYPE", "调整单单据类型", "YETZ", "账户余额调整单"),

    SOURCE_TYPE_ACCOUNT_PERIOD("yst-fin", "SOURCE_TYPE", "来源类型", "ACCOUNT_PERIOD", "会计期间"),
    SOURCE_TYPE_COLUMN("yst-fin", "SOURCE_TYPE", "来源类型", "COLUMN", "列来源"),
    SOURCE_TYPE_CONSTANT("yst-fin", "SOURCE_TYPE", "来源类型", "CONSTANT", "常数"),
    SOURCE_TYPE_FAST_CODE("yst-fin", "SOURCE_TYPE", "来源类型", "FAST_CODE", "快码"),
    SOURCE_TYPE_FLEXIBLE("yst-fin", "SOURCE_TYPE", "来源类型", "FLEXIBLE", "值集"),


    AR_FLAG_TYPE_0("yst-fin", "AR_FLAG_TYPE", "是否生成应收单类型", "0", "未生成"),
    AR_FLAG_TYPE_1("yst-fin", "AR_FLAG_TYPE", "是否生成应收单类型", "1", "已生成"),
    AR_FLAG_TYPE_2("yst-fin", "AR_FLAG_TYPE", "是否生成应收单类型", "2", "生成失败"),

    //单据拟定状态
    DOC_PROPOSED_STATUS_DRAFT("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "DRAFT", "草稿"),
    DOC_PROPOSED_STATUS_PROPOSING("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "PROPOSING", "拟定中"),
    DOC_PROPOSED_STATUS_PROPOSED_FAIL("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "PROPOSED_FAIL", "拟定失败"),
    DOC_PROPOSED_STATUS_PROPOSED_SUCCESS("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "PROPOSED_SUCCESS", "拟定成功"),
    DOC_PROPOSED_STATUS_SENDING("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "SENDING", "传输中"),
    DOC_PROPOSED_STATUS_SEND_FAIL("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "SEND_FAIL", "传输失败"),
    DOC_PROPOSED_STATUS_SEND_SUCCESS("yst-fin", "DOC_PROPOSED_STATUS", "财务单据拟定状态", "SEND_SUCCESS", "传输成功"),
    ACC_ENG_FAST_CODE_OUTPUT_ONE("yst-fin", "ACC_ENG_FAST_CODE_OUTPUT", "会计引擎快码输出", "ACC_ENG_FAST_CODE_OUTPUT_ONE", "输出1"),
    ACC_ENG_FAST_CODE_OUTPUT_TWO("yst-fin", "ACC_ENG_FAST_CODE_OUTPUT", "会计引擎快码输出", "ACC_ENG_FAST_CODE_OUTPUT_TWO", "输出2"),
    ACC_ENG_FAST_CODE_OUTPUT_THREE("yst-fin", "ACC_ENG_FAST_CODE_OUTPUT", "会计引擎快码输出", "ACC_ENG_FAST_CODE_OUTPUT_THREE", "输出3")
    ;

    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    UdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public static String getValueCodeName(String model, String code, String valueCodeName) {
        for (UdcEnum udcEnum : UdcEnum.values()) {
            if (udcEnum.getModel().equals(model) && udcEnum.getCode().equals(code)
                    && udcEnum.getValueCodeName().equals(valueCodeName)) {
                return udcEnum.getValueCode();
            }
        }
        return null;
    }

    public static UdcEnum getByValueCode(String model, String code, String valueCode) {
        for (UdcEnum udcEnum : UdcEnum.values()) {
            if (udcEnum.getModel().equals(model) && udcEnum.getCode().equals(code)
                && udcEnum.getValueCode().equals(valueCode)) {
                return udcEnum;
            }
        }
        return null;
    }

    public static Map<String, String> getNameCodeMap(String model, String code) {
        Map<String, String> res = new HashMap<>();

        for (UdcEnum udcEnum : UdcEnum.values()) {
            if (udcEnum.getModel().equals(model) && udcEnum.getCode().equals(code)) {
                res.put(udcEnum.getValueCodeName(), udcEnum.getValueCode());
            }
        }
        return res;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }
}
