package com.elitesland.fin.domain.entity.apverconfig;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;


/**
 * @author zhiyu.he
 * @date 2022/4/6 15:17
 */
@Entity
@Table(name = "ap_ver_config")
@org.hibernate.annotations.Table(appliesTo = "ap_ver_config", comment = "核销参数设置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ApVerConfigDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1765718181748187185L;

    @Column(name = "scheme_no", columnDefinition = "varchar(32) comment '方案编号'")
    private String schemeNo;

    @Column(name = "scheme_name", columnDefinition = "varchar(32) comment '方案名称'")
    private String schemeName;

    @Column(name = "enable_flag", columnDefinition = "tinyint(1) comment '启用标志'")
    private Boolean enableFlag;

    @Column(name = "default_flag", columnDefinition = "tinyint(1) comment '默认标志'")
    private Boolean defaultFlag;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApVerConfigDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApVerConfigDO entity = (ApVerConfigDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
