package com.elitesland.fin.domain.entity.recorder;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author : Jason.zhao (zhao jun hui)
 * @date : 2022-4-13
 * @desc : 收款单明细
 */
@Entity
@Table(name="rec_order_dtl")
@org.hibernate.annotations.Table(appliesTo = "rec_order_dtl", comment = "收款单明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class RecOrderDtlDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = -235685464527108320L;
    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '总单ID'")
    private Long masId;

    @Column(name = "rec_type", columnDefinition = "varchar(32) comment '收款方式'")
    private String recType;

    @Column(name = "rec_kind", columnDefinition = "varchar(32) comment '收款类型'")
    private String recKind;

    @Column(name = "rec_bank", columnDefinition = "varchar(32) comment '收款银行名称'")
    private String recBank;

    @Column(name = "rec_account", columnDefinition = "varchar(32) comment '收款银行账户'")
    private String recAccount;

    @Column(name = "rec_flow", columnDefinition = "varchar(32) comment '收款流水'")
    private String recFlow;

    @Column(name = "source_no", columnDefinition = "varchar(32) comment '来源单号'")
    private String sourceNo;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源单号ID'")
    private Long sourceId;

    @Column(name = "source_line", columnDefinition = "int(10) comment '来源行号'")
    private Integer sourceLine;

    @Column(name = "source_line_id", columnDefinition = "bigint(20) comment '来源行号ID'")
    private Long sourceLineId;

    @Column(name = "real_rec_amt", columnDefinition = "decimal(18,8) comment '实际收款金额'")
    private BigDecimal realRecAmt;

    @Column(name = "real_rec_cur_amt", columnDefinition = "decimal(18,8) comment '实际收款金额(本位币)'")
    private BigDecimal realRecCurAmt;

    @Column(name = "tax_amt", columnDefinition = "decimal(18,8) comment '税额'")
    private BigDecimal taxAmt;

    @Column(name = "tax_cur_amt", columnDefinition = "decimal(18,8) comment '税额(本位币)'")
    private BigDecimal taxCurAmt;

    @Column(name = "tax_rate", columnDefinition = "decimal(18,8) comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "total_amt", columnDefinition = "decimal(18,8) comment '含税总金额'")
    private BigDecimal totalAmt;

    @Column(name = "total_cur_amt", columnDefinition = "decimal(18,8) comment '含税总金额(本位币)'")
    private BigDecimal totalCurAmt;

    @Column(name = "expenses_type", columnDefinition = "varchar(32) comment '费用类型'")
    private String expensesType;

    @ApiModelProperty("扩展表关联字段")
    @Column(name = "relate_id", columnDefinition = "bigint(20) comment '扩展表关联字段'")
    private Long relateId;

//    @Column(name = "es10", columnDefinition = "varchar(32) comment '客户编码'")
//    private String es10;
//
//    @Column(name = "es11", columnDefinition = "varchar(32) comment '收款性质'")
//    private String es11;
//
//    @Column(name = "es12", columnDefinition = "varchar(32) comment '销售组织编码'")
//    private String es12;
//
//    @Column(name = "es13", columnDefinition = "varchar(32) comment '业务员编码'")
//    private String es13;
//
//    @Column(name = "es14", columnDefinition = "varchar(32) comment '币种'")
//    private String es14;
//
//    @Column(name = "es15", columnDefinition = "decimal(18,8) comment '汇率'")
//    private BigDecimal es15;
//
//    @Column(name = "es16", columnDefinition = "varchar(32) comment '收款银行账户'")
//    private String es16;
//
//    @Column(name = "es17", columnDefinition = "varchar(32) comment '付款银行账户'")
//    private String es17;
//
//    @Column(name = "es18", columnDefinition = "bigint(20) comment '第三方应收单明细id'")
//    private Long es18;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecOrderDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RecOrderDtlDO entity = (RecOrderDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

}