package com.elitesland.fin.provider.invoice.await;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.param.invoice.InvoiceAwaitDSaveParam;
import com.elitesland.fin.param.invoice.InvoiceAwaitSaveParam;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.service.invoice.InvoiceAwaitRpcService;
import com.elitesland.fin.service.pay.PayRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.util.Strings;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + PayRpcService.PATH)
public class InvoiceAwaitRpcServiceImpl implements InvoiceAwaitRpcService {

    private final InvoiceAwaitSaveServiceFactory invoiceAwaitSaveServiceFactory;

    private final InvoiceAwaitRepo invoiceAwaitRepo;

    private final InvoiceAwaitDRepo invoiceAwaitDRepo;

    private final SystemRpcService systemRpcService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> save(InvoiceAwaitSaveParam param) {

        log.info("开始组装付款记录数据，接收到的参数为" + JSON.toJSONString(param));
        ApiResult<Long> result = checkSaveParam(param);
        if (ObjectUtil.isNotNull(result)) {
            return result;
        }
//        InvoiceAwaitTypeEnum strategyEnum;
//        try {
//            strategyEnum = InvoiceAwaitTypeEnum.valueOf(sourceType);
//        } catch (IllegalArgumentException e) {
//            log.warn("来源单据未定义，错误值：" + sourceType);
//            return ApiResult.fail("来源单据类型未定义");
//        }
//
//        log.info("来源单据转换成功，入参：" + sourceType + ",转换结果：" + strategyEnum.name());
//        InvoiceAwaitSaveService invoiceAwaitSaveService = invoiceAwaitSaveServiceFactory.initialService(strategyEnum);
//        Long aLong = invoiceAwaitSaveService.saveInvoiceAwait(param);
        Long id = saveInvoiceAwait(param);

        // TODO 匹配发票规则
        param.getOptDocType();
        param.getOptDocCls();
        param.getOptDocStatus();

        return ApiResult.ok(id);
    }

    private ApiResult<Long> checkSaveParam(InvoiceAwaitSaveParam param) {
        if (Strings.isEmpty(param.getOptDocType())) {
            return ApiResult.fail("来源单据类型不能为空");
        }

        if (Strings.isEmpty(param.getOptDocNo())) {
            return ApiResult.fail("来源单据编号不能为空");
        }
        if (Strings.isEmpty(param.getOptDocStatus())) {
            return ApiResult.fail("可开票状态不能为空");
        }

        if (invoiceAwaitRepo.existsByOptDocNoAndOptDocType(param.getOptDocNo(), param.getOptDocType())) {
            return ApiResult.fail("来源单据已经申请开过发票");
        }

        return null;
    }


    public Long saveInvoiceAwait(InvoiceAwaitSaveParam param) {

        InvoiceAwaitDO invoiceAwaitDO = InvoiceAwaitConvert.INSTANCE.saveParam2Do(param);
        // 通过发号器设置付款记录编号
        invoiceAwaitDO.setDocNo(systemRpcService.sysNumberRuleGenerateCode("yst-fin", "PAYMENT_RECORDS", new ArrayList<>()));
        // 来源单据：收货单
        Long masId = invoiceAwaitRepo.save(invoiceAwaitDO).getId();

        this.saveRecordsD(param, masId);

        return masId;
    }

    protected void saveRecordsD(InvoiceAwaitSaveParam saveVO, Long masId) {
        List<InvoiceAwaitDSaveParam> invoiceAwaitDSaveParamList = saveVO.getInvoiceAwaitDSaveParamList();
        List<InvoiceAwaitDDO> invoiceAwaitDDOS = InvoiceAwaitDConvert.INSTANCE.saveVOs2DOs(invoiceAwaitDSaveParamList);
        AtomicInteger lineNo = new AtomicInteger();
        invoiceAwaitDDOS.stream().forEach(ddo -> {
            ddo.setMasId(masId);
            ddo.setLineNo(lineNo.getAndIncrement());
        });
        // 删除旧的明细
        invoiceAwaitDRepo.deleteByMasId(masId);
        invoiceAwaitDRepo.saveAll(invoiceAwaitDDOS);
    }

}
