package com.elitesland.fin.repo.creditaccount;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditSettingParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditSettingDetailVO;
import com.elitesland.fin.entity.creditaccount.CreditSettingDO;
import com.elitesland.fin.entity.creditaccount.QCreditSettingDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Repository
public class CreditSettingRepoProc extends BaseRepoProc<CreditSettingDO> {

    private final static QCreditSettingDO Q_DO = QCreditSettingDO.creditSettingDO;

    protected CreditSettingRepoProc() {
        super(Q_DO);
    }


    public PagingVO<CreditSettingDetailVO> search(CreditSettingParam param) {
        Predicate predicate = commonBuilder(param).build();
        JPAQuery<CreditSettingDetailVO> jpaQuery = select(CreditSettingDetailVO.class).where(predicate);
        return PagingVO.<CreditSettingDetailVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                Q_DO.id,
                Q_DO.generalParam,
                Q_DO.extraParam,
                Q_DO.enableFlag,
                Q_DO.remark,
                Q_DO.createTime,
                Q_DO.creator,
                Q_DO.createUserId,
                Q_DO.modifyTime,
                Q_DO.modifyUserId,
                Q_DO.updater,
                Q_DO.tenantId
        )).from(Q_DO);
    }

    private PredicateBuilder commonBuilder(CreditSettingParam param) {
        return PredicateBuilder.builder();
    }


    public CreditSettingDetailVO detail(CreditSettingParam param) {
        Predicate predicate = commonBuilder(param).build();
        JPAQuery<CreditSettingDetailVO> jpaQuery = select(CreditSettingDetailVO.class).where(predicate);
        return jpaQuery.fetchOne();
    }

    public CreditSettingDetailVO findAll() {
        return select(CreditSettingDetailVO.class).from(Q_DO).fetchOne();
    }
}
