package com.elitesland.fin.utils.excel.convert;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class ExcelConverterManager {
    private final Map<Class<? extends Converter>, Converter> converterMap = new HashMap<>();
    
    private static ExcelConverterManager instance;
    
    public static ExcelConverterManager instance() {
        if(instance == null) {
            instance = new ExcelConverterManager();
        }
        return instance;
    }
    
    public Converter getConverter(Class<? extends Converter> clz) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if(converterMap.containsKey(clz)) {
            return converterMap.get(clz);
        }
        
        Converter converter = clz.getDeclaredConstructor().newInstance();
        converterMap.put(clz, converter);
        return converter;
    }
}
