/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.facade.excel.convert;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.utils.excel.convert.Converter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;

public class QuantityRoundConverter
implements Converter<BigDecimal, String> {
    private static final SystemRpcService systemRpcService = (SystemRpcService)SpringContextHolder.getBean(SystemRpcService.class);

    @Override
    public String convert(BigDecimal value) {
        SysSettingVO amountDecimalPlace;
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        if ((amountDecimalPlace = systemRpcService.findSysSettingByNo("QUANTITY_DECIMAL_PLACE")) == null) {
            return value.toString();
        }
        String settingVal = amountDecimalPlace.getSettingVal();
        if (settingVal == null || settingVal.equals("")) {
            return value.toPlainString();
        }
        int accuracy = Integer.parseInt(settingVal);
        return NumberUtils.toScaledBigDecimal((BigDecimal)value, (int)accuracy, (RoundingMode)RoundingMode.HALF_UP).toPlainString();
    }
}

