package com.elitesland.fin.application.facade.param.creditaccount;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 账户表;
 * @author : http://www.chiner.pro
 * @date : 2023-3-2
 */
@Data
@ApiModel(description = "账户快照查询参数")
public class CreditAccountSnapshotParam extends BaseModelParam {

    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;

    @ApiModelProperty("信用账户名称")
    private String creditAccountName;

    @ApiModelProperty("对象名称(客户组名称/客户名称)")
    private String objectName;

    @ApiModelProperty("对象编码")
    private String objectCode;

    @ApiModelProperty("快照开始时间")
    private LocalDateTime snapshotStartTime;

    @ApiModelProperty("快照结束时间")
    private LocalDateTime snapshotEndTime;

    private String keyWord;

}
