package com.elitesland.fin.domain.entity.apverconfig;

import cn.hutool.core.lang.Assert;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;


/**
 * @author zhiyu.he
 * @date 2022/4/6 15:17
 */
@Data
public class ApVerConfig {

    private Long id;

    private String schemeNo;

    private String schemeName;

    private Boolean enableFlag;

    private Boolean defaultFlag;

    private String remark;

    private String creator;

    private LocalDateTime createTime;

    private Long createUserId;

    private List<ApVerConfigDtl> configDtlSaveParamList;

    //校验非空
    public void checkNotNull() {
        if (id == null) {
            Assert.notNull(schemeName, "主键ID为空!");
            configDtlSaveParamList.forEach(dtl -> {
                dtl.checkNotNull(false);
            });
        } else {
            configDtlSaveParamList.forEach(dtl -> {
                dtl.checkNotNull(true);
            });
        }
        Assert.notNull(schemeName, "方案名称不能为空!");
    }

    //设置默认值
    public void defaultValue() {
        this.enableFlag = true;
    }
}
