package com.elitesland.fin.infr.repo.artype;

import com.elitesland.fin.domain.entity.artype.ArTypeOuDO;
import com.elitesland.fin.domain.entity.artype.QArTypeOuDO;
import com.elitesland.fin.domain.param.artype.ArTypeOuPageParam;
import com.elitesland.fin.infr.dto.artype.ArTypeOuDTO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.infr.repo.artype
 * @date 2022/4/11 15:30
 */
@Component
@RequiredArgsConstructor
public class ArTypeOuRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QArTypeOuDO qArTypeOuDO = QArTypeOuDO.arTypeOuDO;


    public <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qArTypeOuDO.id,
                qArTypeOuDO.arTypeId,
                qArTypeOuDO.ouCode,
                qArTypeOuDO.ouId,
                qArTypeOuDO.ouType,
                qArTypeOuDO.ouName)
        ).from(qArTypeOuDO);
    }

    public List<Long> queryByOuId(Long ouId) {
        return jpaQueryFactory.select(qArTypeOuDO.arTypeId)
                .from(qArTypeOuDO)
                .where(qArTypeOuDO.ouId.eq(ouId))
                .fetch();
    }

    public List<ArTypeOuDTO> queryByArTypeId(Long arTypeId) {
        return select(ArTypeOuDTO.class)
                .where(qArTypeOuDO.arTypeId.eq(arTypeId))
                .where(qArTypeOuDO.deleteFlag.eq(0))
                .fetch();
    }

    public PagingVO<ArTypeOuDTO> page(ArTypeOuPageParam arTypeOuPageParam) {

        List<Predicate> predicates = new ArrayList<>();

        if (StringUtils.isNotBlank(arTypeOuPageParam.getKeyWord())) {
            predicates.add(qArTypeOuDO.ouCode.like("%" + arTypeOuPageParam.getKeyWord() + "%").or(qArTypeOuDO.ouName.like("%" + arTypeOuPageParam.getKeyWord() + "%")));
        }
        if (null != arTypeOuPageParam.getArTypeId()) {
            predicates.add(qArTypeOuDO.arTypeId.eq(arTypeOuPageParam.getArTypeId()));
        }
        predicates.add(qArTypeOuDO.deleteFlag.eq(0));
        JPAQuery<ArTypeOuDTO> query = select(ArTypeOuDTO.class)
                .where(ExpressionUtils.allOf(predicates));

        arTypeOuPageParam.setPaging(query);
        arTypeOuPageParam.fillOrders(query, qArTypeOuDO);
        return new PagingVO<>(query.fetchCount(), query.fetch());
    }

    public Boolean existByApTypeIdOuId(ArTypeOuDO arTypeOuDO) {
        long res = jpaQueryFactory.select(qArTypeOuDO.id)
                .from(qArTypeOuDO)
                .where(qArTypeOuDO.arTypeId.eq(arTypeOuDO.getArTypeId()))
                .where(qArTypeOuDO.ouId.eq(arTypeOuDO.getOuId()))
                .where(qArTypeOuDO.deleteFlag.eq(0))
                .fetchCount();
        return res > 0;
    }

    public Long cancelOu(List<Long> ids) {
        long res = jpaQueryFactory.delete(qArTypeOuDO)
                .where(qArTypeOuDO.id.in(ids))
                .execute();
        return res;
    }
}
