package com.elitesland.fin.provider.generateaccountflow;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.facade.param.creditaccountflow.CreditAccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.service.creditaccountflow.CreditAccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.dto.generateaccountflow.GenerateAccountFlowRpcDTO;
import com.elitesland.fin.param.generateaccountflow.GenerateAccountFlowRpcParam;
import com.elitesland.fin.service.generateaccountflow.GenerateAccountFlowRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.account
 * @date 2023/3/7 14:00
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + GenerateAccountFlowRpcService.PATH)
@Slf4j
public class GenerateAccountFlowRpcServiceImpl implements GenerateAccountFlowRpcService {


    private final AccountFlowService accountFlowService;

    private final CreditAccountFlowService creditAccountFlowService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<List<GenerateAccountFlowRpcDTO>> generateAccountFlow(List<GenerateAccountFlowRpcParam> param) {
        log.info("开始调用生成账户流水:{}", JSON.toJSONString(param));

        checkRefundParam(param);

        List<GenerateAccountFlowRpcDTO> generateAccountFlowRpcDTOList = new ArrayList<>();
        generateAccountFlowRpcDTOList.addAll(buildAccountFlowParam(param).stream().map(item -> {
            String flowNo = accountFlowService.generateAccountFlow(item);
            GenerateAccountFlowRpcDTO generateAccountFlowRpcDTO = new GenerateAccountFlowRpcDTO();

            generateAccountFlowRpcDTO.setAccountType(item.getAccountType());
            generateAccountFlowRpcDTO.setAccountTypeName(item.getAccountTypeName());
            generateAccountFlowRpcDTO.setAccountCode(item.getAccountCode());
            generateAccountFlowRpcDTO.setAccountName(item.getAccountName());
            generateAccountFlowRpcDTO.setTime(LocalDateTime.now());
            generateAccountFlowRpcDTO.setFlowNo(flowNo);
            generateAccountFlowRpcDTO.setAmount(item.getSourceDocAmount());
            generateAccountFlowRpcDTO.setSourceId(item.getSourceId());
            return generateAccountFlowRpcDTO;
        }).collect(Collectors.toList()));

        generateAccountFlowRpcDTOList.addAll(buildCreditAccountFlowParam(param).stream().map(item ->{
            String flowNo = creditAccountFlowService.generateCreditAccountFlow(item);
            GenerateAccountFlowRpcDTO generateAccountFlowRpcDTO = new GenerateAccountFlowRpcDTO();

            generateAccountFlowRpcDTO.setAccountType(item.getCreditAccountType());
            generateAccountFlowRpcDTO.setAccountTypeName(item.getCreditAccountTypeName());
            generateAccountFlowRpcDTO.setAccountCode(item.getCreditAccountCode());
            generateAccountFlowRpcDTO.setAccountName(item.getCreditAccountName());
            generateAccountFlowRpcDTO.setTime(LocalDateTime.now());
            generateAccountFlowRpcDTO.setFlowNo(flowNo);
            generateAccountFlowRpcDTO.setAmount(item.getSourceDocAmount());
            generateAccountFlowRpcDTO.setSourceId(item.getSourceId());
            return generateAccountFlowRpcDTO;
        }).collect(Collectors.toList()));

        return ApiResult.ok(generateAccountFlowRpcDTOList);
    }

    void checkRefundParam(List<GenerateAccountFlowRpcParam> param) {
        Assert.notEmpty(param, "参数不能为空");
        param.stream().forEach(item -> {
            Assert.notEmpty(item.getAccountType(), "账户类型为空");
            Assert.notEmpty(item.getAccountName(), "账户名称为空");
            Assert.isTrue(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType()) ||
                    UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) ||
                    UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType()), "账户类型错误");
        });
    }

    private List<CreditAccountFlowParam> buildCreditAccountFlowParam(List<GenerateAccountFlowRpcParam> param) {

        List<CreditAccountFlowParam> creditAccountFlowParamList = param.stream()
                .filter(item -> UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getValueCode().equals(item.getAccountType()))
                .map(item -> {
                    CreditAccountFlowParam creditAccountFlowParam = new CreditAccountFlowParam();

                    creditAccountFlowParam.setSourceDoc(item.getDoc());
                    creditAccountFlowParam.setSourceDocType(item.getDocType());
                    creditAccountFlowParam.setSourceDocStatus(item.getDocStatus());
                    creditAccountFlowParam.setSourceDocAmount(item.getDocAmount());
                    creditAccountFlowParam.setSourceId(item.getSourceId());
                    creditAccountFlowParam.setSourceNo(item.getSourceNo());
                    creditAccountFlowParam.setCreditAccountType(item.getAccountType());
                    creditAccountFlowParam.setCreditAccountTypeName(item.getAccountTypeName());
                    creditAccountFlowParam.setCreditAccountCode(item.getAccountCode());
                    creditAccountFlowParam.setCreditAccountName(item.getAccountName());

                    return creditAccountFlowParam;
                }).collect(Collectors.toList());

        return creditAccountFlowParamList;
    }

    private List<AccountFlowParam> buildAccountFlowParam(List<GenerateAccountFlowRpcParam> param) {

        List<AccountFlowParam> accountFlowParamList = param.stream()
                .filter(item -> UdcEnum.ACCOUNT_TYPE_STORE.getValueCode().equals(item.getAccountType()) ||
                        UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode().equals(item.getAccountType()))
                .map(item -> {
                    AccountFlowParam accountFlowParam = new AccountFlowParam();

                    accountFlowParam.setSourceDoc(item.getDoc());
                    accountFlowParam.setSourceDocType(item.getDocType());
                    accountFlowParam.setSourceDocStatus(item.getDocStatus());
                    accountFlowParam.setSourceDocAmount(item.getDocAmount());
                    accountFlowParam.setSourceId(item.getSourceId());
                    accountFlowParam.setSourceNo(item.getSourceNo());
                    accountFlowParam.setAccountCode(item.getAccountCode());
                    accountFlowParam.setAccountType(item.getAccountType());
                    accountFlowParam.setAccountTypeName(item.getAccountTypeName());
                    accountFlowParam.setAccountName(item.getAccountName());

                    return accountFlowParam;
                }).collect(Collectors.toList());

        return accountFlowParamList;
    }
}
