package com.elitesland.fin.provider.paymentruleconfig;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.payment.PaymentRuleConfigConvert;
import com.elitesland.fin.application.convert.payment.PaymentRuleConfigDtlConvert;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import com.elitesland.fin.application.service.payment.PaymentRuleConfigService;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigDtlRpcDTO;
import com.elitesland.fin.param.paymentruleconfig.PaymentRuleConfigRpcParam;
import com.elitesland.fin.service.pay.PayRpcService;
import com.elitesland.fin.service.paymentruleconfig.PaymentRuleConfigRpcService;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.account
 * @date 2023/3/7 14:00
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + PaymentRuleConfigRpcService.PATH)
public class PaymentRuleConfigRpcServiceImpl implements PaymentRuleConfigRpcService {


    private final PaymentRuleConfigService paymentRuleConfigService;


    @Override
    public ApiResult<List<PaymentRuleConfigDtlRpcDTO>> queryAccountAmount(PaymentRuleConfigRpcParam param) {
        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList = paymentRuleConfigService
                .queryAccountAmount(PaymentRuleConfigConvert.INSTANCE.rpcParam2Param(param));

        return ApiResult.ok(PaymentRuleConfigDtlConvert.INSTANCE.DTO2RpcDTO(paymentRuleConfigDtlDTOList));
    }

    @Override
    public ApiResult<List<PaymentRuleConfigDtlRpcDTO>> pay(PaymentRuleConfigRpcParam param) {

        List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList = paymentRuleConfigService.pay(PaymentRuleConfigConvert.INSTANCE.rpcParam2Param(param));
        return ApiResult.ok(PaymentRuleConfigDtlConvert.INSTANCE.DTO2RpcDTO(paymentRuleConfigDtlDTOList));
    }
}
