package com.elitesland.fin.rpc.sale;

import cn.hutool.core.lang.Assert;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.sale.api.vo.param.crm.AllowShipCustGroupDParam;
import com.elitesland.sale.api.vo.resp.crm.AllowShipCustGroupDVO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.sale.constant.AllowShipCustGroupEnum;
import com.elitesland.sale.constant.AllowShipStatus;
import com.elitesland.sale.service.AllowShipRpcService;
import com.elitesland.sale.service.CrmCustRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class RmiSaleRpcServiceImpl implements RmiSaleRpcService {

    private final CrmCustRpcService crmCustRpcService;

    private final AllowShipRpcService allowShipRpcService;

    @Override
    public List<LmSaveCustRespVO> findInvCust(List<String> custCodeList) {
        ApiResult<List<LmSaveCustRespVO>> apiResult = crmCustRpcService.findInvCust(custCodeList);
        Assert.notNull(apiResult, "调用2B销售域查询主客户信息为空,客户编码{}", custCodeList);
        Assert.isTrue(apiResult.isSuccess(), "调用2B销售域查询主客户信息失败，客户编码{}", custCodeList);
        return apiResult.getData();
    }

    @Override
    public List<AllowShipCustGroupDVO> getCustGroupInfo(AllowShipCustGroupDParam param) {
        List<AllowShipCustGroupDVO> custGroupInfo;
        try {
            custGroupInfo = allowShipRpcService.getCustGroupInfo(param);
        } catch (Exception e) {
            log.error("调用销售域接口查询客户组信息失败, {}", e.getMessage());
            throw new BusinessException("调用销售域接口查询客户组信息失败");
        }
        return custGroupInfo;
    }

    @Override
    public String getCustGroupCodeByCustCode(String custCode) {
        AllowShipCustGroupDParam allowShipCustGroupDParam = new AllowShipCustGroupDParam();
        List<String> custCodes = new ArrayList<>();
        custCodes.add(custCode);
        allowShipCustGroupDParam.setCustCodes(custCodes);
        allowShipCustGroupDParam.setStatus(AllowShipStatus.ACTIVE.getType());
        allowShipCustGroupDParam.setType(AllowShipCustGroupEnum.CREIDT_ACCOUNT_GROUP.getType());

        List<AllowShipCustGroupDVO> allowShipCustGroupDVOList = allowShipRpcService.getCustGroupInfo(allowShipCustGroupDParam);

        if (CollectionUtils.isNotEmpty(allowShipCustGroupDVOList)) {
            String custGroupCode = allowShipCustGroupDVOList.get(0).getCode();
            Assert.notEmpty(custGroupCode, "查询客户组信息失败");
            return custGroupCode;
        }
        return custCode;
    }

    @Override
    public List<RmiOrgBankAccRpcVO> findBankAccByCustCode(String custCode) {
        List<RmiOrgBankAccRpcVO> bankAccRpcDtoByCustCode = null;
        try {
            bankAccRpcDtoByCustCode = crmCustRpcService.findBankAccRpcDtoByCustCode(custCode);
        } catch (Exception e) {
            log.error("调用销售域查询客户银行信息失败, {}", e.getMessage());
            throw new BusinessException("调用销售域查询客户银行信息失败");
        }

        return bankAccRpcDtoByCustCode;
    }
}
