/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.facade.excel.convert;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.utils.excel.convert.Converter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;

public class AmountRoundConverter
implements Converter<BigDecimal, String, Integer> {
    private static final SystemRpcService systemRpcService = (SystemRpcService)SpringContextHolder.getBean(SystemRpcService.class);
    private Integer accuracy;

    @Override
    public String convert(BigDecimal value) {
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        if (this.accuracy == null) {
            return value.toPlainString();
        }
        return NumberUtils.toScaledBigDecimal((BigDecimal)value, (int)this.accuracy, (RoundingMode)RoundingMode.HALF_UP).toPlainString();
    }

    @Override
    public Integer baseValue() {
        return this.accuracy;
    }

    @Override
    public Integer initBaseValue() {
        return this.setAmountAccuracyBySettingService();
    }

    @Override
    public Integer refreshBaseValue() {
        return this.setAmountAccuracyBySettingService();
    }

    private Integer setAmountAccuracyBySettingService() {
        SysSettingVO amountDecimalPlace = systemRpcService.findSysSettingByNo("AMOUNT_DECIMAL_PLACE");
        if (amountDecimalPlace != null && amountDecimalPlace.getSettingVal() != null && !amountDecimalPlace.getSettingVal().equals("")) {
            this.accuracy = Integer.parseInt(amountDecimalPlace.getSettingVal());
        }
        return this.accuracy;
    }
}

