/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.apverrec;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.apverrec.ApVerRecDtlConvert;
import com.elitesland.fin.application.facade.param.apverrec.ApVerRecParam;
import com.elitesland.fin.application.facade.vo.apverrec.ApVerRecDtlVO;
import com.elitesland.fin.application.service.apverrec.ApVerRecService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.apverrec.ApVerRecDtl;
import com.elitesland.fin.domain.param.apverrec.ApVerRecPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.apverconfig.ApVerConfigDomainService;
import com.elitesland.fin.domain.service.apverrec.ApVerRecDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.fin.infr.dto.apverrec.ApVerRecDtlDTO;
import com.elitesland.fin.infr.factory.apverrec.ApVerRecFactory;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApVerRecServiceImpl
implements ApVerRecService {
    private final ApVerRecDomainService apVerRecDomainService;
    private final ApVerConfigDomainService apVerConfigDomainService;
    private final ApOrderDomainService apOrderDomainService;
    private final PayOrderDomainService payOrderDomainService;
    private final ApVerRecFactory apVerRecFactory;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirm(ApVerRecParam param) {
        ApVerConfigDTO apVerConfigDTO = this.apVerConfigDomainService.queryById(param.getConfigId());
        if (apVerConfigDTO == null || !apVerConfigDTO.getEnableFlag().booleanValue()) {
            throw new BusinessException("\u8be5\u65b9\u6848[\u5e94\u4ed8\u6838\u9500\u65b9\u6848ID" + param.getConfigId() + "]\u4e0d\u5b58\u5728\u6216\u5df2\u505c\u7528");
        }
        List configDtlDTOList = apVerConfigDTO.getApVerConfigDtlDTOList().stream().filter(ApVerConfigDtlDTO::getMatchFlag).collect(Collectors.toList());
        Map<String, Class> conditions = configDtlDTOList.stream().collect(Collectors.toMap(ApVerConfigDtlDTO::getFieldNo, t -> {
            if (t.getFieldType().equals("String")) {
                return String.class;
            }
            if (t.getFieldType().equals("BigDecimal")) {
                return BigDecimal.class;
            }
            if (t.getFieldType().equals("LocalDateTime")) {
                return LocalDateTime.class;
            }
            if (t.getFieldType().equals("Long")) {
                return Long.class;
            }
            return String.class;
        }));
        param.getParams().forEach(s -> {
            s.setSchemeId(apVerConfigDTO.getId());
            s.setSchemeName(apVerConfigDTO.getSchemeName());
            s.setSchemeNo(apVerConfigDTO.getSchemeNo());
            s.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_MANU.getValueCode());
        });
        List<ApVerRecDtl> apVerRecDtls = ApVerRecDtlConvert.INSTANCE.convertList(param.getParams());
        Map<String, List<ApVerRecDtl>> listMap = apVerRecDtls.stream().collect(Collectors.groupingBy(t -> this.groupByCond(t, conditions)));
        for (Map.Entry<String, List<ApVerRecDtl>> entry : listMap.entrySet()) {
            this.apVerRecDomainService.save(entry.getValue());
        }
        apVerRecDtls.stream().forEach(t -> {
            if (t.getOrderType().equals("AP")) {
                this.apOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
            } else if (t.getOrderType().equals("PAY")) {
                this.payOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
            }
        });
    }

    @Override
    @SysCodeProc
    public PagingVO<ApVerRecDtlVO> page(ApVerRecPageParam pageParam) {
        PagingVO<ApVerRecDtlDTO> page = this.apVerRecFactory.page(pageParam);
        return ApVerRecDtlConvert.INSTANCE.convertPage(page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            throw new BusinessException("\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Set<Long> masIds = ids.stream().collect(Collectors.toSet());
        List<ApVerRecDtlDTO> recDtlDTOS = this.apVerRecDomainService.queryDtlByMasIds(masIds);
        if (CollUtil.isEmpty(recDtlDTOS)) {
            throw new BusinessException("\u5e94\u4ed8\u6838\u9500\u660e\u7ec6\u67e5\u8be2\u4e3a\u7a7a");
        }
        List<Long> dtlIds = recDtlDTOS.stream().map(ApVerRecDtlDTO::getId).collect(Collectors.toList());
        SysUserDTO user = SecurityContextUtil.currentUser().getUser();
        Long rows = this.apVerRecDomainService.logicDelByIds(masIds, user.getUsername(), user.getId());
        Long dtlRows = this.apVerRecDomainService.logicDelDtlByIds(dtlIds);
        if (rows.intValue() != masIds.size() || dtlRows.intValue() != dtlIds.size()) {
            throw new BusinessException("\u53d6\u6d88\u5e94\u4ed8\u6838\u9500\u5931\u8d25");
        }
        Map<Long, List<ApVerRecDtlDTO>> recDtlDTOMap = recDtlDTOS.stream().collect(Collectors.groupingBy(ApVerRecDtlDTO::getOrderId));
        for (Map.Entry<Long, List<ApVerRecDtlDTO>> entry : recDtlDTOMap.entrySet()) {
            String orderType = entry.getValue().get(0).getOrderType();
            BigDecimal amt = entry.getValue().stream().map(ApVerRecDtlDTO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add).negate();
            if (orderType.equals("AP")) {
                this.apOrderDomainService.updateVerAmt(entry.getKey(), amt);
                continue;
            }
            if (!orderType.equals("PAY")) continue;
            this.payOrderDomainService.updateVerAmt(entry.getKey(), amt);
        }
    }

    private String groupByCond(Object object, Map<String, ?> conditions) {
        StringBuilder key = new StringBuilder();
        for (Map.Entry<String, ?> cond : conditions.entrySet()) {
            Object fieldValue = ReflectUtil.getFieldValue((Object)object, (String)cond.getKey());
            if (cond.getValue().equals(LocalDateTime.class)) {
                key.append(((LocalDateTime)fieldValue).toLocalDate().toString()).append("&");
                continue;
            }
            key.append(fieldValue.toString()).append("&");
        }
        return key.toString();
    }

    public ApVerRecServiceImpl(ApVerRecDomainService apVerRecDomainService, ApVerConfigDomainService apVerConfigDomainService, ApOrderDomainService apOrderDomainService, PayOrderDomainService payOrderDomainService, ApVerRecFactory apVerRecFactory) {
        this.apVerRecDomainService = apVerRecDomainService;
        this.apVerConfigDomainService = apVerConfigDomainService;
        this.apOrderDomainService = apOrderDomainService;
        this.payOrderDomainService = payOrderDomainService;
        this.apVerRecFactory = apVerRecFactory;
    }
}

