/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.flowrepair;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.flowrepair.AccountFlowRepairHandle20DTO;
import com.elitesland.fin.application.facade.dto.flowrepair.AccountFlowRepairHandleDTO;
import com.elitesland.fin.application.facade.param.account.AccountSnapshotParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairPageParam;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairParam;
import com.elitesland.fin.application.facade.param.flowrepair.AccountFlowRepairRedoParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.facade.vo.flowrepair.AccountFlowRepairVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.application.service.flowrepair.AccountFlowRepairService;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.account.AccountSnapshotDO;
import com.elitesland.fin.entity.flowrepair.AccountFlowRepairDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.account.AccountSnapshotRepo;
import com.elitesland.fin.repo.flow.AccountFlowRepoProc;
import com.elitesland.fin.repo.flowrepair.AccountFlowRepairRepo;
import com.elitesland.fin.repo.flowrepair.AccountFlowRepairRepoProc;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountFlowRepairServiceImpl
implements AccountFlowRepairService {
    private static final Logger log = LoggerFactory.getLogger(AccountFlowRepairServiceImpl.class);
    @Autowired
    private AccountFlowRepairRepo accountFlowRepairRepo;
    @Autowired
    private AccountFlowRepairRepoProc accountFlowRepairRepoProc;
    @Autowired
    private AccountFlowService accountFlowService;
    @Autowired
    private AccountFlowRepoProc accountFlowRepoProc;
    @Autowired
    private AccountRepoProc accountRepoProc;
    @Autowired
    private AccountRepo accountRepo;
    @Autowired
    private AccountSnapshotRepo accountSnapshotRepo;
    @Autowired
    private AccountService accountService;
    private final RedissonClient redissonClient;
    @PersistenceContext
    private EntityManager entityManager;
    private final JdbcTemplate jdbcTemplate;
    private final NamedParameterJdbcTemplate namedTemplate;
    @Value(value="${spring.datasource.url}")
    private String dataUrl;
    @Value(value="${ext.jdbc-username}")
    private String userName;
    @Value(value="${ext.jdbc-pwd}")
    private String pwd;

    @Override
    @SysCodeProc
    public PagingVO<AccountFlowRepairVO> page(AccountFlowRepairPageParam pageParam) {
        PagingVO<AccountFlowRepairVO> pagingVO = this.accountFlowRepairRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(AccountFlowRepairParam param) {
        if (Objects.equals(param.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_10.getValueCode())) {
            this.saveFlowRepair10(param);
        } else if (Objects.equals(param.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_20.getValueCode())) {
            if (Objects.isNull(param.getId())) {
                this.saveFlowRepair20(param);
            } else {
                this.saveFlowRepair10(param);
            }
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u5339\u914d\u5230\u91cd\u7b97\u539f\u56e0!");
        }
    }

    private void saveFlowRepair10(AccountFlowRepairParam param) {
        if (Objects.equals(param.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_10.getValueCode())) {
            if (StringUtils.isBlank((CharSequence)param.getFlowNo())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (Objects.isNull(param.getActualAmount())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b9e\u9645\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
        }
        AccountFlowVO flowVO = this.selectFlowByFlowNo(param.getFlowNo());
        if (Objects.isNull(param.getId())) {
            AccountFlowRepairDO flowRepairDO = new AccountFlowRepairDO();
            this.assembleFlowRepair(flowRepairDO, param, flowVO);
            this.accountFlowRepairRepo.save((Object)flowRepairDO);
        } else {
            Optional flowRepairOptional = this.accountFlowRepairRepo.findById(param.getId());
            if (flowRepairOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6b64\u6761\u6d41\u6c34\u4fee\u590d\u6570\u636e!");
            }
            AccountFlowRepairDO flowRepairDO = (AccountFlowRepairDO)((Object)flowRepairOptional.get());
            if (!Objects.equals(flowRepairDO.getRepairStatus(), UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8349\u7a3f\u72b6\u6001\u624d\u53ef\u4fee\u6539!");
            }
            this.assembleFlowRepair(flowRepairDO, param, flowVO);
            this.accountFlowRepairRepo.save((Object)flowRepairDO);
        }
    }

    private void assembleFlowRepair(AccountFlowRepairDO flowRepairDO, AccountFlowRepairParam param, AccountFlowVO flowVO) {
        if (StringUtils.isNotBlank((CharSequence)param.getFlowNo())) {
            flowRepairDO.setFlowNo(param.getFlowNo());
        }
        if (Objects.nonNull(param.getActualAmount())) {
            flowRepairDO.setActualAmount(param.getActualAmount());
        }
        flowRepairDO.setAmount(flowVO.getAmount());
        flowRepairDO.setOpenAccountEntityCode(null);
        flowRepairDO.setOpenAccountEntityName(flowVO.getAccountHolderName());
        flowRepairDO.setAccountType(flowVO.getAccountType());
        flowRepairDO.setAccountCode(flowVO.getAccountCode());
        flowRepairDO.setAccountName(flowVO.getAccountName());
        flowRepairDO.setSourceNo(flowVO.getSourceNo());
        flowRepairDO.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
        if (StringUtils.isNotBlank((CharSequence)param.getRecalculationReason())) {
            flowRepairDO.setRecalculationReason(param.getRecalculationReason());
        }
        if (Objects.nonNull(param.getRecalculationDate())) {
            flowRepairDO.setRecalculationDate(param.getRecalculationDate());
        }
    }

    private AccountFlowVO selectFlowByFlowNo(String flowNo) {
        if (StringUtils.isBlank((CharSequence)flowNo)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
        }
        AccountFlowQueryParam flowQueryParam = new AccountFlowQueryParam();
        flowQueryParam.setFlowNo(flowNo);
        List<AccountFlowVO> flowVOList = this.accountFlowService.selectListByQueryParam(flowQueryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6b64\u6d41\u6c34\u53f7(" + flowNo + ")\u7684\u6d41\u6c34\u4fe1\u606f!");
        }
        if (CollectionUtils.isNotEmpty(flowVOList) && flowVOList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6b64\u6d41\u6c34\u53f7(" + flowNo + ")\u7684\u5b58\u5728\u591a\u6761\u6d41\u6c34\u4fe1\u606f!");
        }
        return flowVOList.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        AccountFlowRepairPageParam flowRepairPageParam = new AccountFlowRepairPageParam();
        flowRepairPageParam.setIds(ids);
        List<AccountFlowRepairVO> respVOList = this.accountFlowRepairRepoProc.selectListByParam(flowRepairPageParam);
        if (CollectionUtils.isEmpty(respVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u6570\u636e\u4fe1\u606f!");
        }
        List voList = respVOList.stream().filter(respVO -> !Objects.equals(respVO.getRepairStatus(), UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(voList)) {
            String checkResult = voList.stream().map(vo -> "\u6d41\u6c34\u53f7:" + vo.getFlowNo()).collect(Collectors.joining(";", "\u53ea\u6709\u8349\u7a3f\u53ef\u5220\u9664,[", "], \u8bf7\u68c0\u67e5"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        this.accountFlowRepairRepoProc.updateDeleteFlagBatch(1, ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void repairRedo(AccountFlowRepairRedoParam repairRedoParam) {
        AccountFlowRepairPageParam flowRepairPageParam = new AccountFlowRepairPageParam();
        flowRepairPageParam.setIds(repairRedoParam.getIds());
        flowRepairPageParam.setFlowNoList(repairRedoParam.getFlowNoList());
        flowRepairPageParam.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
        List<AccountFlowRepairVO> repairFlowVOList = this.accountFlowRepairRepoProc.selectListByParam(flowRepairPageParam);
        if (CollectionUtils.isEmpty(repairFlowVOList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u7b26\u5408\u91cd\u7b97\u7684\u8d26\u6237\u6d41\u6c34\u6570\u636e!");
        }
        List flowNoCheckList = repairFlowVOList.stream().filter(repairParam -> !StringUtils.isBlank((CharSequence)repairParam.getFlowNo())).map(AccountFlowRepairVO::getFlowNo).collect(Collectors.toMap(e -> e, e -> 1, (a, b) -> a + b)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(flowNoCheckList)) {
            String checkResult = flowNoCheckList.stream().map(Objects::toString).collect(Collectors.joining("\u3001", "\u8d26\u6237\u6d41\u6c34\u53f7[", "], \u5b58\u5728\u91cd\u590d\u6570\u636e,\u8bf7\u68c0\u67e5!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        List<String> repairFlowNoList = repairFlowVOList.stream().map(AccountFlowRepairVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(repairFlowNoList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u7b97\u7684\u8d26\u6237\u6d41\u6c34\u6570\u636e\u7684\u6d41\u6c34\u53f7\u4e3a\u7a7a!");
        }
        ArrayList repairFlowNoCacheList = new ArrayList();
        repairFlowNoList.forEach(flowNo -> {
            if (StringUtils.isNotBlank((CharSequence)this.getFlowNoCache((String)flowNo))) {
                repairFlowNoCacheList.add(flowNo);
            } else {
                this.saveFlowNoCache((String)flowNo);
            }
        });
        if (CollectionUtils.isNotEmpty(repairFlowNoCacheList)) {
            String checkResult = repairFlowNoCacheList.stream().map(Objects::toString).collect(Collectors.joining("\u3001", "\u8d26\u6237\u6d41\u6c34\u53f7[", "], \u4fee\u590d\u91cd\u7b97\u4e2d,\u8bf7\u7a0d\u540e\u518d\u6b21\u91cd\u7b97!"));
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, checkResult);
        }
        if (CollectionUtils.isNotEmpty(repairFlowVOList)) {
            List<AccountFlowRepairVO> repairFlow20List;
            List<AccountFlowRepairVO> repairFlow10List = repairFlowVOList.stream().filter(accountFlowRepairVO -> Objects.equals(accountFlowRepairVO.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_10.getValueCode())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(repairFlow10List)) {
                List<String> repairFlowNo10List = repairFlow10List.stream().map(AccountFlowRepairVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                this.processingCalculation(repairFlow10List, repairFlowNo10List);
            }
            if (CollectionUtil.isNotEmpty(repairFlow20List = repairFlowVOList.stream().filter(accountFlowRepairVO -> Objects.equals(accountFlowRepairVO.getRecalculationReason(), UdcEnum.FLOW_RECALCUL_REASON_20.getValueCode())).collect(Collectors.toList()))) {
                List<String> repairFlowNo20List = repairFlow20List.stream().map(AccountFlowRepairVO::getFlowNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                this.processingCalculation20(repairFlow20List, repairFlowNo20List);
            }
        }
    }

    @Override
    public void removeFlowNoCacheBatch(List<String> flowNoList) {
        flowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    @Override
    public void removeFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        if (bucket.isExists()) {
            bucket.delete();
        }
    }

    @Override
    public String getFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        if (bucket.isExists()) {
            return (String)bucket.get();
        }
        return null;
    }

    @Override
    public void saveFlowNoCache(String flowNo) {
        RBucket bucket = this.redissonClient.getBucket("YST_FIN_ACCOUNT_FLOW_REPAIR_KEY_" + flowNo);
        bucket.set((Object)flowNo);
    }

    private void processingCalculation(List<AccountFlowRepairVO> repairFlowVOList, List<String> repairFlowNoList) {
        ArrayList accCodeList = new ArrayList();
        repairFlowVOList.forEach(flowRepairVO -> {
            AccountFlowQueryParam flowQueryParam = new AccountFlowQueryParam();
            flowQueryParam.setFlowNo(flowRepairVO.getFlowNo());
            log.info("\u4fee\u590d\u91cd\u7b97\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)((Object)flowQueryParam)));
            List<AccountFlowVO> flowVOList = this.accountFlowService.selectListByQueryParam(flowQueryParam);
            log.info("\u4fee\u590d\u91cd\u7b97\u8d26\u6237\u6d41\u6c34\u67e5\u8be2\u6570\u636e,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
            if (CollectionUtils.isNotEmpty(flowVOList) && flowVOList.size() == 1) {
                if (Objects.nonNull(flowVOList.get(0))) {
                    AccountFlowVO flowVO = flowVOList.get(0);
                    if (Objects.equals(flowVO.getAccountType(), UdcEnum.ACCOUNT_TYPE_STORE.getValueCode()) && FinConstant.ACCOUNT_FLOW_REPAIR_TRANSACTION_TYPE.contains(flowVO.getTransactionType())) {
                        this.repairFlow((AccountFlowRepairVO)flowRepairVO, flowVO, accCodeList);
                    } else if (Objects.equals(flowVO.getAccountType(), UdcEnum.ACCOUNT_TYPE_FLZH.getValueCode()) && FinConstant.ACCOUNT_FLOW_REPAIR_TRANSACTION_TYPE.contains(flowVO.getTransactionType())) {
                        this.repairFlow((AccountFlowRepairVO)flowRepairVO, flowVO, accCodeList);
                    } else {
                        log.info("\u672a\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
                    }
                } else {
                    log.info("\u672a\u67e5\u8be2\u5230\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowRepairVO));
                }
            } else {
                log.info("\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e\u4e3a\u7a7a\u6216\u8005\u6709\u591a\u6761,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowVOList));
            }
        });
        if (CollectionUtils.isNotEmpty(accCodeList)) {
            List<String> accCodes = accCodeList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this.updateAccountAmt(accCodes, repairFlowNoList);
        }
        repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void repairFlow(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, List<String> accCodeList) {
        this.repairCurrentFlow(flowRepairVO, flowVO, accCodeList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAccountAmt(List<String> accCodeList, List<String> repairFlowNoList) {
        accCodeList.forEach(accCode -> {
            AccountFlowQueryParam flowQueryParam = new AccountFlowQueryParam();
            flowQueryParam.setAccountCode((String)accCode);
            AccountFlowVO flowVO = this.accountFlowRepoProc.selectPreviousRepairAmtByParam(flowQueryParam);
            AccountDO accountDO = this.accountRepoProc.findByAccountCode((String)accCode);
            if (Objects.nonNull(flowVO) && Objects.nonNull((Object)accountDO)) {
                BigDecimal accountAmount = flowVO.getAccountAmount();
                BigDecimal accountOccupancyAmount = flowVO.getAccountOccupancyAmount();
                accountDO.setAccountAmount(accountAmount);
                accountDO.setAccountOccupancyAmount(accountOccupancyAmount);
                accountDO.setAccountAvailableAmount(accountAmount.subtract(accountOccupancyAmount));
                this.accountRepo.save((Object)accountDO);
            } else if (Objects.isNull((Object)accountDO)) {
                repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u67e5\u8be2\u5230\u8d26\u6237(" + accCode + ")\u4fe1\u606f!");
            }
        });
    }

    public void repairCurrentFlow(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, List<String> accCodeList) {
        AccountFlowRepairHandleDTO flowRepairHandleDTO = this.assembleRepairHandle(flowRepairVO, flowVO);
        if (Objects.nonNull(flowRepairHandleDTO)) {
            this.repairCalculationFlow(flowRepairHandleDTO, accCodeList);
            this.accountFlowRepairRepoProc.updateAmountAndRepairStatusById(flowRepairHandleDTO.getAmount(), UdcEnum.FLOW_REPAIR_STATUS_FIXED.getValueCode(), flowRepairHandleDTO.getFlowRepairId());
            this.repairAfterFlow(flowRepairVO, flowVO, flowRepairHandleDTO, accCodeList);
        }
    }

    public void repairAfterFlow(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, AccountFlowRepairHandleDTO flowRepairCurrentHandleDTO, List<String> accCodeList) {
        List<AccountFlowRepairHandleDTO> flowRepairHandleList = this.selectRepairAfterFlow(flowRepairVO, flowVO, flowRepairCurrentHandleDTO);
        if (CollectionUtils.isNotEmpty(flowRepairHandleList)) {
            flowRepairHandleList.forEach(flowRepairHandleDTO -> this.repairCalculationFlowAfter((AccountFlowRepairHandleDTO)flowRepairHandleDTO, accCodeList));
        }
    }

    public List<AccountFlowRepairHandleDTO> selectRepairAfterFlow(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, AccountFlowRepairHandleDTO flowRepairCurrentHandleDTO) {
        List<AccountFlowVO> flowAfterList;
        int size = 500;
        int page = 1;
        ArrayList<AccountFlowRepairHandleDTO> flowRepairHandleList = new ArrayList<AccountFlowRepairHandleDTO>();
        AccountFlowPageParam flowPageParam = new AccountFlowPageParam();
        flowPageParam.setAccountCode(flowVO.getAccountCode());
        flowPageParam.setRepairTime(flowVO.getAuditDate());
        do {
            flowPageParam.setCurrent(page++);
            flowPageParam.setSize(size);
            log.info("\u67e5\u8be2\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u53ca\u4e4b\u540e\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)((Object)flowPageParam)));
            flowAfterList = this.accountFlowService.selectRepairAfterPage(flowPageParam);
            log.info("\u67e5\u8be2\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u53ca\u4e4b\u540e\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u51fa\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString(flowAfterList));
            if (CollectionUtils.isEmpty(flowAfterList)) break;
            flowAfterList.forEach(flowAfterVO -> {
                AccountFlowRepairHandleDTO flowRepairHandleDTO = this.assembleRepairAfterHandle(flowRepairVO, (AccountFlowVO)flowAfterVO, flowRepairCurrentHandleDTO);
                if (Objects.nonNull(flowRepairHandleDTO)) {
                    flowRepairHandleList.add(flowRepairHandleDTO);
                } else {
                    log.info("\u6309\u7167\u4ea4\u6613\u7c7b\u578b\u672a\u5339\u914d\u5230\u8d26\u6237\u6d41\u6c34,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowAfterList));
                }
            });
        } while (flowAfterList.size() >= size);
        return flowRepairHandleList;
    }

    private AccountFlowRepairHandleDTO assembleRepairHandle(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO) {
        if (Objects.isNull(flowRepairVO.getActualAmount()) || Objects.isNull(flowVO.getAccountAmount()) || Objects.isNull(flowVO.getAccountOccupancyAmount()) || Objects.isNull(flowVO.getAmount())) {
            log.info("\u672a\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
            return null;
        }
        AccountFlowRepairHandleDTO flowRepairHandleDTO = new AccountFlowRepairHandleDTO();
        flowRepairHandleDTO.setFlowRepairId(flowRepairVO.getId());
        flowRepairHandleDTO.setFlowRepairFlowNo(flowRepairVO.getFlowNo());
        flowRepairHandleDTO.setFlowId(flowVO.getId());
        flowRepairHandleDTO.setFlowNo(flowVO.getFlowNo());
        flowRepairHandleDTO.setActualAmount(flowRepairVO.getActualAmount());
        flowRepairHandleDTO.setAmount(flowVO.getAmount());
        BigDecimal variableAmount = flowRepairVO.getActualAmount().subtract(flowVO.getAmount());
        flowRepairHandleDTO.setVariableAmount(variableAmount);
        flowRepairHandleDTO.setAccountType(flowVO.getAccountType());
        flowRepairHandleDTO.setAccountCode(flowVO.getAccountCode());
        flowRepairHandleDTO.setAccountName(flowVO.getAccountName());
        flowRepairHandleDTO.setTransactionType(flowVO.getTransactionType());
        flowRepairHandleDTO.setAccountAmount(flowVO.getAccountAmount());
        flowRepairHandleDTO.setAccountOccupancyAmount(flowVO.getAccountOccupancyAmount());
        flowRepairHandleDTO.setAccountAvailableAmount(flowVO.getAccountAvailableAmount());
        return flowRepairHandleDTO;
    }

    private AccountFlowRepairHandleDTO assembleRepairAfterHandle(AccountFlowRepairVO flowRepairVO, AccountFlowVO flowVO, AccountFlowRepairHandleDTO flowRepairCurrentHandleDTO) {
        if (Objects.isNull(flowRepairVO.getActualAmount()) || Objects.isNull(flowVO.getAccountAmount()) || Objects.isNull(flowVO.getAccountOccupancyAmount()) || Objects.isNull(flowVO.getAmount())) {
            log.info("\u672a\u4fee\u590d\u8d26\u6237\u6d41\u6c34\u6570\u636e,\u65f6\u95f4\uff1a{},\u53c2\u6570\uff1a{}", (Object)LocalDateTime.now(), (Object)JSON.toJSONString((Object)flowVO));
            return null;
        }
        AccountFlowRepairHandleDTO flowRepairHandleDTO = new AccountFlowRepairHandleDTO();
        flowRepairHandleDTO.setFlowRepairId(flowRepairVO.getId());
        flowRepairHandleDTO.setFlowRepairFlowNo(flowRepairVO.getFlowNo());
        flowRepairHandleDTO.setFlowId(flowVO.getId());
        flowRepairHandleDTO.setFlowNo(flowVO.getFlowNo());
        flowRepairHandleDTO.setActualAmount(flowRepairVO.getActualAmount());
        flowRepairHandleDTO.setAmount(flowVO.getAmount());
        BigDecimal variableAmount = flowRepairCurrentHandleDTO.getVariableAmount();
        flowRepairHandleDTO.setVariableAmount(variableAmount);
        flowRepairHandleDTO.setAccountType(flowVO.getAccountType());
        flowRepairHandleDTO.setAccountCode(flowVO.getAccountCode());
        flowRepairHandleDTO.setAccountName(flowVO.getAccountName());
        flowRepairHandleDTO.setTransactionType(flowRepairCurrentHandleDTO.getTransactionType());
        flowRepairHandleDTO.setAccountAmount(flowVO.getAccountAmount());
        flowRepairHandleDTO.setAccountOccupancyAmount(flowVO.getAccountOccupancyAmount());
        flowRepairHandleDTO.setAccountAvailableAmount(flowVO.getAccountAvailableAmount());
        return flowRepairHandleDTO;
    }

    public void repairCalculationFlow(AccountFlowRepairHandleDTO flowRepairHandleDTO, List<String> accCodeList) {
        BigDecimal accountAmount = flowRepairHandleDTO.getAccountAmount();
        BigDecimal accountOccupancyAmount = flowRepairHandleDTO.getAccountOccupancyAmount();
        BigDecimal accountAvailableAmount = BigDecimal.ZERO;
        BigDecimal variableAmount = flowRepairHandleDTO.getVariableAmount();
        BigDecimal actualAmount = flowRepairHandleDTO.getActualAmount();
        if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_R.getValueCode())) {
            accountOccupancyAmount = accountOccupancyAmount.subtract(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateOccupancyAndAvailableAndAmountById(accountOccupancyAmount, accountAvailableAmount, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_T.getValueCode())) {
            accountOccupancyAmount = accountOccupancyAmount.add(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateOccupancyAndAvailableAndAmountById(accountOccupancyAmount, accountAvailableAmount, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_O.getValueCode())) {
            accountAmount = accountAmount.subtract(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateAccountAndAvailableAndAmountById(accountAmount, accountAvailableAmount, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_I.getValueCode())) {
            accountAmount = accountAmount.add(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateAccountAndAvailableAndAmountById(accountAmount, accountAvailableAmount, actualAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        }
    }

    public void repairCalculationFlowAfter(AccountFlowRepairHandleDTO flowRepairHandleDTO, List<String> accCodeList) {
        BigDecimal accountAmount = flowRepairHandleDTO.getAccountAmount();
        BigDecimal accountOccupancyAmount = flowRepairHandleDTO.getAccountOccupancyAmount();
        BigDecimal accountAvailableAmount = BigDecimal.ZERO;
        BigDecimal variableAmount = flowRepairHandleDTO.getVariableAmount();
        if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_R.getValueCode())) {
            accountOccupancyAmount = accountOccupancyAmount.subtract(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateOccupancyAndAvailableById(accountOccupancyAmount, accountAvailableAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_T.getValueCode())) {
            accountOccupancyAmount = accountOccupancyAmount.add(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateOccupancyAndAvailableById(accountOccupancyAmount, accountAvailableAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_O.getValueCode())) {
            accountAmount = accountAmount.subtract(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateAccountAndAvailableById(accountAmount, accountAvailableAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        } else if (Objects.equals(flowRepairHandleDTO.getTransactionType(), UdcEnum.IO_TYPE_I.getValueCode())) {
            accountAmount = accountAmount.add(variableAmount);
            accountAvailableAmount = accountAmount.subtract(accountOccupancyAmount);
            this.accountFlowRepoProc.updateAccountAndAvailableById(accountAmount, accountAvailableAmount, flowRepairHandleDTO.getFlowId());
            accCodeList.add(flowRepairHandleDTO.getAccountCode());
        }
    }

    private void saveFlowRepair20(AccountFlowRepairParam param) {
        List<AccountFlowRepairHandle20DTO> flRepairHandle22List;
        List<AccountFlowRepairHandle20DTO> czRepairHandle22List;
        String accountCode = param.getAccountCode();
        LocalDateTime recalculationDate = param.getRecalculationDate();
        ArrayList<AccountFlowRepairDO> repairDoAllList = new ArrayList<AccountFlowRepairDO>();
        ArrayList<AccountFlowRepairHandle20DTO> czRepairHandleAllList = new ArrayList<AccountFlowRepairHandle20DTO>();
        List<AccountFlowRepairHandle20DTO> czRepairHandle21List = this.czAppendSql21(accountCode, recalculationDate);
        if (CollectionUtil.isNotEmpty(czRepairHandle21List)) {
            czRepairHandleAllList.addAll(czRepairHandle21List);
        }
        if (CollectionUtil.isNotEmpty(czRepairHandle22List = this.czAppendSql22(accountCode, recalculationDate))) {
            czRepairHandleAllList.addAll(czRepairHandle22List);
        }
        this.assembleHandleFlowRepair20(param, czRepairHandleAllList, repairDoAllList);
        ArrayList<AccountFlowRepairHandle20DTO> flRepairHandleAllList = new ArrayList<AccountFlowRepairHandle20DTO>();
        List<AccountFlowRepairHandle20DTO> flRepairHandle21List = this.flAppendSql21(accountCode, recalculationDate);
        if (CollectionUtil.isNotEmpty(flRepairHandle21List)) {
            flRepairHandleAllList.addAll(flRepairHandle21List);
        }
        if (CollectionUtil.isNotEmpty(flRepairHandle22List = this.flAppendSql22(accountCode, recalculationDate))) {
            flRepairHandleAllList.addAll(flRepairHandle22List);
        }
        this.assembleHandleFlowRepair20(param, flRepairHandleAllList, repairDoAllList);
        if (CollectionUtil.isNotEmpty(repairDoAllList)) {
            this.accountFlowRepairRepo.saveAll(repairDoAllList);
        }
    }

    private void assembleHandleFlowRepair20(AccountFlowRepairParam param, List<AccountFlowRepairHandle20DTO> repairHandleAllList, List<AccountFlowRepairDO> repairDoAllList) {
        if (CollectionUtil.isNotEmpty(repairHandleAllList)) {
            Map<String, List<AccountFlowRepairHandle20DTO>> czRepairHandleAllMap = repairHandleAllList.stream().collect(Collectors.groupingBy(i -> i.getAccountCode()));
            czRepairHandleAllMap.forEach((key, value) -> {
                AccountFlowRepairHandle20DTO repairHandle20DTO = value.stream().min((u1, u2) -> u1.getAuditDate().compareTo(u2.getAuditDate())).orElse(null);
                if (Objects.isNull(repairHandle20DTO)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6b64\u8d26\u6237(" + key + ")\u672a\u5339\u914d\u5230\u6700\u65e9\u5ba1\u6838\u65f6\u95f4\u7684\u6570\u636e!");
                }
                AccountFlowRepairDO flowRepairDO = new AccountFlowRepairDO();
                this.assembleFlowRepair20(flowRepairDO, param, repairHandle20DTO);
                repairDoAllList.add(flowRepairDO);
            });
        }
    }

    private void assembleFlowRepair20(AccountFlowRepairDO flowRepairDO, AccountFlowRepairParam param, AccountFlowRepairHandle20DTO repairHandle20DTO) {
        flowRepairDO.setFlowNo(repairHandle20DTO.getFlowNo());
        flowRepairDO.setActualAmount(repairHandle20DTO.getAmount());
        flowRepairDO.setAmount(repairHandle20DTO.getAmount());
        flowRepairDO.setOpenAccountEntityCode(null);
        flowRepairDO.setOpenAccountEntityName(repairHandle20DTO.getAccountHolderName());
        flowRepairDO.setAccountType(repairHandle20DTO.getAccountType());
        flowRepairDO.setAccountCode(repairHandle20DTO.getAccountCode());
        flowRepairDO.setAccountName(repairHandle20DTO.getAccountName());
        flowRepairDO.setSourceNo(repairHandle20DTO.getSourceNo());
        flowRepairDO.setRepairStatus(UdcEnum.FLOW_REPAIR_STATUS_DRAFT.getValueCode());
        if (StringUtils.isNotBlank((CharSequence)param.getRecalculationReason())) {
            flowRepairDO.setRecalculationReason(param.getRecalculationReason());
        }
        if (Objects.nonNull(param.getRecalculationDate())) {
            flowRepairDO.setRecalculationDate(param.getRecalculationDate());
        } else {
            flowRepairDO.setRecalculationDate(repairHandle20DTO.getPrevAuditDate());
        }
    }

    private List<AccountFlowRepairHandle20DTO> czAppendSql21(String accountCode, LocalDateTime recalculationDate) {
        StringBuilder sqlWhereBuffer = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Object> args = new ArrayList<Object>();
        this.appendWhere(accountCode, recalculationDate, sqlWhereBuffer, params, args);
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("select b.* from \n        (select \n        account_code,account_name,account_type,transaction_type,account_holder_name, \n        flow_no,amount,account_amount,account_occupancy_amount,account_available_amount,audit_date,source_no, \n        prev_account_occupancy_amount, \n        prev_flow_no, \n        prev_audit_date, \n        if(prev_account_occupancy_amount is null,0,prev_account_occupancy_amount  - account_occupancy_amount) difference_value \n        from \n                (select A.*, \n                        lag(account_occupancy_amount, 1,0) over(partition by account_code order by audit_date) prev_account_occupancy_amount, \n                        lag(flow_no, 1) over(partition by account_code order by audit_date) prev_flow_no, \n                        lag(audit_date, 1) over(partition by account_code order by audit_date) prev_audit_date \n                from \n                        account_flow as A \n                         where \n                                A.delete_flag = 0 \n                                and A.transaction_type in ('T','R') \n                               and A.account_type in ('STORE') \n                               and A.audit_date is not null \n" + sqlWhereBuffer + "                ) T \n        ) b \nwhere \n        abs(b.difference_value) != abs(b.amount) \n       order by b.audit_date ");
        List accountFlowRepairHandle20DTOList = this.namedTemplate.query(sqlBuffer.toString(), params, (RowMapper)new BeanPropertyRowMapper(AccountFlowRepairHandle20DTO.class));
        return accountFlowRepairHandle20DTOList;
    }

    private List<AccountFlowRepairHandle20DTO> czAppendSql22(String accountCode, LocalDateTime recalculationDate) {
        StringBuilder sqlWhereBuffer = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Object> args = new ArrayList<Object>();
        this.appendWhere(accountCode, recalculationDate, sqlWhereBuffer, params, args);
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("select b.* from \n        (select \n        account_code,account_name,account_type,transaction_type,account_holder_name, \n        flow_no,amount,account_amount,account_occupancy_amount,account_available_amount,audit_date,source_no, \n        prev_account_amount, \n        prev_flow_no, \n        prev_audit_date, \n        if(prev_account_amount is null,0,prev_account_amount - account_amount) difference_value \n        from \n                (select A.*, \n                        lag(account_amount, 1,0) over(partition by account_code order by audit_date) prev_account_amount, \n                        lag(flow_no, 1) over(partition by account_code order by audit_date) prev_flow_no, \n                        lag(audit_date, 1) over(partition by account_code order by audit_date) prev_audit_date \n                from \n                        account_flow as A \n                         where \n                                A.delete_flag = 0 \n                                and A.transaction_type in ('I','O') \n                               and A.account_type in ('STORE') \n                               and A.audit_date is not null \n" + sqlWhereBuffer + "                ) T \n        ) b \nwhere \n        abs(b.difference_value) != abs(b.amount) \n       order by b.audit_date");
        List accountFlowRepairHandle20DTOList = this.namedTemplate.query(sqlBuffer.toString(), params, (RowMapper)new BeanPropertyRowMapper(AccountFlowRepairHandle20DTO.class));
        return accountFlowRepairHandle20DTOList;
    }

    private List<AccountFlowRepairHandle20DTO> flAppendSql21(String accountCode, LocalDateTime recalculationDate) {
        StringBuilder sqlWhereBuffer = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Object> args = new ArrayList<Object>();
        this.appendWhere(accountCode, recalculationDate, sqlWhereBuffer, params, args);
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("select b.* from \n        (select \n        account_code,account_name,account_type,transaction_type,account_holder_name, \n        flow_no,amount,account_amount,account_occupancy_amount,account_available_amount,audit_date,source_no, \n        prev_account_occupancy_amount, \n        prev_flow_no, \n        prev_audit_date, \n        if(prev_account_occupancy_amount is null,0,prev_account_occupancy_amount  - account_occupancy_amount) difference_value \n        from \n                (select A.*, \n                        lag(account_occupancy_amount, 1,0) over(partition by account_code order by audit_date) prev_account_occupancy_amount, \n                        lag(flow_no, 1) over(partition by account_code order by audit_date) prev_flow_no, \n                        lag(audit_date, 1) over(partition by account_code order by audit_date) prev_audit_date \n                from \n                        account_flow as A \n                         where \n                                A.delete_flag = 0 \n                                and A.transaction_type in ('T','R') \n                               and A.account_type in ('FLZH') \n                               and A.audit_date is not null \n" + sqlWhereBuffer + "                ) T \n        ) b \nwhere \n        abs(b.difference_value) != abs(b.amount) \n       order by b.audit_date ");
        List accountFlowRepairHandle20DTOList = this.namedTemplate.query(sqlBuffer.toString(), params, (RowMapper)new BeanPropertyRowMapper(AccountFlowRepairHandle20DTO.class));
        return accountFlowRepairHandle20DTOList;
    }

    private List<AccountFlowRepairHandle20DTO> flAppendSql22(String accountCode, LocalDateTime recalculationDate) {
        StringBuilder sqlWhereBuffer = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Object> args = new ArrayList<Object>();
        this.appendWhere(accountCode, recalculationDate, sqlWhereBuffer, params, args);
        StringBuilder sqlBuffer = new StringBuilder();
        sqlBuffer.append("select b.* from \n        (select \n        account_code,account_name,account_type,transaction_type,account_holder_name, \n        flow_no,amount,account_amount,account_occupancy_amount,account_available_amount,audit_date,source_no, \n        prev_account_amount, \n        prev_flow_no, \n        prev_audit_date, \n        if(prev_account_amount is null,0,prev_account_amount - account_amount) difference_value \n        from \n                (select A.*, \n                        lag(account_amount, 1,0) over(partition by account_code order by audit_date) prev_account_amount, \n                        lag(flow_no, 1) over(partition by account_code order by audit_date) prev_flow_no, \n                        lag(audit_date, 1) over(partition by account_code order by audit_date) prev_audit_date \n                from \n                        account_flow as A \n                         where \n                                A.delete_flag = 0 \n                                and A.transaction_type in ('I','O') \n                               and A.account_type in ('FLZH') \n                               and A.audit_date is not null \n" + sqlWhereBuffer + "                ) T \n        ) b \nwhere \n        abs(b.difference_value) != abs(b.amount) \n       order by b.audit_date");
        List accountFlowRepairHandle20DTOList = this.namedTemplate.query(sqlBuffer.toString(), params, (RowMapper)new BeanPropertyRowMapper(AccountFlowRepairHandle20DTO.class));
        return accountFlowRepairHandle20DTOList;
    }

    private void appendWhere(String accountCode, LocalDateTime recalculationDate, StringBuilder sqlWhereBuffer, Map<String, Object> params, List<Object> args) {
        if (StringUtils.isNotBlank((CharSequence)accountCode)) {
            sqlWhereBuffer.append(" and A.account_code = :accountCode ");
            params.put("accountCode", accountCode);
        }
        if (Objects.nonNull(recalculationDate)) {
            sqlWhereBuffer.append(" and A.audit_date >= :auditDate ");
            params.put("auditDate", recalculationDate);
        }
    }

    private void processingCalculation20(List<AccountFlowRepairVO> repairFlowVOList, List<String> repairFlowNoList) {
        for (AccountFlowRepairVO accountFlowRepairVO : repairFlowVOList) {
            LocalDateTime recalculationDate;
            String accountCode = accountFlowRepairVO.getAccountCode();
            String successAccountCode = this.callableStatementProcedure(accountCode, recalculationDate = accountFlowRepairVO.getRecalculationDate(), repairFlowNoList);
            if (Objects.nonNull(successAccountCode)) {
                this.accountFlowRepairRepoProc.updateRepairStatusById(UdcEnum.FLOW_REPAIR_STATUS_FIXED.getValueCode(), accountFlowRepairVO.getId());
                this.updateAccountAmt(Collections.singletonList(accountCode), repairFlowNoList);
                this.updateAccountSnapshot(Collections.singletonList(accountFlowRepairVO), repairFlowNoList);
                this.removeFlowNoCache(accountFlowRepairVO.getFlowNo());
                continue;
            }
            repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
        }
    }

    private void updateAccountSnapshot(List<AccountFlowRepairVO> repairFlowVOList, List<String> repairFlowNoList) {
        repairFlowVOList.forEach(accountFlowRepairVO -> {
            AccountFlowPageParam accountFlowQueryParam = new AccountFlowPageParam();
            accountFlowQueryParam.setAccountCode(accountFlowRepairVO.getAccountCode());
            accountFlowQueryParam.setRepairTime(accountFlowRepairVO.getRecalculationDate());
            List<AccountFlowVO> accountFlowVOList = this.accountFlowService.selectRepairAfter(accountFlowQueryParam);
            HashMap accountFlowAllMap = CollectionUtil.isEmpty(accountFlowVOList) ? new HashMap() : accountFlowVOList.stream().collect(Collectors.groupingBy(i -> i.getAccountCode()));
            AccountSnapshotParam accountSnapshotParam = new AccountSnapshotParam();
            accountSnapshotParam.setAccountCode(accountFlowRepairVO.getAccountCode());
            accountSnapshotParam.setRepairTime(accountFlowRepairVO.getRecalculationDate());
            List<AccountSnapshotDO> accountSnapshotDOList = this.accountService.selectAccountSnapshotByParam(accountSnapshotParam);
            HashMap accountSnapshotAllMap = CollectionUtil.isEmpty(accountFlowVOList) ? new HashMap() : accountSnapshotDOList.stream().collect(Collectors.groupingBy(i -> i.getAccountCode()));
            ArrayList<AccountSnapshotDO> accountSnapshotUpdateList = new ArrayList<AccountSnapshotDO>();
            for (Map.Entry entry : accountSnapshotAllMap.entrySet()) {
                String accountCode = (String)entry.getKey();
                Collections.sort((List)entry.getValue(), Comparator.comparing(AccountSnapshotDO::getSnapshotTime));
                List accountFlowList = (List)accountFlowAllMap.get(accountCode);
                Collections.sort(accountFlowList, Comparator.comparing(AccountFlowVO::getAuditDate));
                for (AccountSnapshotDO accountSnapshotDO : (List)entry.getValue()) {
                    Integer flowCoordinate = null;
                    for (int i2 = 0; i2 < accountFlowList.size(); ++i2) {
                        AccountFlowVO accountFlowVO = (AccountFlowVO)accountFlowList.get(i2);
                        Integer j = i2;
                        if (accountSnapshotDO.getSnapshotTime().isEqual(accountFlowVO.getAuditDate())) {
                            flowCoordinate = j;
                            break;
                        }
                        if (!accountSnapshotDO.getSnapshotTime().isBefore(accountFlowVO.getAuditDate())) continue;
                        flowCoordinate = j - 1;
                        break;
                    }
                    if (!Objects.nonNull(flowCoordinate)) continue;
                    AccountFlowVO accountFlowVO = (AccountFlowVO)accountFlowList.get(flowCoordinate);
                    accountSnapshotDO.setAccountAmount(accountFlowVO.getAccountAmount());
                    accountSnapshotDO.setAccountAvailableAmount(accountFlowVO.getAccountAvailableAmount());
                    accountSnapshotDO.setAccountOccupancyAmount(accountFlowVO.getAccountOccupancyAmount());
                    accountSnapshotDO.setSnapshotTime(LocalDateTime.now());
                    accountSnapshotUpdateList.add(accountSnapshotDO);
                }
            }
            if (CollectionUtil.isNotEmpty(accountSnapshotUpdateList)) {
                this.accountSnapshotRepo.saveAll(accountSnapshotUpdateList);
            }
        });
    }

    private String callableStatementProcedure(String accountCode, LocalDateTime retryTime, List<String> repairFlowNoList) {
        String successAccountCode = null;
        if (StringUtils.isBlank((CharSequence)accountCode)) {
            log.info("\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a\u65e0\u6cd5\u91cd\u7b97");
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a\u65e0\u6cd5\u91cd\u7b97!");
        }
        if (Objects.isNull(retryTime)) {
            log.info("\u91cd\u7b97\u65f6\u95f4\u4e3a\u7a7a\u65e0\u6cd5\u91cd\u7b97");
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u91cd\u7b97\u65f6\u95f4\u4e3a\u7a7a\u65e0\u6cd5\u91cd\u7b97!");
        }
        log.info("url: " + this.dataUrl + " user: " + this.userName + " password: " + this.pwd);
        Connection conn = null;
        Statement cstmt = null;
        try {
            conn = DriverManager.getConnection(this.dataUrl, this.userName, this.pwd);
            String procedureCall = "{CALL account_flow_repair(?,?)}";
            cstmt = conn.prepareCall(procedureCall);
            cstmt.setString(1, accountCode);
            Date date = new Date(java.util.Date.from(retryTime.atZone(ZoneId.systemDefault()).toInstant()).getTime());
            cstmt.setDate(2, date);
            cstmt.execute();
            ResultSet rs = cstmt.getResultSet();
            while (rs.next()) {
                log.info("\u7ed3\u679c\u96c6\u4e2d\u7684\u6570\u636e:" + rs);
            }
            successAccountCode = accountCode;
            rs.close();
            cstmt.close();
            conn.close();
        }
        catch (SQLException e) {
            repairFlowNoList.forEach(flowNo -> this.removeFlowNoCache((String)flowNo));
            log.error("\u8d26\u6237(" + accountCode + ")\u8c03\u7528\u5b58\u50a8\u8fc7\u7a0b\u91cd\u7b97\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237(" + accountCode + ")\u8c03\u7528\u5b58\u50a8\u8fc7\u7a0b\u91cd\u7b97\u5931\u8d25!");
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                log.error("\u8d26\u6237(" + accountCode + ")\u8c03\u7528\u5b58\u50a8\u8fc7\u7a0b\u91cd\u7b97\u5173\u95ed\u5931\u8d25\uff1a" + e.getMessage());
                e.printStackTrace();
            }
        }
        return successAccountCode;
    }

    public AccountFlowRepairServiceImpl(AccountFlowRepairRepo accountFlowRepairRepo, AccountFlowRepairRepoProc accountFlowRepairRepoProc, AccountFlowService accountFlowService, AccountFlowRepoProc accountFlowRepoProc, AccountRepoProc accountRepoProc, AccountRepo accountRepo, AccountSnapshotRepo accountSnapshotRepo, AccountService accountService, RedissonClient redissonClient, EntityManager entityManager, JdbcTemplate jdbcTemplate, NamedParameterJdbcTemplate namedTemplate, String dataUrl, String userName, String pwd) {
        this.accountFlowRepairRepo = accountFlowRepairRepo;
        this.accountFlowRepairRepoProc = accountFlowRepairRepoProc;
        this.accountFlowService = accountFlowService;
        this.accountFlowRepoProc = accountFlowRepoProc;
        this.accountRepoProc = accountRepoProc;
        this.accountRepo = accountRepo;
        this.accountSnapshotRepo = accountSnapshotRepo;
        this.accountService = accountService;
        this.redissonClient = redissonClient;
        this.entityManager = entityManager;
        this.jdbcTemplate = jdbcTemplate;
        this.namedTemplate = namedTemplate;
        this.dataUrl = dataUrl;
        this.userName = userName;
        this.pwd = pwd;
    }
}

