/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.utils.excel.convert;

import com.elitesland.fin.application.facade.excel.convert.DefaultConverter;
import com.elitesland.fin.utils.excel.convert.Converter;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ExcelConvertUtils {
    private static final String GET = "get";
    private static final String SET = "set";

    public static <S, T extends Serializable> List<T> convertStrictly(Collection<S> sources, Class<T> targetClz) {
        return ExcelConvertUtils.convert(sources, targetClz, ExcelConvertUtils::convertStrictly);
    }

    public static <S, T extends Serializable> List<T> convertLoosely(Collection<S> sources, Class<T> targetClz) {
        ExcelConverterManager.refresh();
        return ExcelConvertUtils.convert(sources, targetClz, ExcelConvertUtils::convertLoosely);
    }

    private static <S, T extends Serializable> List<T> convert(Collection<S> sources, Class<T> targetClz, BiConsumer<S, T> convert) {
        if (sources.isEmpty()) {
            return List.of();
        }
        ArrayList<Serializable> targets = new ArrayList<Serializable>(sources.size());
        for (S source : sources) {
            Serializable target = null;
            try {
                target = (Serializable)targetClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("when create object of " + targetClz.getName() + " type had error: " + e.getMessage());
            }
            convert.accept(source, target);
            targets.add(target);
        }
        return targets;
    }

    public static <S, T> void convertStrictly(S source, T target) {
        ExcelConvertUtils.convert(source, target, ExcelConvertUtils::getWriteMethodsStrictly);
    }

    public static <S, T> void convertLoosely(S source, T target) {
        ExcelConvertUtils.convert(source, target, ExcelConvertUtils::getWriteMethodsLoosely);
    }

    private static <S, T> void convert(S source, T target, Function<T, Map<String, MethodDescriptor>> getWriteMethods) {
        if (source == null || target == null) {
            return;
        }
        Map<String, MethodDescriptor> writeMethods = getWriteMethods.apply(target);
        Map<String, Method> readMethods = ExcelConvertUtils.getReadMethods(source);
        for (Map.Entry<String, MethodDescriptor> methodEntry : writeMethods.entrySet()) {
            MethodDescriptor writeMethodDescriptor = methodEntry.getValue();
            Method writeMethod = writeMethodDescriptor.method;
            Method readMethod = readMethods.get(writeMethodDescriptor.fieldName);
            if (readMethod == null) continue;
            try {
                Object invoked = readMethod.invoke(source, new Object[0]);
                if (writeMethodDescriptor.converter != null && writeMethodDescriptor.converter.getClass() != DefaultConverter.class) {
                    Object converted = writeMethodDescriptor.converter.convert(invoked);
                    writeMethod.invoke(target, converted);
                    continue;
                }
                if (writeMethodDescriptor.defaultValue != null && !writeMethodDescriptor.defaultValue.equals("")) {
                    writeMethod.invoke(target, writeMethodDescriptor.defaultValue);
                    continue;
                }
                writeMethod.invoke(target, invoked);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Cannot convert source value to target, there had some error " + e.getMessage());
            }
        }
    }

    private static <D> Map<String, MethodDescriptor> getWriteMethodsStrictly(D target) {
        return ExcelConvertUtils.getWriteMethods(target, ExcelConverterManager::instance);
    }

    private static <D> Map<String, MethodDescriptor> getWriteMethodsLoosely(D target) {
        return ExcelConvertUtils.getWriteMethods(target, () -> ExcelConverterManager.instance(false));
    }

    private static <D> Map<String, MethodDescriptor> getWriteMethods(D target, Supplier<ExcelConverterManager> converterManagerSupplier) {
        Class<?> targetClass = target.getClass();
        List<Field> fields = ExcelConvertUtils.getAllFields(target);
        if (fields.size() == 0) {
            return new HashMap<String, MethodDescriptor>();
        }
        HashMap<String, MethodDescriptor> map = new HashMap<String, MethodDescriptor>();
        ExcelConverterManager excelConverterManager = converterManagerSupplier.get();
        for (Field field : fields) {
            String name = field.getName();
            Method method = null;
            String sourceFieldName = name;
            try {
                method = targetClass.getMethod(SET + ExcelConvertUtils.capitalize(name), field.getType());
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            ExcelConvert excelConvert = field.getAnnotation(ExcelConvert.class);
            Converter converter = null;
            String defaultValue = null;
            if (excelConvert == null) {
                map.put(name, new MethodDescriptor(method, converter, defaultValue, sourceFieldName));
                continue;
            }
            if (!excelConvert.value().equals("")) {
                defaultValue = excelConvert.value();
            }
            if (!excelConvert.name().equals("")) {
                sourceFieldName = excelConvert.name();
            }
            if (excelConvert.converter() != null) {
                try {
                    converter = excelConverterManager.getConverter(excelConvert.converter());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            map.put(name, new MethodDescriptor(method, converter, defaultValue, sourceFieldName));
        }
        return map;
    }

    private static <D> Map<String, Method> getReadMethods(D source) {
        Class<?> sourceClass = source.getClass();
        List<Field> fields = ExcelConvertUtils.getAllFields(source);
        if (fields.size() == 0) {
            return new HashMap<String, Method>();
        }
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Field field : fields) {
            String name = field.getName();
            Method method = null;
            try {
                method = sourceClass.getMethod(GET + ExcelConvertUtils.capitalize(name), null);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            map.put(name, method);
        }
        return map;
    }

    private static String capitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        int n = strLen = str == null ? 0 : str.length();
        if (strLen == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    private static <D> List<Field> getAllFields(D obj) {
        ArrayList fields = Lists.newArrayList();
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(List.of(clazz.getDeclaredFields()));
        }
        return fields;
    }

    public static class MethodDescriptor {
        public final Method method;
        public final Converter converter;
        public final String defaultValue;
        public final String fieldName;

        public MethodDescriptor(Method method, Converter converter, String defaultValue, String fieldName) {
            this.method = method;
            this.converter = converter;
            this.defaultValue = defaultValue;
            this.fieldName = fieldName;
        }
    }
}

