package com.elitesland.fin.application.convert.invoice;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitVO;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceCustVO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.param.invoice.InvoiceAwaitSaveParam;
import com.elitesland.order.param.SaleReconciliatDTO;
import com.elitesland.sale.api.vo.resp.crm.LmSaveCustRespVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

@Mapper(config = BaseMapperConfig.class)
public interface InvoiceAwaitConvert {
    InvoiceAwaitConvert INSTANCE = Mappers.getMapper(InvoiceAwaitConvert.class);

    InvoiceAwaitDO saveParam2Do(InvoiceAwaitSaveParam param);

    @Mapping(source = "taxerNo", target = "taxNo")
    InvoiceCustVO custVos2Dto(LmSaveCustRespVO invCust);

    @Mapping(source = "taxerNo", target = "taxNo")
    List<InvoiceCustVO> custVos2Dtos(List<LmSaveCustRespVO> invCust);

    InvoiceAwaitDTO sale2AwaitDto(SaleReconciliatDTO saleRec);

    InvoiceApplySaveParam invoiceAwaitVo2SaleInvoice(InvoiceAwaitRespVO record);

    PagingVO<InvoiceAwaitVO> pagingDto2Vo(PagingVO<InvoiceAwaitDTO> pagingDto);
}
