package com.elitesland.fin.application.facade.excel.convert;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.utils.excel.convert.Converter;
import com.elitesland.fin.rpc.system.SystemRpcService;
import org.apache.commons.lang3.math.NumberUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class AmountRoundConverter implements Converter<BigDecimal, String, Integer> {
    private static final SystemRpcService systemRpcService = SpringContextHolder.getBean(SystemRpcService.class);
    
    private Integer accuracy;
    
    @Override
    public String convert(BigDecimal value) {
        if(value == null) {
            value = BigDecimal.ZERO;
        }
        if (accuracy == null) {
            return value.toPlainString();
        }
        
        return NumberUtils.toScaledBigDecimal(value, accuracy, RoundingMode.HALF_UP).toPlainString();
    }
    
    @Override
    public Integer baseValue() {
        return accuracy;
    }
    
    @Override
    public Integer initBaseValue() {
        return setAmountAccuracyBySettingService();
    }

    @Override
    public Integer refreshBaseValue() {
        return setAmountAccuracyBySettingService();
    }
    
    private Integer setAmountAccuracyBySettingService() {
        SysSettingVO amountDecimalPlace = systemRpcService.findSysSettingByNo("AMOUNT_DECIMAL_PLACE");
        if(amountDecimalPlace != null
            && amountDecimalPlace.getSettingVal() != null
            && !amountDecimalPlace.getSettingVal().equals("")) {
            accuracy = Integer.parseInt(amountDecimalPlace.getSettingVal());
        }
        return accuracy;
    }
}
