package com.elitesland.fin.application.service.excel.entity;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.BaseRowModel;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.DefaultDateTimeConverter;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <p>
 * 账户流水导出entity
 * </p>
 *
 * @author gyj
 * @date 2023/7/28
 */
@Data
@ExcelIgnoreUnannotated
public class AccountFlowExportEntity implements Serializable {
    
    @ApiModelProperty("公司编码")
    private String companyCode;
    
    @ApiModelProperty("公司Name")
    private String companyCodeName;
    
    @ApiModelProperty("归属加盟商编码")
    private String secFranchiseeCode;
    
    @ApiModelProperty("归属加盟商名称")
    private String secFranchiseeCodeName;
    
    @ApiModelProperty("流水号")
    private String flowNo;
    
    @ApiModelProperty("交易类型")
    private String transactionTypeName;
    
    @ApiModelProperty("发生金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String amount;
    
    @ApiModelProperty("交易日期")
    private LocalDateTime transactionTime;
    
    @ApiModelProperty("账户类型")
    private String accountTypeName;
    
    @ApiModelProperty("账户编码")
    private String accountCode;
    
    @ApiModelProperty("账户名称")
    private String accountNameName;
    
    @ApiModelProperty("账户金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String accountAmount;
    
    @ApiModelProperty("账户占用金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String accountOccupancyAmount;
    
    @ApiModelProperty("账户可用金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String accountAvailableAmount;
    
    @ApiModelProperty("来源单据")
    private String sourceDocName;
    
    @ApiModelProperty("来源单号")
    private String sourceNo;
    
    @ApiModelProperty("来源id")
    private Long sourceId;
    
    @ApiModelProperty("审核人id")
    private Long auditUserId;
    
    @ApiModelProperty("审核人")
    private String auditUserName;
    
    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;
    
    @ApiModelProperty("单据状态")
    private String orderStateName;
    
    @ApiModelProperty("开户主体名称")
    private String accountHolderName;
    
    @ApiModelProperty("账户规则编码")
    private String ruleCode;
    
    @ApiModelProperty("账户规则名称")
    private String ruleName;
    
    @ApiModelProperty(value = "执行序列")
    private Integer priorityNo;
}
