package com.elitesland.fin.application.service.excel.entity;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class LimitAdjustExportEntity implements Serializable {
    @ApiModelProperty(value = "单号")
    private String docNo;
    
    @ApiModelProperty(value = "状态")
    private String docStateName;
    
    @ApiModelProperty(value = "授信类型")
    private String creditTypeName;
    
    @ApiModelProperty(value = "调整类型")
    private String adjustTypeName;
    
    @ApiModelProperty(value = "效期至")
    private LocalDateTime expireTime;
    
    @ApiModelProperty(value = "公司编码")
    private String ouCode;
    
    @ApiModelProperty(value = "公司名称")
    private String ouName;
    
    @ApiModelProperty(value = "部门编码")
    private String buCode;
    
    @ApiModelProperty(value = "部门名称")
    private String buName;
    
    @ApiModelProperty(value = "产品线")
    private String productLine;
    
    @ApiModelProperty(value = "业务员")
    private String saleUser;
    
    @ApiModelProperty(value = "对象类型 客户/客户组")
    private String objectTypeName;
    
    @ApiModelProperty(value = "对象名称 客户/客户组名称")
    private String objectName;
    
    @ApiModelProperty(value = "账户编码")
    private String creditAccountCode;
    
    @ApiModelProperty(value = "账户名称")
    private String creditAccountName;
    
    @ApiModelProperty(value = "调整额度")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String adjustLimit;
    
    @ApiModelProperty(value = "调整原因")
    private String adjustReasonName;
    
    @ApiModelProperty(value = "审核人")
    private String auditUser;
    
    @ApiModelProperty(value = "审核时间")
    private LocalDateTime auditTime;
    
    @ApiModelProperty(value = "审核拒绝理由")
    private String auditRejectReason;
    
    @ApiModelProperty("效期起")
    private LocalDateTime effectiveTime;
    
    @ApiModelProperty("创建日期")
    @ExcelConvert(converter = DateTimeToDateConverter.class, name = "createTime")
    private LocalDate createDate;
    
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    
    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;
    
    @ApiModelProperty("修改人")
    private String updater;
    
    @ApiModelProperty(value = "备注")
    private String remark;
}
