package com.elitesland.fin.application.service.recorder;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.cloudt.apm.common.exception.BusinessException;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderDtlConvert;
import com.elitesland.fin.application.convert.recorder.RecOrderRpcFiledConvert;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.service.unionpay.entity.enums.ProcDefKey;
import com.elitesland.fin.application.service.unionpay.entity.enums.ReceiptStatusEnum;
import com.elitesland.fin.application.service.unionpay.entity.req.SendPayReq;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.entity.recorder.*;
import com.elitesland.fin.domain.param.recorder.*;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainServiceImpl;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.repo.recorder.*;
import com.elitesland.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.fin.repo.account.AccountStorageRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.fin.service.recorder.RecOrderRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Service
@Slf4j
@RequiredArgsConstructor
public class RecOrderRpcTwoServiceImpl implements RecOrderRpcTwoService {
    private final RecOrderRpcService recOrderRpcServiceImpl;
    @Autowired
    private RecOrderRpcFiledRepo recOrderRpcFiledRepo;
    @Autowired
    private RecOrderRpcFiledRepoProc recOrderRpcFiledRepoProc;
    @Autowired
    private AccountStorageRepoProc accountStorageRepoProc;
    @Autowired
    private RecOrderRepoProc recOrderRepoProc;
    @Autowired
    private RecOrderRepo recOrderRepo;
    @Autowired
    private RecOrderDtlRepo recOrderDtlRepo;
    @Autowired
    private RecOrderDtlRepoProc recOrderDtlRepoProc;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final RecOrderRpcDetailService recOrderRpcDetailService;

    private final WorkflowService workflowService;

    //发号器生成付款单号
    private final SeqNumProvider sysNumberRuleService;

    private final TaskExecutor taskExecutor;
    private final UdcProvider udcProvider;

    private final WorkflowRpcService workflowRpcService;


    private final RecOrderDomainService recOrderDomainService;
    private final RecOrderService recOrderService;


    //保存收款单
    @Transactional(rollbackFor = Exception.class)
    public Long save(RecOrderRpcSaveParam recOrderRpcSaveParam) {
        RecOrderRpcParam recOrder = new RecOrderRpcParam();
        BeanUtils.copyProperties(recOrderRpcSaveParam, recOrder);
        Long id = recOrderRpcServiceImpl.save(recOrder);
        //保存扩展表
        if (null != recOrderRpcSaveParam.getRecOrderRpcTimsParam() && id != null & id != 0L) {
            RecOrderRpcFiledDO recOrderRpcFiledDO = recOrderRpcFiledRepo.save(RecOrderRpcFiledConvert.INSTANCE.convertParam(recOrderRpcSaveParam.getRecOrderRpcTimsParam()));
        }
        return id;
    }

    //分页查询收款单
    @Override
    @SysCodeProc
    public PagingVO<RecOrderRpcPageRespVo> queryRecOrderRpcPageList(RecOrderRpcTwoParam recOrderRpcTwoParam) {
        //查询条数
        long count = recOrderRpcFiledRepoProc.countRecOrderRpc(recOrderRpcTwoParam);
        if (count > 0) {
            var queryList = recOrderRpcFiledRepoProc.queryRecOrderPrc(recOrderRpcTwoParam);
            return new PagingVO<>(count, queryList);
        }
        return new PagingVO<>();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult<Object> update(RecOrderRpcUpdateParam recOrderRpcUpdateParam) {
        if (recOrderRpcUpdateParam != null) {
            throw new BusinessException("更新对象不存在");
        }
        RecOrder recOrder = new RecOrder();
        BeanUtils.copyProperties(recOrderRpcUpdateParam, recOrder);
        //更新主表和明细表
        RecOrderDO rec = updateOrSave(recOrder);
        recOrderRpcUpdateParam.getRecOrderRpcTimsParam().setMasId(rec.getId());
        if (recOrderRpcUpdateParam.getRecOrderRpcTimsParam() != null && recOrderRpcUpdateParam.getRecOrderRpcTimsParam().getId() != null) {
            //进行更新
            Long result = recOrderRpcFiledRepoProc.masIdUpdateFiled(RecOrderRpcFiledConvert.INSTANCE.convertParam(recOrderRpcUpdateParam.getRecOrderRpcTimsParam()));
            if (result != null && result != 0) {
                return ApiResult.ok();
            }
        }

        return new ApiResult<>().errorMsg("收款单信息修改失败");
    }

    //查询详情信息
    @Override
    @SysCodeProc
    public Optional<RecOrderRpcPageRespVo> queryRecOrderDetail(Long id) {
        //查询主表信息
        RecOrderRpcPageRespVo recOrderRpcPageRespVos = recOrderRpcFiledRepoProc.queryRecOrderPrcDetail(id);
        String file = recOrderRpcPageRespVos.getApplyFile();
        if (StringUtils.isNotEmpty(file)) {
            String[] fileList = file.split(",");
            List<String> list = new ArrayList<>();
            for (int i = 0; i < fileList.length; i++) {
                if (!fileList[i].isEmpty()) { // 判断字符串是否为空
                    list.add(fileList[i]);
                }
            }
            recOrderRpcPageRespVos.setApplyFileList(list);
        }
        //查询明细
        if (recOrderRpcPageRespVos != null) {
            List<RecOrderDetailSaveParam> detailSaveParamList = recOrderRpcDetailService.getDetail(id);
            recOrderRpcPageRespVos.setDtlList(detailSaveParamList);
            return Optional.of(recOrderRpcPageRespVos);
        }
        return Optional.empty();
    }

    /**
     * 作废
     */
    @Transactional(rollbackFor = {Exception.class})
    @Override
    public ApiResult enableRecOrderState(Long id, String state) {
        //根据主键ID作废数据
        //作废主表数据
        jpaQueryFactory.update(QRecOrderDO.recOrderDO).set(QRecOrderDO.recOrderDO.orderState, state).where(QRecOrderDO.recOrderDO.id.eq(id));
        return ApiResult.ok();
    }

    @Override
    public Long saveRecOrder(RecOrderRpcSaveParam recOrderRpcSaveParam) {
        RecOrderRpcParam recOrder = new RecOrderRpcParam();
        BeanUtils.copyProperties(recOrderRpcSaveParam, recOrder);
        Long id = saveAssignStatus(recOrder, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());

        RecOrderRpcTimsParam recOrderRpcTimsParam = recOrderRpcSaveParam.getRecOrderRpcTimsParam();
        //保存扩展表
        if (null != recOrderRpcTimsParam && id != null && id != 0L) {
            recOrderRpcTimsParam.setMasId(id);
            RecOrderRpcFiledDO recOrderRpcFiledDO = recOrderRpcFiledRepo.save(RecOrderRpcFiledConvert.INSTANCE.convertParam(recOrderRpcTimsParam));
        }
        return id;
    }

    @Override
    @SysCodeProc
    public void exportExcel(RecOrderRpcTwoParam param, HttpServletResponse response) {
        CompletableFuture<List<RecOrderRpcExcelVO>> recThread = CompletableFuture.supplyAsync(() -> {
            //查询收款单数据
            List<RecOrderRpcExcelVO> result = recOrderRpcFiledRepoProc.queryRecOrderExport(param);
            return result;
        }, taskExecutor);
        List<RecOrderRpcExcelVO> recList = recThread.join();
        Map<String, String> recTypeUdcMap = udcProvider.getValueMapByUdcCode("yst-fin", "REC_TYPE");
        Map<String, String> recStatusUdcMap = udcProvider.getValueMapByUdcCode("yst-fin", "RECORDER_STATE");
        Map<String, String> payMethodUdcMap = udcProvider.getValueMapByUdcCode("yst-fin", "PAY_METHOD");
        Map<String, String> docClsUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "DOC_CLS");
        log.info("recList:{}", recList);
        recList.forEach(
                rec -> {
                    rec.setRecTypeName(recTypeUdcMap.get(rec.getRecType()));
                    rec.setOrderStateName(recStatusUdcMap.get(rec.getOrderState()));
                    rec.setPayMethodName(payMethodUdcMap.get(rec.getPayMethod()));
                    rec.setCreateModeName(docClsUdcMap.get(rec.getCreateMode()));
                }
        );
        // 开始导出数据
        WriteSheet empSheet = EasyExcelFactory.writerSheet(0, "收款单导出").head(RecOrderRpcExcelVO.class).build();
        ServletOutputStream outputStream = null;
        ExcelWriter excelWriter = null;
        IOException exception = null;
        try {
            response.setHeader("Content-disposition", "attachment;filename=" + "应收单导出" + ".xlsx");
            response.setContentType("multipart/form-data");
            response.setCharacterEncoding("utf-8");
            outputStream = response.getOutputStream();
            excelWriter = EasyExcelFactory.write(outputStream).build();
            log.info("反射开始**********************************************");
            log.info("recList:{},empSheet:{}", recList, empSheet);
            excelWriter.write(recList, empSheet);
            log.info("反射结束**********************************************");
            outputStream.flush();
            excelWriter.finish();
        } catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException("下载excel文件失败", e);
        } finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                    exception = e;

                }
            }
        }
        if (null != exception) {
            throw new BusinessException("关闭文件流失败", exception);
        }
    }

    @Override
    @Transactional
    public void submit(Long id) {

        RecOrderRpcPageRespVo recOrderRpcPageRespVo = checkAndGetRecOrder(id);

        if (workflowRpcService.checkIsEnableWorkFlow(ProcDefKey.SVO_OFFLINEPAY.name())) {

            //发起流程
            WorkflowResult<ProcessInfo> workflowResult = workflowService.startProcess(
                    StartProcessPayload.of(ProcDefKey.SVO_OFFLINEPAY.name(),
                            "储值单线下支付(" + recOrderRpcPageRespVo.getSourceNo() + ")审批",
                            recOrderRpcPageRespVo.getSourceNo() + "#" + id,
                            null));

            Assert.notNull(workflowResult, "启动流程失败");
            Assert.isTrue(workflowResult.isSuccess(), workflowResult.getMsg());

            //流程启动成功
            ProcessInfo processInfo = workflowResult.getData();

            SendPayReq recOrder = new SendPayReq();
            //更新收款单状态 自动审批通过的会先更新单据状态
            if (ObjectUtil.notEqual(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {

                recOrder.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVING.getCode());
                recOrder.setReceiptStatus(UdcEnum.APPLY_STATUS_DOING.getValueCode());
                recOrder.setWorkflowProcInstStatus(processInfo.getProcInstStatus());

                //更新储值单状态
                SendPayReq storage = new SendPayReq();
                storage.setPayOrderId(recOrderRpcPageRespVo.getSourceNo());
                storage.setReceiptStatus(ReceiptStatusEnum.SVO_APPROVING.getCode());
                accountStorageRepoProc.updateAccountStorage(storage);
            }
            recOrder.setWorkflowProcInstId(processInfo.getProcInstId());
            recOrder.setWorkflowSubmitTime(LocalDateTime.now());
            recOrder.setId(id);

            recOrderRpcFiledRepoProc.updateRecOrder(recOrder);
        }
    }

    private RecOrderRpcPageRespVo checkAndGetRecOrder(Long id) {
        //校验收款单
        RecOrderRpcTwoParam recOrderRpcTwoParam = new RecOrderRpcTwoParam();
        recOrderRpcTwoParam.setId(id);
        List<RecOrderRpcPageRespVo> recOrderRpcPageRespVoList = recOrderRpcFiledRepoProc.queryRecOrderPrc(recOrderRpcTwoParam);
        Assert.notEmpty(recOrderRpcPageRespVoList, "查不到收款单信息");
        Assert.equals(recOrderRpcPageRespVoList.size(), 1, "查不多条收款单信息");

        RecOrderRpcPageRespVo recOrderRpcPageRespVo = recOrderRpcPageRespVoList.get(0);

        Assert.isNull(recOrderRpcPageRespVo.getWorkflowProcInstId(), "已经发起了工作流，不能重复发起");

        return recOrderRpcPageRespVo;
    }

    public Long saveAssignStatus(RecOrderRpcParam recOrderRpcParam, String orderState) {
        if (CharSequenceUtil.isBlank(recOrderRpcParam.getCreateMode())) {
            throw new BusinessException("来源单据 createMode不能为空");
        }
        RecOrder recOrder = RecOrderConvert.INSTANCE.convertRpc(recOrderRpcParam);
        Long resId = this.save(recOrder, orderState);
        return resId;
    }

    public Long save(RecOrder recOrder, String orderState) {
        //保存逻辑
        //无ID则为新增
        if (recOrder.getId() != null) {
            recOrder.checkOrderState();
        } else {
            //新增数据才会生成付款单号
            String recOrderNo = sysNumberRuleService.generateCode(FinConstant.FIN, FinConstant.SKD, null);
            recOrder.setRecOrderNo(recOrderNo);
        }
        //默认核销状态
        if (recOrder.getVerAmt() == null) {
            recOrder.defaultVer();
        }
        // 非手工
        if (!recOrder.getCreateMode().equals(UdcEnum.FIN_REC_DOC_CLS_MANU.getValueCode())) {
            //校验金额不能为0
            if (recOrder.getId() == null) {
                recOrder.setSoDef();
                recOrder.checkDtl(false);
                //recOrder.countBySo();
            }
        } else {
            //校验明细是否为空  金额是否为0
            recOrder.checkTotalMoney();
        }
        recOrder.setOrderState(orderState);
        //如果来源是应付单走应付单逻辑
        return updateOrSave(recOrder).getId();
    }

    private RecOrderDO updateOrSave(RecOrder recOrder) {
        //更新字段 主表信息
        RecOrderDO recOrderDO = RecOrderConvert.INSTANCE.convertToDo(recOrder);
        //先删除之前明细信息
        if (recOrder.getId() != null) {
            recOrderDtlRepoProc.deleteByMasIds(List.of(recOrder.getId()));
        } else {
            recOrderDO.setAuditDataVersion(0);
        }
        RecOrderDO save = recOrderRepo.save(recOrderDO);
        //细单信息
        List<RecOrderDtlDO> recOrderDtlDOS = RecOrderDtlConvert.INSTANCE.convertToDO(recOrder.getDtlList());

        //设置主键关联ID的值
        recOrderDtlDOS.forEach(dtl -> {
            //获取新增后的主表ID
            dtl.setMasId(save.getId());
        });
        recOrderDtlRepo.saveAll(recOrderDtlDOS);
        return save;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public ApiResult<Void> cancelApprove(List<Long> ids) {
        List<RecOrderDO> recOrderDOs = recOrderRepo.findAllById(ids);
        //检查
        checkCancelDoc(recOrderDOs);
        // 重置状态
        recOrderDOs.forEach(recOrderDO -> {
            recOrderDO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            recOrderDO.setProposedStatus(null);
            recOrderDO.setProcInstId(null);
            recOrderDO.setProcInstStatus(null);
        });
        recOrderRepo.saveAll(recOrderDOs);
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = {RuntimeException.class, Exception.class})
    public ApiResult<Long> redPunch(Long id) {
        RecOrderDO recOrderDO = recOrderRepo.getReferenceById(id);
        //检查
        this.checkRedPunch(recOrderDO);
        RecOrder recOrder = recOrderDomainService.redPunchCreate(id);
        RecOrderSaveParam param = RecOrderConvert.INSTANCE.convert(recOrder);
        //红冲
        return recOrderService.submit(param);
    }

    /**
     * 取消单据检查
     * @param recOrderDOS
     */
    void checkCancelDoc(List<RecOrderDO> recOrderDOS) {
        if (CollectionUtils.isEmpty(recOrderDOS)){
            throw new com.elitescloud.boot.exception.BusinessException("单据不存在");
        }
        recOrderDOS.forEach(recOrderDO -> {
            String perfix = "单号：" + recOrderDO.getRecOrderNo() + "-";
            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(recOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode()
                .equals(recOrderDO.getProposedStatus())) {
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "拟定状态必须为草稿或拟定失败");
            }
            if (!(BigDecimal.ZERO.compareTo(recOrderDO.getVerAmt())==0)){
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "已核销金额必须为0");
            }
            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(recOrderDO.getOrderState())){
                throw new com.elitescloud.boot.exception.BusinessException(perfix + "单据状态必须为审核通过");
            }
        });


    }

    /**
     * 取消单据检查
     * @param recOrderDO
     */
    void checkRedPunch(RecOrderDO recOrderDO) {
        if (Objects.isNull(recOrderDO)){
            throw new com.elitescloud.boot.exception.BusinessException("单据不存在");
        }
        if (Boolean.TRUE.equals(recOrderDO.getRedState())){
            throw new com.elitescloud.boot.exception.BusinessException("单据已红冲");
        }
        if (Objects.nonNull(recOrderDO.getRedSourceNo())){
            throw new com.elitescloud.boot.exception.BusinessException("来源单据不可为红冲单据");
        }
        if (!(BigDecimal.ZERO.compareTo(recOrderDO.getVerAmt())==0)){
            throw new com.elitescloud.boot.exception.BusinessException("已核销金额必须为0");
        }
        if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(recOrderDO.getOrderState())){
            throw new com.elitescloud.boot.exception.BusinessException("单据状态必须为审核通过");
        }

    }

}
