package com.elitesland.fin.domain.entity.artype;

import cn.hutool.core.lang.Assert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.entity.artype
 * @date 2022/4/11 13:10
 */
@Data
public class ArType {

    private Long id;

    private String arTypeCode;

    private String arTypeName;

    private Boolean enableFlag;

    private Boolean autoAudit;

    private Boolean defaultFlag;

    @ApiModelProperty("来源单据")
    private String sourceDoc;

    @ApiModelProperty("来源单据类型")
    private String sourceDocType;

    @ApiModelProperty("来源单据状态")
    private String sourceDocStatus;

    public void checkNotNull() {
        Assert.notEmpty(this.arTypeName, "arTypeName is null");
        Assert.notEmpty(this.arTypeCode, "arTypeCode is null");
    }

    public void setDefaultValue() {
        this.enableFlag = false;
        this.defaultFlag = false;
    }
}
