package com.elitesland.fin.provider.creditaccount;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.creditaccount.CreditAccountConvert;
import com.elitesland.fin.application.facade.dto.creditaccount.CreditAccountDTO;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.dto.creditaccount.CreditAccountRpcDTO;
import com.elitesland.fin.param.creditaccount.CreditAccountRpcParam;
import com.elitesland.fin.service.creditaccount.CreditAccountRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.service.account
 * @date 2023/3/7 13:56
 */

@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + CreditAccountRpcService.PATH)
@Slf4j
public class CreditAccountRpcServiceImpl implements CreditAccountRpcService {


    private final CreditAccountService creditAccountService;

    @Override
    public ApiResult<Void> createCreditAccounts(List<CreditAccountRpcParam> param){
        return ApiResult.ok();
    }

    @Override
    public ApiResult<List<CreditAccountRpcDTO>> queryCreditAccountCode(CreditAccountRpcParam param) {

        List<CreditAccountDTO> creditAccountDTOS = creditAccountService.getAccountByAccountParam(CreditAccountConvert.INSTANCE.rpc2Param(param));
        return ApiResult.ok(CreditAccountConvert.INSTANCE.dtos2RpcDtos(creditAccountDTOS));

    }

}
