package com.elitesland.fin.application.convert.aporder;

import com.elitesland.fin.application.facade.param.aporder.ApOrderSaveParam;
import com.elitesland.fin.application.facade.vo.aporder.ApOrderVO;
import com.elitesland.fin.domain.entity.aporder.ApOrder;
import com.elitesland.fin.domain.entity.aporder.ApOrderDO;
import com.elitesland.fin.domain.param.aporder.ApOrderPageParam;
import com.elitesland.fin.dto.aporder.ApOrderRpcDTO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.param.aporder.ApOrderPageRpcParam;
import com.elitesland.fin.param.aporder.ApOrderRpcParam;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.convert.aporder
 * @date 2022/3/16 16:14
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface ApOrderConvert {

    ApOrderConvert INSTANCE = Mappers.getMapper(ApOrderConvert.class);

    List<ApOrderVO> convertList(List<ApOrderDTO> apOrderDTOList);

    PagingVO<ApOrderVO> convertPage(PagingVO<ApOrderDTO> param);

    @Mapping(source = "apOrderDtlDTOList", target = "apOrderDtlVOList")
    @Mapping(source = "apOrderDtlGroupDTOList", target = "apOrderDtlGroupVOList")
    ApOrderVO convert(ApOrderDTO apOrderDTO);

    ApOrderDO convert(ApOrder apOrder);

    @Mapping(source = "apOrderDtlSaveParamList", target = "apOrderDtlList")
    @Mapping(source = "apOrderDtlGroupSaveParamList", target = "apOrderDtlGroupList")
    ApOrder convert(ApOrderSaveParam apOrderSaveParam);

    @Mapping(source = "apOrderDtlList", target = "apOrderDtlSaveParamList")
    @Mapping(source = "apOrderDtlGroupList", target = "apOrderDtlGroupSaveParamList")
    ApOrderSaveParam convertParam(ApOrder apOrder);


    @Mapping(source = "apOrderDtlRpcDTOList", target = "apOrderDtlList")
    @Mapping(source = "apOrderDtlGroupRpcDTOList", target = "apOrderDtlGroupList")
    ApOrder convertRpc(ApOrderRpcParam apOrderRpcParam);

    ApOrderPageParam convertPageParamRpc(ApOrderPageRpcParam apOrderPageRpcParam);

    PagingVO<ApOrderRpcDTO> convertRpcDto(PagingVO<ApOrderDTO> res);

    ApOrderRpcDTO apOrderDTO2ApOrderRpcDTO(ApOrderDTO apOrderDTO);

}
