package com.elitesland.fin.application.facade.param.aporder;

import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.param.aporder
 * @date 2022/3/21 14:26
 */
@Data
public class ApOrderSaveParam implements Serializable {

    private static final long serialVersionUID = 317908349373274186L;
    private Long id;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("应付单编号")
    private String apOrderNo;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("单据来源")
    private String createMode;

    @ApiModelProperty("应付单类型定义ID")
    private Long apTypeId;

    @ApiModelProperty("应付单类型名称")
    private String apTypeName;

    @ApiModelProperty("应付单类型代码")
    private String apTypeCode;

    @ApiModelProperty("单据状态")
    private String orderState;

    @ApiModelProperty("业务日期")
    private LocalDateTime buDate;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("经办人ID")
    private Long operUserId;

    @ApiModelProperty("经办人")
    private String operator;

    @ApiModelProperty("是否含税")
    private Boolean taxFlag;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("部门ID")
    private Long buId;

    @ApiModelProperty("部门编码")
    private String buCode;

    @ApiModelProperty("部门名称")
    private String buName;

    @ApiModelProperty("业务类型")
    private String buType;

    @ApiModelProperty("付款条件")
    private String payMentName;

    @ApiModelProperty("付款条件id")
    private String payMentId;

    @ApiModelProperty("付款条件code")
    private String payMentCode;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("锁版本")
    private Integer auditDataVersion;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("应付单明细")
    private List<ApOrderDtlSaveParam> apOrderDtlSaveParamList;

    @ApiModelProperty("应付单汇总明细")
    private List<ApOrderDtlGroupSaveParam> apOrderDtlGroupSaveParamList;

    @ApiModelProperty("地址号")
    private String addrNo;

    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    private String proposedStatus;

    private Boolean check = Boolean.TRUE;

}
