package com.elitesland.fin.application.facade.param.payment;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.dto.payment.PaymentRuleConfigDtlDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.kafka.common.protocol.types.Field;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

@Data
@ApiModel("支付规则配置查询参数")
public class PaymentRuleConfigParam extends BaseModelParam {

    @ApiModelProperty("支付规则码")
    private String ruleCode;

    @ApiModelProperty("支付规则名称")
    private String ruleName;

    @ApiModelProperty("支付规则编码/名称")
    private String ruleCodeName;

    @ApiModelProperty("扣款单据类型名称")
    private String optDocTypeName;

    @ApiModelProperty("扣款单据")
    private String optDoc;

    @ApiModelProperty("扣款单据状态")
    private String optDocStatus;

    @ApiModelProperty("扣款单据类型")
    private String optDocType;

    @ApiModelProperty("扣款账户类型")
    private String optAccountType;

    @ApiModelProperty("扣款单据操作描述")
    private String optDocName;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    private String status;

    @ApiModelProperty("状态")
    private String statusName;

    @ApiModelProperty("多字段查询关键字")
    private String multiKeywords;

    @ApiModelProperty("账户编码")
    private Set<String> accountCodes;

    @ApiModelProperty("支付规则明细")
    private List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlDTOList;


    //rpc
    @ApiModelProperty("单据")
    private String doc;

    @ApiModelProperty("单据类型")
    private String docType;

    @ApiModelProperty("单据状态")
    private String docStatus;

    @ApiModelProperty("来源单据金额")
    private BigDecimal docAmount;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("来源单据id")
    private Long sourceId;

    @ApiModelProperty("对象编码")
    private String objectCode;

    @ApiModelProperty("对象组编码")
    private String objectGroupCode;

    @ApiModelProperty("授信组织/公司编码")
    private String ouCode;

    @ApiModelProperty("支付规则明细id")
    private Set<Long> paymentRuleConfigDtlIds;

    @ApiModelProperty("指定返利金额")
    private BigDecimal rebateAmount;



}
