package com.elitesland.fin.application.service.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFlexibleValueConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinFlexibleValueParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinFlexibleValueVO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class FinFlexibleValueServiceImpl implements FinFlexibleValueService{

    private final FinFlexibleValueRepo finFlexibleValueRepo;

    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;

    private final FinFlexibleRepo finFlexibleRepo;
    @SysCodeProc
    @Override
    public PagingVO<FinFlexibleValueVO> page(FinFlexibleValueParam finFlexibleValueParam) {
        if(finFlexibleValueParam.getMasId()==null){
           if(StringUtils.isNotBlank(finFlexibleValueParam.getFlexibleCode())){
               //查询masId
               List<FinFlexibleDO> allByFlexibleCode = finFlexibleRepo.findAllByFlexibleCode(finFlexibleValueParam.getFlexibleCode());
               if(allByFlexibleCode.size()>0){
                   finFlexibleValueParam.setMasId(allByFlexibleCode.get(0).getId());
               }
           }
        }
        return FinFlexibleValueConvert.INSTANCE.DTOToVO(finFlexibleValueRepoProc.page(finFlexibleValueParam));
    }
}
