package com.elitesland.fin.application.service.excel.entity;

import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.application.facade.excel.convert.DefaultDateTimeConverter;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class AdjustExportEntity implements Serializable {
    @ApiModelProperty("单号")
    private String docNo;
    
    @ApiModelProperty("单据状态")
    private String stateName;
    
    @ApiModelProperty("单据类型")
    private String typeName;
    
    @ApiModelProperty("记账时间")
    @ExcelConvert(converter = DateTimeToDateConverter.class)
    private LocalDate recAccTime;
    
    @ApiModelProperty("账户名称")
    private String accNameName;
    
    @ApiModelProperty("账户编码")
    private String accCode;
    
    @ApiModelProperty("账户类型")
    private String accTypeName;
    
    @ApiModelProperty("总金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private String totalAmt;
    
    @ApiModelProperty("审核人")
    private String auditUser;
    
    @ApiModelProperty("审核人id")
    private Long auditUserId;
    
    @ApiModelProperty("审核时间")
    @ExcelConvert(converter = DefaultDateTimeConverter.class)
    private String auditTime;
    
    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;
    
    @ApiModelProperty("公司编码")
    private String ouCode;
    
    @ApiModelProperty("公司名称")
    private String ouName;
    
    @ApiModelProperty("公司id")
    private Long ouId;
    
    @ApiModelProperty("调整原因")
    private String adjReasonName;
    
    @ApiModelProperty("调整类型")
    private String adjTypeName;
    
    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;
    @ApiModelProperty("流程实例状态名称")
    private String procInstStatusName;
    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }
    
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    
    @ApiModelProperty("开户主体名称")
    private String accountHolderName;
    
    @ApiModelProperty("开户主体编码")
    private String accountHolderCode;
    
    @ApiModelProperty(value = "备注")
    private String remark;
    
    @ApiModelProperty("创建时间")
    @ExcelConvert(converter = DateTimeToDateConverter.class, name = "createTime")
    private LocalDate createDate;
    
    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;
    
    @ApiModelProperty(value = "修改人")
    private String updater;
    
    @ExcelConvert(converter = DefaultDateTimeConverter.class)
    private String modifyTime;
    
    @ApiModelProperty("创建人")
    private String creator;
}
