package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.application.facade.param.adjustorder.AdjustOrderPageParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.application.service.adjustorder.AdjustOrderService;
import com.elitesland.fin.application.service.excel.ExportConstants;
import com.elitesland.fin.application.service.excel.entity.AdjustExportEntity;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
public class DefaultAdjustExportServiceImpl implements DataExport<AdjustExportEntity, AdjustOrderPageParam> {
    private final AdjustOrderService adjustOrderService;
    @Override
    public String getTmplCode() {
        return ExportConstants.FIN_ADJUST_EXPORT_DEFAULT_IMPL;
    }
    
    @Override
    public PagingVO<AdjustExportEntity> executeExport(AdjustOrderPageParam param){
        PagingVO<AdjustOrderVO> page = adjustOrderService.page(param);
        if(page.isNotEmpty()) {
            List<AdjustOrderVO> records = page.getRecords();
            List<AdjustExportEntity> adjustExportEntities = ExcelConvertUtils.convertLoosely(records, AdjustExportEntity.class);
            return new PagingVO<>(page.getTotal(), adjustExportEntities);
        }
        return new PagingVO<>(0, List.of());
    }
}
