package com.elitesland.fin.application.service.workflow.arorder;

import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.QArOrderDO;
import com.elitesland.fin.domain.entity.recorder.QRecOrderDO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.service.SysUserFlowRoleRpcService;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;


/**
 * @author zhiyu.he
 * @date 2022/5/7 13:25
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ArOrderProcessServiceImpl implements ArOrderProcessService {


    private final SysUserFlowRoleRpcService sysUserFlowRoleRpcService;

    private final ArOrderRepoProc arOrderRepoProc;

    private final JPAQueryFactory jpaQueryFactory;

    @Transactional(rollbackFor = {Exception.class})
    @Override
    public void processStatusChange(long id, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        ArOrderDTO arOrderDTO = arOrderRepoProc.get(id);
        if (arOrderDTO == null) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }
        QArOrderDO qRecOrderDO = QArOrderDO.arOrderDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qRecOrderDO)
                .set(qRecOrderDO.procInstStatus, procInstStatus)
                .where(qRecOrderDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            // 未提交   状态为草稿
            case NOTSUBMIT:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                break;
            // 中断执行 业务转会草稿
            case INTERRUPT:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(qRecOrderDO.procInstId, (String) null);
                break;
                //审批中
            case APPROVING:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DOING.getValueCode())
                        .set(qRecOrderDO.submitTime,LocalDateTime.now());
                break;
            // 审批拒绝 业务数据为草稿
            case REJECTED:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(qRecOrderDO.approvedTime, LocalDateTime.now())
                        .set(qRecOrderDO.auditDate, LocalDateTime.now())
                        .set(qRecOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(qRecOrderDO.auditRejection, commentInfo.getComment())
                        .set(qRecOrderDO.auditUser, commentInfo.getUserName());
                break;
            // 作废
            case INVALID:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_DRAFT.getValueCode())
                        .set(qRecOrderDO.approvedTime, LocalDateTime.now())
                        .set(qRecOrderDO.auditDate, LocalDateTime.now())
                        .set(qRecOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(qRecOrderDO.auditRejection, commentInfo.getComment())
                        .set(qRecOrderDO.procInstId, (String) null)
                        .set(qRecOrderDO.auditUser, commentInfo.getUserName())
                        .set(qRecOrderDO.procInstId, (String) null);

                break;
            // 审批通过 //已审批
            case APPROVED:
                jpaUpdateClause.set(qRecOrderDO.orderState, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())
                    .set(qRecOrderDO.proposedStatus, UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode())
                    .set(qRecOrderDO.approvedTime, LocalDateTime.now())
                        .set(qRecOrderDO.auditDate, LocalDateTime.now())
                        .set(qRecOrderDO.auditUserId, Long.valueOf(commentInfo.getUserId()))
                        .set(qRecOrderDO.auditUser, commentInfo.getUserName());
                break;
            default:
                break;
        }
        //执行
        jpaUpdateClause.execute();
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        Long businessId = Long.valueOf(businessKey);
        ArOrderDTO arOrderDTO = arOrderRepoProc.get(businessId);
        if (arOrderDTO == null) {
            throw new BusinessException("单据(id:" + businessId + ")不存在,无法审批");
        }
        SysUserIdFlowRoleRpcParam param = SysUserIdFlowRoleRpcParam.builder()
                .ouIds(Collections.singletonList(arOrderDTO.getOuId()))
                .flowRoleCodes(Collections.singletonList(customParams))
                .build();
        List<Long> userIdsByFlowRoles = sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
        return userIdsByFlowRoles.stream().map(e -> e + "").collect(Collectors.toCollection(ArrayList::new));
    }
}
