package com.elitesland.fin.entity.flowrepair;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/25
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name = "account_flow_repair")
@org.hibernate.annotations.Table(appliesTo = "account_flow_repair", comment = "账户流水修复重算表")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class AccountFlowRepairDO extends BaseModel {

    @ApiModelProperty(value = "流水号")
    @Comment("流水号")
    @Column(columnDefinition = "varchar(32)")
    private String flowNo;

    @ApiModelProperty(value = "实际金额")
    @Comment("实际金额")
    @Column(columnDefinition = "decimal(18,8)")
    private BigDecimal actualAmount;

    @ApiModelProperty(value = "原流水发生金额")
    @Comment("原流水发生金额")
    @Column(columnDefinition = "decimal(18,8)")
    private BigDecimal amount;

    @ApiModelProperty(value = "开户主体编码")
    @Comment("开户主体编码")
    @Column(columnDefinition = "varchar(64)")
    private String openAccountEntityCode;

    @ApiModelProperty(value = "开户主体名称")
    @Comment("开户主体名称")
    @Column(columnDefinition = "varchar(200)")
    private String openAccountEntityName;

    @ApiModelProperty(value = "账户类型")
    @Comment("账户类型")
    @Column(columnDefinition = "varchar(32)")
    private String accountType;

    @ApiModelProperty(value = "账户编码")
    @Comment("账户编码")
    @Column(columnDefinition = "varchar(64)")
    private String accountCode;

    @ApiModelProperty(value = "账户名称")
    @Comment("账户名称")
    @Column(columnDefinition = "varchar(200)")
    private String accountName;

    @ApiModelProperty(value = "来源单号")
    @Comment("来源单号")
    @Column(columnDefinition = "varchar(64)")
    private String sourceNo;

    @ApiModelProperty(value = "修复状态")
    @Comment("修复状态")
    @Column(columnDefinition = "varchar(32)")
    private String repairStatus;

    @ApiModelProperty(value = "重算原因")
    @Comment("重算原因")
    @Column(columnDefinition = "varchar(32)")
    private String recalculationReason;

    @ApiModelProperty(value = "开始重算日期")
    @Comment("开始重算日期")
    @Column(columnDefinition = "datetime(6)")
    private LocalDateTime recalculationDate;

    @ApiModelProperty(value = "重算人ID")
    @Comment("重算人ID")
    @Column(columnDefinition = "bigint(20)")
    private Long recalculationUserId;

    @ApiModelProperty(value = "重算人")
    @Comment("重算人")
    @Column(columnDefinition = "varchar(64)")
    private String recalculationUser;
}
