package com.elitesland.fin.provider.arorder;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlRecordConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderRecordConvert;
import com.elitesland.fin.application.facade.param.arorder.ArOrderDtlRecordSaveParam;
import com.elitesland.fin.application.facade.param.arorder.ArOrderRecordSaveParam;
import com.elitesland.fin.application.service.arorder.ArOrderService;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.dto.arorder.ArOrderRpcDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.param.arorder.ArOrderPageRpcParam;
import com.elitesland.fin.param.arorder.ArOrderRecordRpcParam;
import com.elitesland.fin.param.arorder.ArOrderRpcParam;
import com.elitesland.fin.service.arorder.ArOrderRpcService;
import com.elitescloud.cloudt.common.exception.BusinessException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.provider.arorder
 * 应收单
 * @date 2022/5/18 15:53
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + ArOrderRpcService.PATH)
@Slf4j
public class ArOrderRpcServiceImpl implements ArOrderRpcService {

    private final ArOrderDomainService arOrderDomainService;
    private final ArOrderService arOrderService;
    private final TaskExecutor taskExecutor;

    @Override
    public Long save(ArOrderRpcParam arOrderRpcParam) {
        if (CharSequenceUtil.isBlank(arOrderRpcParam.getCreateMode())) {
            throw new BusinessException("createMode不能为空");
        }
        ArOrder arOrder = ArOrderConvert.INSTANCE.convertRpc(arOrderRpcParam);
        Long resId = arOrderDomainService.save(arOrder);
        return resId;
    }
    @SysCodeProc
    @Override
    public ApiResult<PagingVO<ArOrderRpcDTO>> page(ArOrderPageRpcParam arOrderPageRpcParam) {
        PagingVO<ArOrderDTO> arOrderVOPagingVO = arOrderDomainService
                .page(ArOrderConvert.INSTANCE.arOrderPageRpcParam2ArOrderPageParam(arOrderPageRpcParam));
        return ApiResult.ok(ArOrderConvert.INSTANCE.arOrderDTOPagingVO2ArOrderRpcDTOPagingVO(arOrderVOPagingVO));

    }

    /**
     * 自动生成应收单:命中配置项设置规则的业务单据则可以生成
     * <p>
     * 业务方提供公司，来源单据，来源单据类型，来源单据状态等入参，调用该接口时判断是否命中应收单类型的配置规则，
     * 命中规则的数据按接口样式传输生成对应的应收单，状态是待审核；根据配置项判断是否自动审核。
     * 已生成应收单的业务单据需要打上标记ar_flag，1表示已经生成；0表示未生成。
     *（注意调用规则时判断该公司是否分配该规则，如果没分配的话给出提示未分配公司）
     *
     * @param arOrderRecordRpcParam 入参
     * @return 出参
     */
    @Override
    public ApiResult<Void> autoCreate(@RequestBody ArOrderRecordRpcParam arOrderRecordRpcParam){
        log.info("自动生成应收单入参参数: {}", JSON.toJSONString(arOrderRecordRpcParam));

        //异步
        CompletableFuture.runAsync(() ->{
            ArOrderRecordSaveParam arOrderRecordSaveParam = ArOrderRecordConvert.INSTANCE.rpcToSaveParam(arOrderRecordRpcParam);
            List<ArOrderDtlRecordSaveParam> arOrderDtlRecordSaveParamList = ArOrderDtlRecordConvert.INSTANCE.rpcToSaveParamBatch(arOrderRecordRpcParam.getArOrderDtlRecordRpcParams());
            arOrderRecordSaveParam.setArOrderDtlRecordSaveParams(arOrderDtlRecordSaveParamList);
            arOrderService.autoCreate(arOrderRecordSaveParam);
        }, taskExecutor);

        return ApiResult.ok();
    }

}
