package com.elitesland.fin.rpc.pur;

import static org.apache.kafka.common.requests.FetchMetadata.log;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.dto.PurAccountDTO;
import com.elitesland.pur.provider.PurAccountProvider;
import java.util.List;
import java.util.function.Supplier;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @description: TODO
 * @author: huruizhong
 * @modified By: huruizhong
 * @date: Created in 2024/3/8 3:01 下午
 * @version:v1.0
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class RmiPurRpcServiceImpl implements RmiPurRpcService {

    private final PurAccountProvider purAccountProvider;

    /**
     * 异常检查
     *
     * @param supplier
     * @return
     */
    private Object checkError(Supplier<ApiResult> supplier) {
        try {
            ApiResult apiResult = supplier.get();
            if (!apiResult.isSuccess()) {
                log.error("采购域调用异常:{}", apiResult.getMsg());
                throw new BusinessException(apiResult.getMsg());
            }
            return apiResult.getData();
        } catch (Exception e) {
            log.error("采购域调用异常：", e);
            throw new BusinessException("采购域报错：", e);

        }
    }

    @Override
    public void batchUpdateDocStatus(PurAccountDTO purAccountDTO) {
        this.checkError(() -> purAccountProvider.batchUpdateDocStatus(purAccountDTO));
    }
}
