package com.elitesland.fin.utils;

import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

/**
 * @author sunxw
 * @Description:
 * @date 2022/5/30 - 21:59
 */
public class TimeUtil {
    //string 转 cron格式
    public static String formatDateByPattern(Date date, String dateFormat){
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }
    public static String getCron(Date  date){
        String dateFormat="ss mm HH dd MM ?";
        //String dateFormat="ss mm HH dd MM ? yyyy";
        return formatDateByPattern(date, dateFormat);
    }

    /**
     * 日期转string(带-)
     * @param date
     * @return
     */
    public static String dateToYmd(LocalDate date) {
        return date == null ? "" : date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate dateFromYmd(String ymd) {
        return StringUtils.isEmpty(ymd) ? null : LocalDate.parse(ymd, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    /**
     * 日期转string(不带-)
     * @param date
     * @return
     */
    public static String date2String(LocalDate date) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        LocalDate now = LocalDate.now();
        return format.format(now);
    }

    /**
     * 年月日转localDate
     * @param yyyyMMdd
     * @return
     */
    public static LocalDate string2Date(String yyyyMMdd){
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMdd");
        return LocalDate.parse(yyyyMMdd,format);
    }

    public static String time2String(LocalTime time) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("HHmmss");
        LocalTime now = LocalTime.now();
        return format.format(now);
    }

    public static String datetime2String(LocalDateTime localDateTime){
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime now = LocalDateTime.now();
        return format.format(now);
    }

}
