package com.elitesland.fin.utils.excel.convert;

/**
 * convert IN to OUT, when converting can use base value.
 */
public interface Converter<IN, OUT, BASE> {
    /**
     * convert value(IN) to return value(OUT)
     */
    OUT convert(IN value);
    
    /**
     * initialize base value
     */
    default BASE initBaseValue() {
        return null;
    }
    
    /**
     * get base value
     */
    default BASE baseValue() {
        return null;
    }
    
    /**
     * refresh base value when it needs to refresh
     */
    default BASE refreshBaseValue() {
        return null;
    }
}
