/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.facade.excel.convert;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.utils.excel.convert.Converter;
import java.math.BigDecimal;

public class QuantitySupplyZeroConverter
extends Converter<Long, String, Integer> {
    private static final SystemRpcService systemRpcService = (SystemRpcService)SpringContextHolder.getBean(SystemRpcService.class);

    @Override
    public String convert(Long value) {
        if (value == null) {
            value = 0L;
        }
        if (this.baseValue == null) {
            return value.toString();
        }
        return BigDecimal.valueOf(value, (Integer)this.baseValue).toPlainString();
    }

    @Override
    public Integer initBaseValue() {
        return this.setQuantityAccuracyBySettingService();
    }

    @Override
    public synchronized Integer refreshBaseValue() {
        return this.setQuantityAccuracyBySettingService();
    }

    private Integer setQuantityAccuracyBySettingService() {
        SysSettingVO quantityDecimalPlace = systemRpcService.findSysSettingByNo("QUANTITY_DECIMAL_PLACE");
        if (quantityDecimalPlace != null && quantityDecimalPlace.getSettingVal() != null && !quantityDecimalPlace.getSettingVal().equals("")) {
            this.baseValue = Integer.parseInt(quantityDecimalPlace.getSettingVal());
        }
        return (Integer)this.baseValue;
    }
}

