/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.payorder;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.application.convert.paytype.PayTypeConvert;
import com.elitesland.fin.application.facade.param.payorder.ApOrderToPaySaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderDtlSaveParam;
import com.elitesland.fin.application.facade.param.payorder.PayOrderSaveParam;
import com.elitesland.fin.application.facade.vo.payorder.PayOrderVO;
import com.elitesland.fin.application.service.payorder.PayOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.apordertopay.ApOrderToPay;
import com.elitesland.fin.domain.entity.apverrec.ApVerRecDtl;
import com.elitesland.fin.domain.entity.payorder.PayOrder;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtl;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.service.aporder.ApOrderDomainService;
import com.elitesland.fin.domain.service.apordertopay.ApOrderToPayDomainService;
import com.elitesland.fin.domain.service.apverrec.ApVerRecDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.domain.service.payorder.PayOrderDtlDomainService;
import com.elitesland.fin.domain.service.paytype.PayTypeDomainService;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.apordertopay.ApOrderToPayDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.dto.paytype.PayTypeDTO;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayOrderServiceImpl
implements PayOrderService {
    private final PayOrderDomainService payOrderDomainService;
    private final PayOrderDtlDomainService payOrderDtlDomainService;
    private final PayTypeDomainService payTypeDomainService;
    private final ApOrderToPayDomainService apOrderToPayDomainService;
    private final ApOrderDomainService apOrderDomainService;
    private final ApVerRecDomainService apVerRecDomainService;
    private final WorkflowRpcService workflowRpcService;
    private final PayOrderDtlRepoProc payOrderDtlRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<PayOrderVO> page(PayOrderPageParam param) {
        PagingVO<PayOrderDTO> page = this.payOrderDomainService.page(param);
        PagingVO<PayOrderVO> payOrderVOPagingVO = PayOrderConvert.INSTANCE.convertPage(page);
        return payOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<PayOrderVO> writeoffPage(PayOrderPageParam param) {
        PagingVO<PayOrderDTO> page = this.payOrderDomainService.page(param);
        PagingVO<PayOrderVO> payOrderVOPagingVO = PayOrderConvert.INSTANCE.convertPage(page);
        if (payOrderVOPagingVO.isEmpty()) {
            return payOrderVOPagingVO;
        }
        List<Long> masIds = payOrderVOPagingVO.getRecords().stream().map(PayOrderVO::getId).collect(Collectors.toList());
        List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlRepoProc.queryByMasId(masIds);
        Map payorderDtlDTOMap = payOrderDtlDTOS.stream().collect(Collectors.groupingBy(PayOrderDtlDTO::getMasId, Collectors.toList()));
        payOrderVOPagingVO.getRecords().stream().forEach(v -> {
            BigDecimal verAmt = BigDecimal.ZERO;
            BigDecimal verAmting = BigDecimal.ZERO;
            BigDecimal unVerAmt = BigDecimal.ZERO;
            List payOrderDtlDTOS1 = (List)payorderDtlDTOMap.get(v.getId());
            if (CollUtil.isNotEmpty((Collection)payOrderDtlDTOS1)) {
                for (PayOrderDtlDTO payOrderDtlDTO : payOrderDtlDTOS1) {
                    verAmt = verAmt.add(payOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(payOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(payOrderDtlDTO.getUnVerAmt());
                }
            }
            v.setVerAmt(verAmt);
            v.setApplyVerAmTing(verAmting);
            v.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(v.getTotalAmt()) == 0) {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                v.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
        });
        return payOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public PayOrderVO queryById(Long id) {
        PayOrderDTO payOrderDTO = this.payOrderDomainService.queryById(id, false);
        PayOrderVO payOrderVO = PayOrderConvert.INSTANCE.dtoToVo(payOrderDTO);
        return payOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> deleteByIds(List<Long> ids) {
        List<Long> deleteByIds = this.payOrderDomainService.deleteByIds(ids);
        this.apOrderToPayDomainService.deleteByPayIds(ids);
        return ApiResult.ok(deleteByIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(PayOrderSaveParam param) {
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertParam(param);
        if (param.getId() != null) {
            this.deleteBeforePushDate(param);
        }
        Long id = this.payOrderDomainService.save(payOrder);
        return ApiResult.ok((Object)id);
    }

    private void deleteBeforePushDate(PayOrderSaveParam param) {
        if (param.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode())) {
            this.checkApOrderMoney(param);
            this.apOrderToPayDomainService.deleteByPayId(param.getId());
            this.saveApOrderToPay(param);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> submit(PayOrderSaveParam param) {
        PayOrder payOrder = PayOrderConvert.INSTANCE.convertParam(param);
        if (param.getId() != null) {
            this.deleteBefore(param);
        }
        Long id = this.payOrderDomainService.submit(payOrder);
        if (payOrder.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(payOrder.getProcInstStatus())) {
            String procInstName = "\u4ed8\u6b3e\u5355\u5ba1\u6838-" + payOrder.getPayOrderNo();
            String procKey = WorkFlowDefKey.FIN_PAY_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, id.toString(), new HashMap<String, Object>());
            this.payOrderDomainService.updateWorkInfo(processInfo, id);
        }
        return ApiResult.ok((Object)id);
    }

    private void deleteBefore(PayOrderSaveParam param) {
        if (param.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode())) {
            this.checkApOrderMoney(param);
            this.apOrderToPayDomainService.deleteByPayId(param.getId());
            this.saveApOrderToPay(param);
        }
    }

    @Override
    public ApiResult<PayOrderVO> defaultValue() {
        PayTypeDTO payTypeDTO = this.payTypeDomainService.defaultValue();
        PayOrderVO payOrderVO = PayTypeConvert.INSTANCE.typeToOrder(payTypeDTO);
        if (payOrderVO == null) {
            return ApiResult.ok((Object)new PayOrderVO());
        }
        return ApiResult.ok((Object)payOrderVO);
    }

    @Override
    @SysCodeProc
    public PayOrderVO queryDetailsById(Long id) {
        PayOrderDTO payOrderDTO = this.payOrderDomainService.queryById(id, true);
        PayOrderVO payOrderVO = PayOrderConvert.INSTANCE.dtoToVo(payOrderDTO);
        return payOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> saveByApOrder(ApOrderToPaySaveParam param) {
        List<ApOrderDTO> apOrderDTOS = this.apOrderDomainService.queryByIds(param.getIds());
        ArrayList ouCode = new ArrayList();
        ArrayList supCode = new ArrayList();
        ArrayList curr = new ArrayList();
        ArrayList apType = new ArrayList();
        apOrderDTOS.forEach(dto -> {
            if (!dto.getOrderState().equals(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode())) {
                throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u9009\u62e9\u5ba1\u6838\u901a\u8fc7\u7684\u5e94\u4ed8\u5355\u636e!");
            }
            if (dto.getTotalAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u9009\u62e9\u5e94\u4ed8\u5355\u91d1\u989d\u4e0d\u4e3a0\u7684\u5355\u636e!");
            }
            ouCode.add(dto.getOuCode());
            supCode.add(dto.getSuppCode());
            curr.add(dto.getCurrCode());
            apType.add(dto.getApTypeCode());
        });
        List ou = ouCode.stream().distinct().collect(Collectors.toList());
        if (ou.size() > 1) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u540c\u4e00\u5bb6\u516c\u53f8\u7684\u6570\u636e!");
        }
        List sup = supCode.stream().distinct().collect(Collectors.toList());
        if (sup.size() > 1) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u540c\u4e00\u5bb6\u4f9b\u5e94\u5546\u7684\u6570\u636e!");
        }
        List currCode = curr.stream().distinct().collect(Collectors.toList());
        if (currCode.size() > 1) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u540c\u4e00\u5e01\u79cd\u7684\u6570\u636e!");
        }
        List apTypeCode = apType.stream().distinct().collect(Collectors.toList());
        if (apTypeCode.size() > 1) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u540c\u4e00\u5e94\u4ed8\u5355\u7c7b\u578b\u7684\u6570\u636e!");
        }
        Map<Long, List<ApOrderToPayDTO>> apOrderToPayMap = this.apOrderToPayDomainService.queryByApId(param.getIds()).stream().collect(Collectors.groupingBy(ApOrderToPayDTO::getApOrderId));
        HashMap<Long, BigDecimal> BigDecimalMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<ApOrderToPayDTO>> entry : apOrderToPayMap.entrySet()) {
            BigDecimal reduce = entry.getValue().stream().map(ApOrderToPayDTO::getPayAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimalMap.put(entry.getKey(), reduce);
        }
        apOrderDTOS.forEach(order -> {
            if (BigDecimalMap.get(order.getId()) != null) {
                BigDecimal payAmt = order.getTotalAmt().subtract((BigDecimal)BigDecimalMap.get(order.getId())).subtract(order.getVerAmt());
                if (payAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e94\u4ed8\u5355\u53f7:" + order.getApOrderNo() + ",\u53ef\u63a8\u91d1\u989d\u4e0d\u8db3,\u8bf7\u91cd\u65b0\u9009\u62e9!");
                }
                order.setTotalAmt(payAmt);
            }
        });
        PayOrder payOrder = new PayOrder();
        this.getPayOrder(payOrder, param, apOrderDTOS);
        List<PayOrderDtl> dtl = this.getDtl(apOrderDTOS, param);
        payOrder.setDtlList(dtl);
        Long id = this.payOrderDomainService.save(payOrder);
        return ApiResult.ok((Object)id.toString());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approved(Long id) {
        PayOrderDTO payOrderDTO = this.payOrderDomainService.queryById(id, false);
        if (payOrderDTO.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode()) && !payOrderDTO.getApFlag().booleanValue()) {
            List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlDomainService.queryByMasId(CollUtil.newArrayList((Object[])new Long[]{payOrderDTO.getId()}));
            List<Long> apIds = payOrderDtlDTOS.stream().map(PayOrderDtlDTO::getSourceId).collect(Collectors.toList());
            List<ApOrderDTO> apOrderDTOS = this.apOrderDomainService.queryByIds(apIds);
            ApOrderDTO apOrderDTO = apOrderDTOS.get(0);
            Map<Long, ApOrderDTO> apOrderDTOMap = apOrderDTOS.stream().collect(Collectors.toMap(ApOrderDTO::getId, t -> t));
            ArrayList<ApVerRecDtl> apVerRecDtls = new ArrayList<ApVerRecDtl>();
            List payVerDtls = payOrderDtlDTOS.stream().map(t -> {
                ApVerRecDtl apVerRecDtl = new ApVerRecDtl();
                apVerRecDtl.setOuCode(apOrderDTO.getOuCode());
                apVerRecDtl.setOuName(apOrderDTO.getOuName());
                apVerRecDtl.setOuId(apOrderDTO.getOuId());
                apVerRecDtl.setSuppCode(apOrderDTO.getSuppCode());
                apVerRecDtl.setSuppName(apOrderDTO.getSuppName());
                apVerRecDtl.setSuppId(apOrderDTO.getSuppId());
                apVerRecDtl.setCurrCode(apOrderDTO.getCurrCode());
                apVerRecDtl.setCurrName(apOrderDTO.getCurrName());
                apVerRecDtl.setAmt(t.getRealPayAmt());
                apVerRecDtl.setOrderId(t.getMasId());
                apVerRecDtl.setOrderNo(payOrderDTO.getPayOrderNo());
                apVerRecDtl.setOrderType("PAY");
                apVerRecDtl.setOrderName("\u4ed8\u6b3e\u5355");
                apVerRecDtl.setVerDate(LocalDateTime.now());
                apVerRecDtl.setBuDate(payOrderDTO.getBuDate());
                apVerRecDtl.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_AUTO.getValueCode());
                return apVerRecDtl;
            }).collect(Collectors.toList());
            apVerRecDtls.addAll(payVerDtls);
            List apVerDtls = payOrderDtlDTOS.stream().map(t -> {
                ApVerRecDtl apVerRecDtl = new ApVerRecDtl();
                apVerRecDtl.setOuCode(apOrderDTO.getOuCode());
                apVerRecDtl.setOuName(apOrderDTO.getOuName());
                apVerRecDtl.setOuId(apOrderDTO.getOuId());
                apVerRecDtl.setSuppCode(apOrderDTO.getSuppCode());
                apVerRecDtl.setSuppName(apOrderDTO.getSuppName());
                apVerRecDtl.setSuppId(apOrderDTO.getSuppId());
                apVerRecDtl.setCurrCode(apOrderDTO.getCurrCode());
                apVerRecDtl.setCurrName(apOrderDTO.getCurrName());
                apVerRecDtl.setAmt(t.getRealPayAmt());
                apVerRecDtl.setOrderId(t.getSourceId());
                apVerRecDtl.setOrderNo(((ApOrderDTO)apOrderDTOMap.get(t.getSourceId())).getApOrderNo());
                apVerRecDtl.setOrderType("AP");
                apVerRecDtl.setOrderName("\u5e94\u4ed8\u5355");
                apVerRecDtl.setVerDate(LocalDateTime.now());
                apVerRecDtl.setBuDate(apOrderDTO.getBuDate());
                apVerRecDtl.setVerifyType(UdcEnum.FIN_VERIFY_TYPE_AUTO.getValueCode());
                return apVerRecDtl;
            }).collect(Collectors.toList());
            apVerRecDtls.addAll(apVerDtls);
            this.apVerRecDomainService.save(apVerRecDtls);
            apVerRecDtls.stream().forEach(t -> {
                if (t.getOrderType().equals("AP")) {
                    this.apOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
                } else if (t.getOrderType().equals("PAY")) {
                    this.payOrderDomainService.updateVerAmt(t.getOrderId(), t.getAmt());
                }
            });
        }
    }

    private List<PayOrderDtl> getDtl(List<ApOrderDTO> apOrderDTOS, ApOrderToPaySaveParam param) {
        return apOrderDTOS.stream().map(dto -> {
            PayOrderDtl dtl = new PayOrderDtl();
            dtl.setSourceId(dto.getId());
            dtl.setSourceNo(dto.getApOrderNo());
            dtl.setPayAccount(param.getPayAccount());
            dtl.setPayBank(param.getPayBank());
            dtl.setPayType(param.getPayType());
            dtl.setRecBank(param.getRecBank());
            dtl.setRecAccount(param.getRecAccount());
            dtl.setTotalAmt(dto.getTotalAmt());
            return dtl;
        }).collect(Collectors.toList());
    }

    private void getPayOrder(PayOrder payOrder, ApOrderToPaySaveParam param, List<ApOrderDTO> apOrderDTOS) {
        payOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        payOrder.setCreateMode(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode());
        payOrder.setRemark(param.getRemark());
        ApOrderDTO apOrderDTO = apOrderDTOS.get(0);
        payOrder.setOuId(apOrderDTO.getOuId());
        payOrder.setOuCode(apOrderDTO.getOuCode());
        payOrder.setOuName(apOrderDTO.getOuName());
        payOrder.setSuppCode(apOrderDTO.getSuppCode());
        payOrder.setSuppName(apOrderDTO.getSuppName());
        payOrder.setSuppId(apOrderDTO.getSuppId());
        payOrder.setApTypeId(apOrderDTO.getApTypeId());
        payOrder.setApTypeName(apOrderDTO.getApTypeName());
        payOrder.setApTypeCode(apOrderDTO.getApTypeCode());
        payOrder.setApFlag(false);
        payOrder.setInitFlag(false);
        payOrder.setLocalCurrCode(apOrderDTO.getLocalCurrCode());
        payOrder.setLocalCurrName(apOrderDTO.getLocalCurrName());
        payOrder.setCurrCode(apOrderDTO.getCurrCode());
        payOrder.setCurrName(apOrderDTO.getCurrName());
        payOrder.setExchangeRate(apOrderDTO.getExchangeRate());
        payOrder.setBuDate(LocalDateTime.now());
        payOrder.setApDate(LocalDateTime.now());
    }

    private void saveApOrderToPay(PayOrderSaveParam param) {
        List<ApOrderToPay> collect = param.getPayOrderDtlSaveParams().stream().map(dtl -> {
            ApOrderToPay apOrderToPay = new ApOrderToPay();
            apOrderToPay.setPayOrderId(param.getId());
            apOrderToPay.setApOrderId(dtl.getSourceId());
            apOrderToPay.setPayAmt(dtl.getTotalAmt());
            apOrderToPay.setSourceType(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode());
            return apOrderToPay;
        }).collect(Collectors.toList());
        this.apOrderToPayDomainService.save(collect);
    }

    private void checkApOrderMoney(PayOrderSaveParam param) {
        List<PayOrderDtlSaveParam> payOrderDtlSaveParams = param.getPayOrderDtlSaveParams();
        List<Long> apOrderId = payOrderDtlSaveParams.stream().map(PayOrderDtlSaveParam::getSourceId).collect(Collectors.toList());
        List<ApOrderDTO> orderDTOS = this.apOrderDomainService.queryByIds(apOrderId);
        Map<Long, ApOrderDTO> apMap = orderDTOS.stream().collect(Collectors.toMap(ApOrderDTO::getId, t -> t));
        Map<Long, List<ApOrderToPayDTO>> apOrderToPayMap = this.apOrderToPayDomainService.queryByApId(apOrderId).stream().collect(Collectors.groupingBy(ApOrderToPayDTO::getApOrderId));
        HashMap<Long, BigDecimal> BigDecimalMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, List<ApOrderToPayDTO>> entry : apOrderToPayMap.entrySet()) {
            BigDecimal reduce = entry.getValue().stream().filter(order -> !order.getPayOrderId().equals(param.getId())).map(ApOrderToPayDTO::getPayAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimalMap.put(entry.getKey(), reduce);
        }
        payOrderDtlSaveParams.forEach(order -> {
            if (BigDecimalMap.get(order.getSourceId()) != null) {
                PayOrderServiceImpl.payAmtCount(apMap, BigDecimalMap, order);
            }
        });
    }

    private static void payAmtCount(Map<Long, ApOrderDTO> apMap, HashMap<Long, BigDecimal> BigDecimalMap, PayOrderDtlSaveParam order) {
        if (apMap.get(order.getSourceId()) != null) {
            BigDecimal apOrderAmount = apMap.get(order.getSourceId()).getTotalAmt();
            BigDecimal verAmount = apMap.get(order.getSourceId()).getVerAmt();
            BigDecimal payAmt = apOrderAmount.subtract(verAmount).subtract(BigDecimalMap.get(order.getSourceId()));
            if (order.getTotalAmt().compareTo(payAmt) > 0) {
                throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e94\u4ed8\u5355\u53f7:" + order.getSourceNo() + ",\u53ef\u63a8\u91d1\u989d\u4e0d\u8db3,\u8bf7\u91cd\u65b0\u9009\u62e9!");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Void> cancelApprove(List<Long> ids) {
        List<PayOrderDO> payOrderDOS = this.payOrderDomainService.queryByIds(ids);
        this.checkCancelDoc(payOrderDOS);
        payOrderDOS.forEach(payOrderDTO -> {
            payOrderDTO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            payOrderDTO.setProposedStatus(null);
            payOrderDTO.setProcInstId(null);
            payOrderDTO.setProcInstStatus(null);
        });
        this.payOrderDomainService.saveAll(payOrderDOS);
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class, Exception.class})
    public ApiResult<Long> redPunch(Long id) {
        PayOrderDTO payOrderDTO = this.payOrderDomainService.queryById(id, false);
        this.checkRedPunch(payOrderDTO);
        PayOrder payOrder = this.payOrderDomainService.redPunchCreate(id);
        PayOrderSaveParam param = PayOrderConvert.INSTANCE.convert(payOrder);
        return this.submit(param);
    }

    void checkCancelDoc(List<PayOrderDO> payOrderDOS) {
        if (CollectionUtils.isEmpty(payOrderDOS)) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        payOrderDOS.forEach(payOrderDO -> {
            String perfix = "\u5355\u53f7\uff1a" + payOrderDO.getPayOrderNo() + "-";
            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(payOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode().equals(payOrderDO.getProposedStatus())) {
                throw new BusinessException(perfix + "\u62df\u5b9a\u72b6\u6001\u5fc5\u987b\u4e3a\u8349\u7a3f\u6216\u62df\u5b9a\u5931\u8d25");
            }
            if (BigDecimal.ZERO.compareTo(payOrderDO.getVerAmt()) != 0) {
                throw new BusinessException(perfix + "\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
            }
            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(payOrderDO.getOrderState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
            }
            if (Boolean.TRUE.equals(payOrderDO.getRedState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u5df2\u7ea2\u51b2");
            }
        });
    }

    void checkRedPunch(PayOrderDTO payOrderDTO) {
        if (Objects.isNull(payOrderDTO)) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        if (Boolean.TRUE.equals(payOrderDTO.getRedState())) {
            throw new BusinessException("\u5355\u636e\u5df2\u7ea2\u51b2");
        }
        if (Objects.nonNull(payOrderDTO.getRedSourceNo())) {
            throw new BusinessException("\u6765\u6e90\u5355\u636e\u4e0d\u53ef\u4e3a\u7ea2\u51b2\u5355\u636e");
        }
        if (BigDecimal.ZERO.compareTo(payOrderDTO.getVerAmt()) != 0) {
            throw new BusinessException("\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
        }
        if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(payOrderDTO.getOrderState())) {
            throw new BusinessException("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
        }
    }

    public PayOrderServiceImpl(PayOrderDomainService payOrderDomainService, PayOrderDtlDomainService payOrderDtlDomainService, PayTypeDomainService payTypeDomainService, ApOrderToPayDomainService apOrderToPayDomainService, ApOrderDomainService apOrderDomainService, ApVerRecDomainService apVerRecDomainService, WorkflowRpcService workflowRpcService, PayOrderDtlRepoProc payOrderDtlRepoProc) {
        this.payOrderDomainService = payOrderDomainService;
        this.payOrderDtlDomainService = payOrderDtlDomainService;
        this.payTypeDomainService = payTypeDomainService;
        this.apOrderToPayDomainService = apOrderToPayDomainService;
        this.apOrderDomainService = apOrderDomainService;
        this.apVerRecDomainService = apVerRecDomainService;
        this.workflowRpcService = workflowRpcService;
        this.payOrderDtlRepoProc = payOrderDtlRepoProc;
    }
}

