/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.entity.payorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.common.UdcEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class PayOrderDtl {
    private Long id;
    private Long masId;
    private String payType;
    private String payBank;
    private String payAccount;
    private String recBank;
    private String recAccount;
    private String sourceNo;
    private Integer sourceLine;
    private BigDecimal realPayAmt;
    private BigDecimal realPayCurAmt;
    private BigDecimal totalAmt;
    private BigDecimal totalCurAmt;
    private String expensesType;
    private Long buId;
    private String buName;
    private String buCode;
    private String remark;
    private Long sourceId;
    private Long sourceLineId;

    public void checkMoney(BigDecimal exchangeRate) {
        if (this.totalAmt.compareTo(this.realPayAmt) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u603b\u91d1\u989d\u4e0e\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u4e0d\u7b49!");
        }
        if (this.totalCurAmt.compareTo(this.totalAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u603b\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0e\u603b\u91d1\u989d*\u6c47\u7387\u4e0d\u7b49!");
        }
        if (this.realPayCurAmt.compareTo(this.realPayAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP)) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u5b9e\u9645\u652f\u4ed8\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0e\u5b9e\u9645\u652f\u4ed8\u91d1\u989d*\u6c47\u7387\u4e0d\u7b49!");
        }
    }

    public void countMoney(BigDecimal exchangeRate) {
        BigDecimal realAmt;
        BigDecimal curAmt;
        this.realPayAmt = this.totalAmt;
        this.totalCurAmt = curAmt = this.totalAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
        this.realPayCurAmt = realAmt = this.realPayAmt.multiply(exchangeRate).setScale(2, RoundingMode.HALF_UP);
    }

    public void checkNotNull(Boolean flag, String createMode) {
        if (createMode.equals(UdcEnum.FIN_PAY_DOC_CLS_MANU.getValueCode())) {
            if (flag.booleanValue()) {
                Assert.notNull((Object)this.masId, (String)"\u4ed8\u6b3e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            Assert.notNull((Object)this.payType, (String)"\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.payBank, (String)"\u6211\u65b9\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.totalAmt, (String)"\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.recAccount, (String)"\u6536\u6b3e\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (createMode.equals(UdcEnum.FIN_PAY_DOC_CLS_PO.getValueCode())) {
            Assert.notNull((Object)this.sourceNo, (String)"\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.payType, (String)"\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.totalAmt, (String)"\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getMasId() {
        return this.masId;
    }

    public String getPayType() {
        return this.payType;
    }

    public String getPayBank() {
        return this.payBank;
    }

    public String getPayAccount() {
        return this.payAccount;
    }

    public String getRecBank() {
        return this.recBank;
    }

    public String getRecAccount() {
        return this.recAccount;
    }

    public String getSourceNo() {
        return this.sourceNo;
    }

    public Integer getSourceLine() {
        return this.sourceLine;
    }

    public BigDecimal getRealPayAmt() {
        return this.realPayAmt;
    }

    public BigDecimal getRealPayCurAmt() {
        return this.realPayCurAmt;
    }

    public BigDecimal getTotalAmt() {
        return this.totalAmt;
    }

    public BigDecimal getTotalCurAmt() {
        return this.totalCurAmt;
    }

    public String getExpensesType() {
        return this.expensesType;
    }

    public Long getBuId() {
        return this.buId;
    }

    public String getBuName() {
        return this.buName;
    }

    public String getBuCode() {
        return this.buCode;
    }

    public String getRemark() {
        return this.remark;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public Long getSourceLineId() {
        return this.sourceLineId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMasId(Long masId) {
        this.masId = masId;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public void setPayBank(String payBank) {
        this.payBank = payBank;
    }

    public void setPayAccount(String payAccount) {
        this.payAccount = payAccount;
    }

    public void setRecBank(String recBank) {
        this.recBank = recBank;
    }

    public void setRecAccount(String recAccount) {
        this.recAccount = recAccount;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public void setSourceLine(Integer sourceLine) {
        this.sourceLine = sourceLine;
    }

    public void setRealPayAmt(BigDecimal realPayAmt) {
        this.realPayAmt = realPayAmt;
    }

    public void setRealPayCurAmt(BigDecimal realPayCurAmt) {
        this.realPayCurAmt = realPayCurAmt;
    }

    public void setTotalAmt(BigDecimal totalAmt) {
        this.totalAmt = totalAmt;
    }

    public void setTotalCurAmt(BigDecimal totalCurAmt) {
        this.totalCurAmt = totalCurAmt;
    }

    public void setExpensesType(String expensesType) {
        this.expensesType = expensesType;
    }

    public void setBuId(Long buId) {
        this.buId = buId;
    }

    public void setBuName(String buName) {
        this.buName = buName;
    }

    public void setBuCode(String buCode) {
        this.buCode = buCode;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public void setSourceLineId(Long sourceLineId) {
        this.sourceLineId = sourceLineId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayOrderDtl)) {
            return false;
        }
        PayOrderDtl other = (PayOrderDtl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$masId = this.getMasId();
        Long other$masId = other.getMasId();
        if (this$masId == null ? other$masId != null : !((Object)this$masId).equals(other$masId)) {
            return false;
        }
        Integer this$sourceLine = this.getSourceLine();
        Integer other$sourceLine = other.getSourceLine();
        if (this$sourceLine == null ? other$sourceLine != null : !((Object)this$sourceLine).equals(other$sourceLine)) {
            return false;
        }
        Long this$buId = this.getBuId();
        Long other$buId = other.getBuId();
        if (this$buId == null ? other$buId != null : !((Object)this$buId).equals(other$buId)) {
            return false;
        }
        Long this$sourceId = this.getSourceId();
        Long other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId)) {
            return false;
        }
        Long this$sourceLineId = this.getSourceLineId();
        Long other$sourceLineId = other.getSourceLineId();
        if (this$sourceLineId == null ? other$sourceLineId != null : !((Object)this$sourceLineId).equals(other$sourceLineId)) {
            return false;
        }
        String this$payType = this.getPayType();
        String other$payType = other.getPayType();
        if (this$payType == null ? other$payType != null : !this$payType.equals(other$payType)) {
            return false;
        }
        String this$payBank = this.getPayBank();
        String other$payBank = other.getPayBank();
        if (this$payBank == null ? other$payBank != null : !this$payBank.equals(other$payBank)) {
            return false;
        }
        String this$payAccount = this.getPayAccount();
        String other$payAccount = other.getPayAccount();
        if (this$payAccount == null ? other$payAccount != null : !this$payAccount.equals(other$payAccount)) {
            return false;
        }
        String this$recBank = this.getRecBank();
        String other$recBank = other.getRecBank();
        if (this$recBank == null ? other$recBank != null : !this$recBank.equals(other$recBank)) {
            return false;
        }
        String this$recAccount = this.getRecAccount();
        String other$recAccount = other.getRecAccount();
        if (this$recAccount == null ? other$recAccount != null : !this$recAccount.equals(other$recAccount)) {
            return false;
        }
        String this$sourceNo = this.getSourceNo();
        String other$sourceNo = other.getSourceNo();
        if (this$sourceNo == null ? other$sourceNo != null : !this$sourceNo.equals(other$sourceNo)) {
            return false;
        }
        BigDecimal this$realPayAmt = this.getRealPayAmt();
        BigDecimal other$realPayAmt = other.getRealPayAmt();
        if (this$realPayAmt == null ? other$realPayAmt != null : !((Object)this$realPayAmt).equals(other$realPayAmt)) {
            return false;
        }
        BigDecimal this$realPayCurAmt = this.getRealPayCurAmt();
        BigDecimal other$realPayCurAmt = other.getRealPayCurAmt();
        if (this$realPayCurAmt == null ? other$realPayCurAmt != null : !((Object)this$realPayCurAmt).equals(other$realPayCurAmt)) {
            return false;
        }
        BigDecimal this$totalAmt = this.getTotalAmt();
        BigDecimal other$totalAmt = other.getTotalAmt();
        if (this$totalAmt == null ? other$totalAmt != null : !((Object)this$totalAmt).equals(other$totalAmt)) {
            return false;
        }
        BigDecimal this$totalCurAmt = this.getTotalCurAmt();
        BigDecimal other$totalCurAmt = other.getTotalCurAmt();
        if (this$totalCurAmt == null ? other$totalCurAmt != null : !((Object)this$totalCurAmt).equals(other$totalCurAmt)) {
            return false;
        }
        String this$expensesType = this.getExpensesType();
        String other$expensesType = other.getExpensesType();
        if (this$expensesType == null ? other$expensesType != null : !this$expensesType.equals(other$expensesType)) {
            return false;
        }
        String this$buName = this.getBuName();
        String other$buName = other.getBuName();
        if (this$buName == null ? other$buName != null : !this$buName.equals(other$buName)) {
            return false;
        }
        String this$buCode = this.getBuCode();
        String other$buCode = other.getBuCode();
        if (this$buCode == null ? other$buCode != null : !this$buCode.equals(other$buCode)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        return !(this$remark == null ? other$remark != null : !this$remark.equals(other$remark));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PayOrderDtl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $masId = this.getMasId();
        result = result * 59 + ($masId == null ? 43 : ((Object)$masId).hashCode());
        Integer $sourceLine = this.getSourceLine();
        result = result * 59 + ($sourceLine == null ? 43 : ((Object)$sourceLine).hashCode());
        Long $buId = this.getBuId();
        result = result * 59 + ($buId == null ? 43 : ((Object)$buId).hashCode());
        Long $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        Long $sourceLineId = this.getSourceLineId();
        result = result * 59 + ($sourceLineId == null ? 43 : ((Object)$sourceLineId).hashCode());
        String $payType = this.getPayType();
        result = result * 59 + ($payType == null ? 43 : $payType.hashCode());
        String $payBank = this.getPayBank();
        result = result * 59 + ($payBank == null ? 43 : $payBank.hashCode());
        String $payAccount = this.getPayAccount();
        result = result * 59 + ($payAccount == null ? 43 : $payAccount.hashCode());
        String $recBank = this.getRecBank();
        result = result * 59 + ($recBank == null ? 43 : $recBank.hashCode());
        String $recAccount = this.getRecAccount();
        result = result * 59 + ($recAccount == null ? 43 : $recAccount.hashCode());
        String $sourceNo = this.getSourceNo();
        result = result * 59 + ($sourceNo == null ? 43 : $sourceNo.hashCode());
        BigDecimal $realPayAmt = this.getRealPayAmt();
        result = result * 59 + ($realPayAmt == null ? 43 : ((Object)$realPayAmt).hashCode());
        BigDecimal $realPayCurAmt = this.getRealPayCurAmt();
        result = result * 59 + ($realPayCurAmt == null ? 43 : ((Object)$realPayCurAmt).hashCode());
        BigDecimal $totalAmt = this.getTotalAmt();
        result = result * 59 + ($totalAmt == null ? 43 : ((Object)$totalAmt).hashCode());
        BigDecimal $totalCurAmt = this.getTotalCurAmt();
        result = result * 59 + ($totalCurAmt == null ? 43 : ((Object)$totalCurAmt).hashCode());
        String $expensesType = this.getExpensesType();
        result = result * 59 + ($expensesType == null ? 43 : $expensesType.hashCode());
        String $buName = this.getBuName();
        result = result * 59 + ($buName == null ? 43 : $buName.hashCode());
        String $buCode = this.getBuCode();
        result = result * 59 + ($buCode == null ? 43 : $buCode.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        return result;
    }

    public String toString() {
        return "PayOrderDtl(id=" + this.getId() + ", masId=" + this.getMasId() + ", payType=" + this.getPayType() + ", payBank=" + this.getPayBank() + ", payAccount=" + this.getPayAccount() + ", recBank=" + this.getRecBank() + ", recAccount=" + this.getRecAccount() + ", sourceNo=" + this.getSourceNo() + ", sourceLine=" + this.getSourceLine() + ", realPayAmt=" + this.getRealPayAmt() + ", realPayCurAmt=" + this.getRealPayCurAmt() + ", totalAmt=" + this.getTotalAmt() + ", totalCurAmt=" + this.getTotalCurAmt() + ", expensesType=" + this.getExpensesType() + ", buId=" + this.getBuId() + ", buName=" + this.getBuName() + ", buCode=" + this.getBuCode() + ", remark=" + this.getRemark() + ", sourceId=" + this.getSourceId() + ", sourceLineId=" + this.getSourceLineId() + ")";
    }
}

