/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.arorder;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.arorder.ArOrderConvert;
import com.elitesland.fin.application.convert.arorder.ArOrderDtlConvert;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.entity.arorder.ArOrderDO;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtl;
import com.elitesland.fin.domain.entity.arorder.ArOrderDtlDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.fin.domain.service.arorder.ArOrderDomainService;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.dto.arorder.ArOrderDtlDTO;
import com.elitesland.fin.infr.dto.common.ArVerDTO;
import com.elitesland.fin.infr.factory.arorder.ArOrderFactory;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepo;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.workflow.ProcessInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ArOrderDomainServiceImpl
implements ArOrderDomainService {
    private final ArOrderRepo arOrderRepo;
    private final ArOrderRepoProc arOrderRepoProc;
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderDtlRepo arOrderDtlRepo;
    private final ArOrderFactory arOrderFactory;
    private final SaleInvRepo saleInvRepo;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ArOrder arOrder) {
        if (arOrder.getVerAmt() == null) {
            arOrder.setDef();
        }
        arOrder.check();
        arOrder.checkDtlList();
        arOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        if (arOrder.getCreateMode().equals(UdcEnum.FIN_AR_DOC_CLS_SO.getValueCode())) {
            arOrder.setSoDef();
            arOrder.countBySo();
        }
        ArOrderDO apOrderRes = this.saveOrUpdate(arOrder);
        return apOrderRes.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public ArOrderDO saveOrUpdate(ArOrder arOrder) {
        ArOrderDO apOrderDO;
        if (CharSequenceUtil.isBlank((CharSequence)arOrder.getArOrderNo())) {
            String apOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "YSD", null);
            arOrder.setArOrderNo(apOrderNo);
        }
        if ((apOrderDO = ArOrderConvert.INSTANCE.convert(arOrder)).getId() == null) {
            apOrderDO.setAuditDataVersion(0);
        }
        ArOrderDO apOrderRes = (ArOrderDO)this.arOrderRepo.save(apOrderDO);
        this.arOrderDtlRepoProc.delByMasId(Lists.newArrayList((Object[])new Long[]{apOrderRes.getId()}));
        List<ArOrderDtl> apOrderDtlList = arOrder.getDtlList();
        List<ArOrderDtlDO> apOrderDtlDOS = ArOrderDtlConvert.INSTANCE.convert(apOrderDtlList);
        apOrderDtlDOS.stream().forEach(x -> {
            x.setMasId(apOrderRes.getId());
            if (x.getId() == null) {
                x.setAuditDataVersion(0);
            }
            this.arOrderDtlRepo.save(x);
        });
        return apOrderRes;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long commit(ArOrder arOrder, Boolean auto) {
        arOrder.check();
        arOrder.checkDtlList();
        if (Objects.equals(arOrder.getCreateMode(), UdcEnum.FIN_AR_DOC_CLS_MANU.getValueCode())) {
            arOrder.checkAmt();
            arOrder.checkAmtSum();
        }
        if (arOrder.getVerAmt() == null) {
            arOrder.setDef();
        }
        if (auto.booleanValue()) {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            arOrder.setProposedStatus(UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode());
        } else {
            arOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        ArOrderDO arOrderDO = this.saveOrUpdate(arOrder);
        return arOrderDO.getId();
    }

    @Override
    public ArOrderDTO getArOrderAndDtl(Long id) {
        ArOrderDTO apOrderDTO = this.get(id);
        List<ArOrderDtlDTO> apOrderDtlDOS = this.arOrderDtlRepoProc.listByMisId(id);
        apOrderDTO.setArOrderDtlDTOList(apOrderDtlDOS);
        return apOrderDTO;
    }

    @Override
    public Boolean queryByArTypeId(Long arTypeId) {
        return this.arOrderRepoProc.queryByArTypeId(arTypeId);
    }

    @Override
    public List<ArOrderDTO> getArOrderList(ArOrderParam arOrderParam) {
        List<ArOrderDTO> res = this.arOrderRepoProc.getArOrderList(arOrderParam);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long id, BigDecimal amt) {
        ArVerDTO arVerDTO = this.arOrderRepoProc.queryVerAmtById(id);
        BigDecimal totalAmt = arVerDTO.getTotalAmt();
        if (arVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u6838\u9500\u91d1\u989d\u5927\u4e8e\u5e94\u6536\u5355\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u8f93\u5165");
        }
        arVerDTO.setAmtAndVerState(amt);
        long rows = this.arOrderRepoProc.updateVerAmt(arVerDTO);
        if (rows == 0L) {
            throw new com.elitescloud.cloudt.common.exception.BusinessException("\u5e94\u4ed8\u5355\u66f4\u65b0\u5df2\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long resId) {
        this.arOrderRepoProc.updateWorkInfo(processInfo, resId);
    }

    @Override
    public PagingVO<ArExportEntity> exportDefault(ArOrderPageParam param) {
        return this.arOrderRepoProc.exportDefault(param);
    }

    @Override
    public void restDocState(List<Long> ids) {
        List arOrderDOs = this.arOrderRepo.findAllById(ids);
        this.checkCancelDoc(arOrderDOs);
        arOrderDOs.forEach(arOrderDO -> {
            arOrderDO.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
            arOrderDO.setProposedStatus(null);
            arOrderDO.setProcInstId(null);
            arOrderDO.setProcInstStatus(null);
        });
        this.arOrderRepo.saveAll(arOrderDOs);
    }

    void checkCancelDoc(List<ArOrderDO> arOrderDOs) {
        if (CollectionUtils.isEmpty(arOrderDOs)) {
            throw new BusinessException("\u5355\u636e\u4e0d\u5b58\u5728");
        }
        arOrderDOs.forEach(arOrderDO -> {
            String perfix = "\u5355\u53f7\uff1a" + arOrderDO.getArOrderNo() + "-";
            if (!UdcEnum.DOC_PROPOSED_STATUS_DRAFT.getValueCode().equals(arOrderDO.getProposedStatus()) && !UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode().equals(arOrderDO.getProposedStatus())) {
                throw new BusinessException(perfix + "\u62df\u5b9a\u72b6\u6001\u5fc5\u987b\u4e3a\u8349\u7a3f\u6216\u62df\u5b9a\u5931\u8d25");
            }
            if (BigDecimal.ZERO.compareTo(arOrderDO.getVerAmt()) != 0) {
                throw new BusinessException(perfix + "\u5df2\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e3a0");
            }
            if (!UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(arOrderDO.getOrderState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5ba1\u6838\u901a\u8fc7");
            }
            if (Boolean.TRUE.equals(arOrderDO.getRedState())) {
                throw new BusinessException(perfix + "\u5355\u636e\u5df2\u7ea2\u51b2");
            }
        });
    }

    @Override
    public ArOrderSaveParam redPunchCreate(Long id) {
        ArOrderDO arOrderDO = (ArOrderDO)this.arOrderRepo.findById(id).get();
        arOrderDO.setRedState(Boolean.TRUE);
        this.arOrderRepo.save(arOrderDO);
        ArOrderDO newArOrder = new ArOrderDO();
        BeanUtils.copyProperties((Object)arOrderDO, (Object)newArOrder, (String[])new String[0]);
        newArOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        newArOrder.setProcInstId(null);
        newArOrder.setProcInstStatus(null);
        newArOrder.setRedState(null);
        newArOrder.setRedSourceNo(arOrderDO.getArOrderNo());
        newArOrder.setRedSourceId(arOrderDO.getId());
        newArOrder.setTaxAmt(arOrderDO.getTaxAmt().negate());
        newArOrder.setTotalAmt(arOrderDO.getTotalAmt().negate());
        newArOrder.setExclTaxAmt(arOrderDO.getExclTaxAmt().negate());
        newArOrder.setTotalCurAmt(arOrderDO.getTotalCurAmt().negate());
        newArOrder.setTaxCurAmt(arOrderDO.getTaxCurAmt().negate());
        newArOrder.setExclTaxCurAmt(arOrderDO.getExclTaxCurAmt().negate());
        newArOrder.setId(null);
        newArOrder.setArOrderNo(null);
        newArOrder.setProposedStatus(null);
        newArOrder.setAuditUser(null);
        newArOrder.setApprovedTime(null);
        newArOrder.setAuditUserId(null);
        newArOrder.setRemark(null);
        List<ArOrderDtlDO> dtls = this.arOrderDtlRepo.findAllByMasId(id);
        List<ArOrderDtlDO> newDtls = dtls.stream().map(dtl -> {
            ArOrderDtlDO dtlDO = new ArOrderDtlDO();
            BeanUtils.copyProperties((Object)dtl, (Object)dtlDO, (String[])new String[0]);
            dtlDO.setId(null);
            dtlDO.setTaxAmt(dtl.getTaxAmt().negate());
            dtlDO.setTotalAmt(dtl.getTotalAmt().negate());
            dtlDO.setExclTaxAmt(dtl.getExclTaxAmt().negate());
            dtlDO.setTotalCurAmt(dtl.getTaxCurAmt().negate());
            dtlDO.setTaxCurAmt(dtl.getTotalCurAmt().negate());
            dtlDO.setExclTaxCurAmt(dtl.getExclTaxCurAmt().negate());
            dtlDO.setQty(dtlDO.getQty().negate());
            dtlDO.setExclTaxPrice(dtl.getExclTaxPrice());
            return dtlDO;
        }).collect(Collectors.toList());
        ArOrderSaveParam saveParam = ArOrderConvert.INSTANCE.convertParam(newArOrder);
        saveParam.setArOrderDtlParamList(ArOrderDtlConvert.INSTANCE.convertList(newDtls));
        return saveParam;
    }

    @Override
    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> res = this.arOrderFactory.page(arOrderPageParam);
        return res;
    }

    @Override
    public PagingVO<ArOrderDTO> writeoffPage(ArOrderPageParam arOrderPageParam) {
        PagingVO<ArOrderDTO> res = this.arOrderFactory.writeoffPage(arOrderPageParam);
        return res;
    }

    @Override
    public ArOrderDTO get(Long id) {
        ArOrderDTO arOrderDTO = this.arOrderRepoProc.get(id);
        return arOrderDTO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long audit(List<Long> ids, String content, SysUserDTO user) {
        Long res = this.arOrderRepoProc.audit(ids, content, user);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        List<ArOrderDTO> arOrderDTOS = this.arOrderRepoProc.queryByIds(ids);
        HashMap createSourceMap = new HashMap();
        arOrderDTOS.stream().forEach(x -> {
            if (!x.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new com.elitescloud.cloudt.common.exception.BusinessException("\u975e\u8349\u7a3f\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
            }
            if (Objects.nonNull(x.getSourceNo()) && Objects.isNull(x.getRedSourceNo())) {
                List sorceNos = createSourceMap.getOrDefault(x.getCreateMode(), new ArrayList());
                sorceNos.add(x.getSourceNo());
                createSourceMap.put(x.getCreateMode(), sorceNos);
            }
            if (Objects.nonNull(x.getRedSourceNo())) {
                this.arOrderRepoProc.setRedFlag(x.getRedSourceId(), false);
            }
        });
        for (Map.Entry entry : createSourceMap.entrySet()) {
            switch (Optional.ofNullable(UdcEnum.getByValueCode("FIN", "AR_DOC_CLS", (String)entry.getKey())).orElse(UdcEnum.DEFAUT)) {
                case FIN_AR_DOC_CLS_SINV: {
                    List<SaleInvDO> saleInvDOS = this.saleInvRepo.findByApplyNoIn((List)entry.getValue());
                    saleInvDOS.forEach(saleInvDO -> saleInvDO.setArFlag(Boolean.FALSE));
                    this.saleInvRepo.saveAll(saleInvDOS);
                    break;
                }
            }
        }
        Long res = this.arOrderRepoProc.del(ids);
        this.arOrderDtlRepoProc.delByMasId(ids);
        return res;
    }

    public ArOrderDomainServiceImpl(ArOrderRepo arOrderRepo, ArOrderRepoProc arOrderRepoProc, ArOrderDtlRepoProc arOrderDtlRepoProc, ArOrderDtlRepo arOrderDtlRepo, ArOrderFactory arOrderFactory, SaleInvRepo saleInvRepo, SeqNumProvider sysNumberRuleService) {
        this.arOrderRepo = arOrderRepo;
        this.arOrderRepoProc = arOrderRepoProc;
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
        this.arOrderDtlRepo = arOrderDtlRepo;
        this.arOrderFactory = arOrderFactory;
        this.saleInvRepo = saleInvRepo;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

