/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.invoice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.dto.invoice.InvoiceAwaitDTO;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceAwaitQueryParam;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvStatusParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.invoice.QInvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.QInvoiceAwaitDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class InvoiceAwaitRepoProc {
    private static final QInvoiceAwaitDO qdo = QInvoiceAwaitDO.invoiceAwaitDO;
    private static final QInvoiceAwaitDDO D_QDO = QInvoiceAwaitDDO.invoiceAwaitDDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final QBean<InvoiceAwaitRespVO> detailList;

    public PagingVO<InvoiceAwaitDTO> queryInvoiceAwait(InvoiceAwaitQueryParam param) {
        List<Long> ids = this.getIds(param);
        if (CollectionUtil.isEmpty(ids)) {
            return PagingVO.builder().total(0L).records(new ArrayList()).build();
        }
        JPAQuery query = (JPAQuery)this.select(InvoiceAwaitDTO.class).where((Predicate)InvoiceAwaitRepoProc.qdo.id.in(ids));
        param.setPaging(query);
        param.fillOrders(query, qdo);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private List<Long> getIds(InvoiceAwaitQueryParam param) {
        List<Predicate> where = this.where(param);
        if (StrUtil.isNotBlank((CharSequence)param.getCustName())) {
            String likeStr = "%" + param.getCustName() + "%";
            where.add((Predicate)InvoiceAwaitRepoProc.D_QDO.custName.like(likeStr));
        }
        List<Long> ids = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(InvoiceAwaitRepoProc.qdo.id).from((EntityPath)qdo)).leftJoin((EntityPath)D_QDO)).on((Predicate)InvoiceAwaitRepoProc.D_QDO.masId.eq(InvoiceAwaitRepoProc.qdo.id))).where(ExpressionUtils.allOf(where))).fetch();
        ids = ids.stream().distinct().collect(Collectors.toList());
        return ids;
    }

    private List<Predicate> where(InvoiceAwaitQueryParam param) {
        String likeStr;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StrUtil.isNotBlank((CharSequence)param.getInvoiceAwaitStatus())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.invoiceAwaitStatus.eq((Object)param.getInvoiceAwaitStatus()));
        }
        if (CollectionUtils.isNotEmpty(param.getInvoiceAwaitStatusList())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.invoiceAwaitStatus.in(param.getInvoiceAwaitStatusList()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getDocNo())) {
            likeStr = "%" + param.getDocNo() + "%";
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.docNo.like(likeStr));
        }
        if (CollectionUtils.isNotEmpty(param.getDocNoList())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.docNo.in(param.getDocNoList()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getOptDocNo())) {
            likeStr = "%" + param.getOptDocNo() + "%";
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.optDocNo.like(likeStr));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getOuCode())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.ouCode.eq((Object)param.getOuCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getMainCustCode())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.mainCustCode.eq((Object)param.getMainCustCode()));
        }
        if (CollectionUtils.isNotEmpty(param.getMainCustCodeList())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.mainCustCode.in(param.getMainCustCodeList()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getMainCustName())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.mainCustName.like("%" + param.getMainCustName() + "%"));
        }
        if (CollectionUtils.isNotEmpty(param.getMainCustNameList())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.mainCustName.in(param.getMainCustNameList()));
        }
        if (StrUtil.isNotBlank((CharSequence)param.getCustCode())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.custCode.eq((Object)param.getCustCode()));
        }
        if (CollectionUtils.isNotEmpty(param.getCustCodeList())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.qdo.custCode.in(param.getCustCodeList()));
        }
        if (CollectionUtils.isNotEmpty(param.getCustNameList())) {
            predicates.add((Predicate)InvoiceAwaitRepoProc.D_QDO.custName.in(param.getCustNameList()));
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{InvoiceAwaitRepoProc.qdo.id, InvoiceAwaitRepoProc.qdo.docNo, InvoiceAwaitRepoProc.qdo.ouId, InvoiceAwaitRepoProc.qdo.ouCode, InvoiceAwaitRepoProc.qdo.ouName, InvoiceAwaitRepoProc.qdo.custId, InvoiceAwaitRepoProc.qdo.custName, InvoiceAwaitRepoProc.qdo.custCode, InvoiceAwaitRepoProc.qdo.amt, InvoiceAwaitRepoProc.qdo.invoiceAwaitStatus, InvoiceAwaitRepoProc.qdo.optDocCls, InvoiceAwaitRepoProc.qdo.optDocType, InvoiceAwaitRepoProc.qdo.optDocStatus, InvoiceAwaitRepoProc.qdo.optDocId, InvoiceAwaitRepoProc.qdo.optDocNo, InvoiceAwaitRepoProc.qdo.invoiceFileCode, InvoiceAwaitRepoProc.qdo.invoiceApplyNo, InvoiceAwaitRepoProc.qdo.remark, InvoiceAwaitRepoProc.qdo.invoiceType, InvoiceAwaitRepoProc.qdo.mainCustCode, InvoiceAwaitRepoProc.qdo.mainCustId, InvoiceAwaitRepoProc.qdo.mainCustName, InvoiceAwaitRepoProc.qdo.confirmTime, InvoiceAwaitRepoProc.qdo.pkGroup, InvoiceAwaitRepoProc.qdo.settlementType, InvoiceAwaitRepoProc.qdo.openInvType, InvoiceAwaitRepoProc.qdo.currRate, InvoiceAwaitRepoProc.qdo.currCode})).from((EntityPath)qdo);
    }

    @SysCodeProc
    public List<InvoiceAwaitRespVO> findByIds(List<Long> ids) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.detailList).from((EntityPath)qdo)).leftJoin((EntityPath)D_QDO)).on((Predicate)InvoiceAwaitRepoProc.qdo.id.eq(InvoiceAwaitRepoProc.D_QDO.masId))).where((Predicate)InvoiceAwaitRepoProc.qdo.id.in(ids));
        return jpaQuery.fetch();
    }

    private <T> JPAQuery<T> selectDtl(Class<T> cls) {
        return this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{InvoiceAwaitRepoProc.qdo.id.as("masId"), InvoiceAwaitRepoProc.qdo.docNo, InvoiceAwaitRepoProc.qdo.ouId, InvoiceAwaitRepoProc.qdo.ouCode, InvoiceAwaitRepoProc.qdo.ouName, InvoiceAwaitRepoProc.qdo.custId, InvoiceAwaitRepoProc.qdo.custName, InvoiceAwaitRepoProc.qdo.custCode, InvoiceAwaitRepoProc.qdo.amt.as("totalAmt"), InvoiceAwaitRepoProc.qdo.invoiceAwaitStatus, InvoiceAwaitRepoProc.qdo.optDocType, InvoiceAwaitRepoProc.qdo.optDocNo, InvoiceAwaitRepoProc.qdo.optDocCls, InvoiceAwaitRepoProc.qdo.optDocId, InvoiceAwaitRepoProc.qdo.optDocStatus, InvoiceAwaitRepoProc.qdo.invoiceFileCode, InvoiceAwaitRepoProc.qdo.invoiceApplyNo, InvoiceAwaitRepoProc.qdo.remark, InvoiceAwaitRepoProc.qdo.invoiceType, InvoiceAwaitRepoProc.qdo.mainCustCode, InvoiceAwaitRepoProc.qdo.mainCustId, InvoiceAwaitRepoProc.qdo.mainCustName, InvoiceAwaitRepoProc.qdo.settlementType, InvoiceAwaitRepoProc.qdo.pkGroup, InvoiceAwaitRepoProc.qdo.openInvType, InvoiceAwaitRepoProc.qdo.currRate, InvoiceAwaitRepoProc.D_QDO.id, InvoiceAwaitRepoProc.D_QDO.lineNo, InvoiceAwaitRepoProc.D_QDO.itemCode, InvoiceAwaitRepoProc.D_QDO.itemName, InvoiceAwaitRepoProc.D_QDO.itemId, InvoiceAwaitRepoProc.D_QDO.taxType, InvoiceAwaitRepoProc.D_QDO.serviceName, InvoiceAwaitRepoProc.D_QDO.itemSpec, InvoiceAwaitRepoProc.D_QDO.uom, InvoiceAwaitRepoProc.D_QDO.qty, InvoiceAwaitRepoProc.D_QDO.originAmt, InvoiceAwaitRepoProc.D_QDO.amt, InvoiceAwaitRepoProc.D_QDO.taxRate, InvoiceAwaitRepoProc.D_QDO.tax, InvoiceAwaitRepoProc.D_QDO.netAmt, InvoiceAwaitRepoProc.D_QDO.agentName, InvoiceAwaitRepoProc.D_QDO.recvContactName, InvoiceAwaitRepoProc.D_QDO.recvContactTel, InvoiceAwaitRepoProc.D_QDO.recvDetailaddr, InvoiceAwaitRepoProc.D_QDO.soSource, InvoiceAwaitRepoProc.D_QDO.giftsFlag, InvoiceAwaitRepoProc.D_QDO.flDeductionAmt, InvoiceAwaitRepoProc.D_QDO.invDiscount, InvoiceAwaitRepoProc.D_QDO.invDiscountAmt, InvoiceAwaitRepoProc.D_QDO.discountAmt, InvoiceAwaitRepoProc.D_QDO.invAmt, InvoiceAwaitRepoProc.D_QDO.invTaxAmt, InvoiceAwaitRepoProc.D_QDO.invNetAmt, InvoiceAwaitRepoProc.D_QDO.custCode.as("dtlCustCode"), InvoiceAwaitRepoProc.D_QDO.custName.as("dtlCustName"), InvoiceAwaitRepoProc.D_QDO.custId.as("dtlCustId"), InvoiceAwaitRepoProc.D_QDO.docNo.as("relateDocNo"), InvoiceAwaitRepoProc.D_QDO.relateDocDid}));
    }

    private Predicate where(InvoiceApplyParam param) {
        return BaseRepoProc.PredicateBuilder.builder().andIn(CollectionUtil.isNotEmpty(param.getIds()), InvoiceAwaitRepoProc.qdo.id, param.getIds()).build();
    }

    public void updateApplyNoByIds(Set<Long> sourceDocId, String applyNo, String invoiceStatus) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qdo).set((Path)InvoiceAwaitRepoProc.qdo.invoiceApplyNo, (Object)applyNo).set((Path)InvoiceAwaitRepoProc.qdo.invoiceAwaitStatus, (Object)invoiceStatus).where(new Predicate[]{InvoiceAwaitRepoProc.qdo.id.in(sourceDocId)});
        jpaUpdateClause.execute();
    }

    public List<InvoiceAwaitDTO> findByApplyNo(String applyNo) {
        JPAQuery query = (JPAQuery)this.select(InvoiceAwaitDTO.class).where((Predicate)InvoiceAwaitRepoProc.qdo.invoiceApplyNo.eq((Object)applyNo));
        return query.fetch();
    }

    public void updateInvState(SaleInvStatusParam param) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qdo).set((Path)InvoiceAwaitRepoProc.qdo.invoiceAwaitStatus, (Object)param.getInvState());
        if (StrUtil.equals((CharSequence)param.getInvState(), (CharSequence)UdcEnum.INVOICE_AWAIT_STATUS_RED_SUCCESS.getValueCode())) {
            jpaUpdateClause.setNull((Path)InvoiceAwaitRepoProc.qdo.invoiceApplyNo).setNull((Path)InvoiceAwaitRepoProc.qdo.invoiceFileCode);
        }
        jpaUpdateClause.where(new Predicate[]{InvoiceAwaitRepoProc.qdo.invoiceApplyNo.eq((Object)param.getApplyNo())});
        jpaUpdateClause.execute();
    }

    public void updateDeleteFlagByOptDocNoBatch(Integer deleteFlag, List<String> optDocNos) {
        this.jpaQueryFactory.update((EntityPath)qdo).set(InvoiceAwaitRepoProc.qdo.deleteFlag, (Object)deleteFlag).where(new Predicate[]{InvoiceAwaitRepoProc.qdo.optDocNo.in(optDocNos)}).execute();
    }

    public void updateDeleteFlagByOptDocIdBatch(Integer deleteFlag, List<Long> optDocIds) {
        this.jpaQueryFactory.update((EntityPath)qdo).set(InvoiceAwaitRepoProc.qdo.deleteFlag, (Object)deleteFlag).where(new Predicate[]{InvoiceAwaitRepoProc.qdo.optDocId.in(optDocIds)}).execute();
    }

    public void updateDeleteFlagByIdBatch(Integer deleteFlag, List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)qdo).set(InvoiceAwaitRepoProc.qdo.deleteFlag, (Object)deleteFlag).where(new Predicate[]{InvoiceAwaitRepoProc.qdo.id.in(ids)}).execute();
    }

    public List<Long> selectInvoiceAwaitIdByOptDoc(List<String> optDocNos, List<Long> optDocIds) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtil.isNotEmpty(optDocNos)) {
            predicates.add(InvoiceAwaitRepoProc.qdo.optDocNo.in(optDocNos));
        }
        if (CollectionUtil.isNotEmpty(optDocIds)) {
            predicates.add(InvoiceAwaitRepoProc.qdo.optDocId.in(optDocIds));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(InvoiceAwaitRepoProc.qdo.id).from((EntityPath)qdo)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public InvoiceAwaitRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.detailList = Projections.bean(InvoiceAwaitRespVO.class, (Expression[])new Expression[]{InvoiceAwaitRepoProc.qdo.id.as("masId"), InvoiceAwaitRepoProc.qdo.docNo, InvoiceAwaitRepoProc.qdo.ouId, InvoiceAwaitRepoProc.qdo.ouCode, InvoiceAwaitRepoProc.qdo.ouName, InvoiceAwaitRepoProc.qdo.custId, InvoiceAwaitRepoProc.qdo.custName, InvoiceAwaitRepoProc.qdo.custCode, InvoiceAwaitRepoProc.qdo.amt.as("totalAmt"), InvoiceAwaitRepoProc.qdo.invoiceAwaitStatus, InvoiceAwaitRepoProc.qdo.optDocType, InvoiceAwaitRepoProc.qdo.optDocNo, InvoiceAwaitRepoProc.qdo.optDocCls, InvoiceAwaitRepoProc.qdo.optDocId, InvoiceAwaitRepoProc.qdo.optDocStatus, InvoiceAwaitRepoProc.qdo.invoiceFileCode, InvoiceAwaitRepoProc.qdo.invoiceApplyNo, InvoiceAwaitRepoProc.qdo.remark, InvoiceAwaitRepoProc.qdo.invoiceType, InvoiceAwaitRepoProc.qdo.mainCustCode, InvoiceAwaitRepoProc.qdo.mainCustId, InvoiceAwaitRepoProc.qdo.mainCustName, InvoiceAwaitRepoProc.qdo.settlementType, InvoiceAwaitRepoProc.qdo.pkGroup, InvoiceAwaitRepoProc.qdo.openInvType, InvoiceAwaitRepoProc.qdo.currRate, InvoiceAwaitRepoProc.D_QDO.id, InvoiceAwaitRepoProc.D_QDO.lineNo, InvoiceAwaitRepoProc.D_QDO.itemCode, InvoiceAwaitRepoProc.D_QDO.itemName, InvoiceAwaitRepoProc.D_QDO.itemId, InvoiceAwaitRepoProc.D_QDO.taxType, InvoiceAwaitRepoProc.D_QDO.serviceName, InvoiceAwaitRepoProc.D_QDO.itemSpec, InvoiceAwaitRepoProc.D_QDO.uom, InvoiceAwaitRepoProc.D_QDO.qty, InvoiceAwaitRepoProc.D_QDO.originAmt, InvoiceAwaitRepoProc.D_QDO.amt, InvoiceAwaitRepoProc.D_QDO.taxRate, InvoiceAwaitRepoProc.D_QDO.tax, InvoiceAwaitRepoProc.D_QDO.netAmt, InvoiceAwaitRepoProc.D_QDO.agentName, InvoiceAwaitRepoProc.D_QDO.recvContactName, InvoiceAwaitRepoProc.D_QDO.recvContactTel, InvoiceAwaitRepoProc.D_QDO.recvDetailaddr, InvoiceAwaitRepoProc.D_QDO.soSource, InvoiceAwaitRepoProc.D_QDO.giftsFlag, InvoiceAwaitRepoProc.D_QDO.flDeductionAmt, InvoiceAwaitRepoProc.D_QDO.invDiscount, InvoiceAwaitRepoProc.D_QDO.invDiscountAmt, InvoiceAwaitRepoProc.D_QDO.discountAmt, InvoiceAwaitRepoProc.D_QDO.invAmt, InvoiceAwaitRepoProc.D_QDO.invTaxAmt, InvoiceAwaitRepoProc.D_QDO.invNetAmt, InvoiceAwaitRepoProc.D_QDO.custCode.as("dtlCustCode"), InvoiceAwaitRepoProc.D_QDO.custName.as("dtlCustName"), InvoiceAwaitRepoProc.D_QDO.custId.as("dtlCustId"), InvoiceAwaitRepoProc.D_QDO.docNo.as("relateDocNo"), InvoiceAwaitRepoProc.D_QDO.relateDocDid});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

