/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.invoice;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.invoice.PaymentChargesParamVO;
import com.elitesland.fin.application.facade.vo.invoice.PaymentChargesRespVO;
import com.elitesland.fin.application.facade.vo.invoice.PaymentChargesSaveVO;
import com.elitesland.fin.entity.invoice.QPaymentChargesDO;
import com.elitesland.fin.utils.SqlUtil;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class PaymentChargesRepoProc {
    private static final QPaymentChargesDO qdo = QPaymentChargesDO.paymentChargesDO;
    private final JPAQueryFactory jpaQueryFactory;

    public PagingVO<PaymentChargesRespVO> queryPaging(PaymentChargesParamVO query) {
        JPAQuery<PaymentChargesRespVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<PaymentChargesRespVO> getList(PaymentChargesParamVO query) {
        JPAQuery<PaymentChargesRespVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    private JPAQuery<PaymentChargesRespVO> getJpaQueryWhere(PaymentChargesParamVO query) {
        JPAQuery<PaymentChargesRespVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getStoreCode())) {
            jpaQuery.where((Predicate)PaymentChargesRepoProc.qdo.storeCode.eq((Object)query.getStoreCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFeeRuleCode())) {
            jpaQuery.where((Predicate)PaymentChargesRepoProc.qdo.feeRuleCode.eq((Object)query.getFeeRuleCode()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, PaymentChargesRepoProc.qdo._super, query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    private JPAQuery<PaymentChargesRespVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PaymentChargesRespVO.class, (Expression[])new Expression[]{PaymentChargesRepoProc.qdo.id, PaymentChargesRepoProc.qdo.franchiseeId, PaymentChargesRepoProc.qdo.storeCode, PaymentChargesRepoProc.qdo.storeName, PaymentChargesRepoProc.qdo.feeRuleCode, PaymentChargesRepoProc.qdo.feeRuleName, PaymentChargesRepoProc.qdo.totalChargesAmt, PaymentChargesRepoProc.qdo.chargesPercent, PaymentChargesRepoProc.qdo.creator, PaymentChargesRepoProc.qdo.createUserId, PaymentChargesRepoProc.qdo.modifyUserId, PaymentChargesRepoProc.qdo.createTime, PaymentChargesRepoProc.qdo.modifyTime, PaymentChargesRepoProc.qdo.deleteFlag})).from((EntityPath)qdo)).where((Predicate)PaymentChargesRepoProc.qdo.deleteFlag.eq((Object)0));
        return jpaQuery;
    }

    public void updateChargesPercent(PaymentChargesSaveVO saveVO) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qdo);
        if (!ObjectUtils.isEmpty((Object)saveVO.getChargesPercent())) {
            jpaUpdateClause.set(PaymentChargesRepoProc.qdo.chargesPercent, (Object)saveVO.getChargesPercent());
        }
        jpaUpdateClause.where(new Predicate[]{PaymentChargesRepoProc.qdo.id.eq((Object)saveVO.getId())});
        jpaUpdateClause.execute();
    }

    public PaymentChargesRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

