/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.service.excel.entity.PayOrderExportEntity;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DefaultPayOrderExportServiceImpl
implements DataExport<PayOrderExportEntity, PayOrderPageParam> {
    private final PayOrderRepoProc payOrderRepoProc;
    private final UdcProvider udcProvider;
    private static final Map<String, String> emptyMap = Map.of();

    public String getTmplCode() {
        return "FIN_PAY_EXPORT_DEFAULT";
    }

    public PagingVO<PayOrderExportEntity> executeExport(PayOrderPageParam queryParam) {
        PagingVO<PayOrderExportEntity> page = this.payOrderRepoProc.defaultExport(queryParam);
        if (page == null || page.isEmpty()) {
            return new PagingVO(0L, List.of());
        }
        List records = page.getRecords();
        Map<String, String> recDocClsMap = this.getUdcMap("yst-fin", "AP_DOC_CLS");
        Map<String, String> orderStateMap = this.getUdcMap("yst-supp", "APPLY_STATUS");
        Map<String, String> verifyStatusMap = this.getUdcMap("yst-fin", "VERIFY_STATUS");
        Map<String, String> proposedStatusMap = this.getUdcMap("yst-fin", "DOC_PROPOSED_STATUS");
        ExcelConverterManager.refresh();
        for (PayOrderExportEntity record : records) {
            record.setCreateModeName(recDocClsMap.get(record.getCreateMode()));
            record.setOrderStateName(orderStateMap.get(record.getOrderState()));
            record.setVerStateName(verifyStatusMap.get(record.getVerState()));
            record.setProposedStatusName(proposedStatusMap.get(record.getProposedStatus()));
            ExcelConvertUtils.convertSelfLoosely(record);
        }
        return page;
    }

    public Integer pageSize() {
        return 1000;
    }

    private Map<String, String> getUdcMap(String appCode, String udcCode) {
        if (StringUtils.isBlank((CharSequence)appCode) || StringUtils.isBlank((CharSequence)udcCode)) {
            return emptyMap;
        }
        Map valueMapByUdcCode = this.udcProvider.getValueMapByUdcCode(appCode, udcCode);
        return (Map)ObjectUtils.defaultIfNull((Object)valueMapByUdcCode, emptyMap);
    }

    public DefaultPayOrderExportServiceImpl(PayOrderRepoProc payOrderRepoProc, UdcProvider udcProvider) {
        this.payOrderRepoProc = payOrderRepoProc;
        this.udcProvider = udcProvider;
    }
}

