/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.application.service.excel.entity.RecOrderEntity;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.infr.repo.recorder.RecOrderRepoProc;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import com.elitesland.fin.utils.excel.convert.ExcelConverterManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

@Service
public class DefaultRecOrderExportServiceImpl
implements DataExport<RecOrderEntity, RecOrderPageParam> {
    private final RecOrderRepoProc recOrderRepoProc;
    private final UdcProvider udcProvider;
    private static final Map<String, String> emptyMap = Map.of();

    public String getTmplCode() {
        return "FIN_REC_EXPORT_DEFAULT";
    }

    public PagingVO<RecOrderEntity> executeExport(RecOrderPageParam queryParam) {
        if (queryParam.getReDateStart() == null || queryParam.getReDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u6536\u6b3e\u65e5\u671f!");
        }
        PagingVO<RecOrderEntity> page = this.recOrderRepoProc.defaultExport(queryParam);
        if (page == null || page.isEmpty()) {
            return new PagingVO(0L, List.of());
        }
        List records = page.getRecords();
        Map recDocClsMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "REC_DOC_CLS");
        recDocClsMap = (Map)ObjectUtils.defaultIfNull((Object)recDocClsMap, emptyMap);
        Map orderStateMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "APPLY_STATUS");
        orderStateMap = (Map)ObjectUtils.defaultIfNull((Object)orderStateMap, emptyMap);
        Map verifyStatusMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "VERIFY_STATUS");
        verifyStatusMap = (Map)ObjectUtils.defaultIfNull((Object)verifyStatusMap, emptyMap);
        Map proposedStatusMap = this.udcProvider.getValueMapByUdcCode("yst-fin", "DOC_PROPOSED_STATUS");
        proposedStatusMap = (Map)ObjectUtils.defaultIfNull((Object)proposedStatusMap, emptyMap);
        ExcelConverterManager.refresh();
        for (RecOrderEntity record : records) {
            record.setCreateModeName((String)recDocClsMap.get(record.getCreateMode()));
            record.setOrderStateName((String)orderStateMap.get(record.getOrderState()));
            record.setVerStateName((String)verifyStatusMap.get(record.getVerState()));
            record.setProposedStatusName((String)proposedStatusMap.get(record.getProposedStatus()));
            ExcelConvertUtils.convertSelfLoosely(record);
        }
        return page;
    }

    public Integer pageSize() {
        return 1000;
    }

    public DefaultRecOrderExportServiceImpl(RecOrderRepoProc recOrderRepoProc, UdcProvider udcProvider) {
        this.recOrderRepoProc = recOrderRepoProc;
        this.udcProvider = udcProvider;
    }
}

