/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.entity.inputinv;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.inputinv.InputInvDtl;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

public class InputInv {
    private Long id;
    private String sourceNo;
    private String ouCode;
    private Long ouId;
    private String ouName;
    private BigDecimal taxRate;
    private String invRegNo;
    private String currCode;
    private String currName;
    private String localCurrCode;
    private String localCurrName;
    private BigDecimal totalAmt;
    private BigDecimal totalCurAmt;
    private String openBank;
    private String bankAccount;
    private String suppAddress;
    private String suppRemark;
    private Long suppId;
    private String suppName;
    private String suppCode;
    private String suppTel;
    private String invUser;
    private String recUser;
    private String revUser;
    private Long auditUserId;
    private String auditUser;
    private LocalDateTime auditDate;
    private String orderState;
    private BigDecimal exchangeRate;
    private String auditRejection;
    private String createMode;
    private String taxNumber;
    private String creator;
    private LocalDateTime createTime;
    private String remark;
    private String procInstId;
    private ProcInstStatus procInstStatus;
    private LocalDateTime submitTime;
    private LocalDateTime approvedTime;
    private List<InputInvDtl> dtlList;

    public void checkInvNo() {
        List invNo = this.dtlList.stream().map(InputInvDtl::getInvNo).distinct().collect(Collectors.toList());
        if (invNo.size() < this.dtlList.size()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u7968\u53f7\u7801\u5b58\u5728\u91cd\u590d,\u8bf7\u68c0\u67e5!");
        }
    }

    public void count() {
        for (InputInvDtl inputInvDtl : this.dtlList) {
            BigDecimal totalAmount = inputInvDtl.getPrice().multiply(inputInvDtl.getQty()).setScale(2, RoundingMode.HALF_UP);
            if (totalAmount.compareTo(inputInvDtl.getTotalAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u542b\u7a0e\u91d1\u989d\u4e0d\u76f8\u7b49!");
            }
            BigDecimal totalCurAmount = totalAmount.multiply(this.exchangeRate).setScale(2, RoundingMode.HALF_UP);
            if (totalCurAmount.compareTo(inputInvDtl.getTotalCurAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u542b\u7a0e\u91d1\u989d\u672c\u4f4d\u5e01\u4e0d\u76f8\u7b49!");
            }
            BigDecimal taxAmt = totalAmount.multiply(inputInvDtl.getTaxRate()).divide(new BigDecimal(1).add(inputInvDtl.getTaxRate()), 2, RoundingMode.HALF_UP);
            if (taxAmt.compareTo(inputInvDtl.getTaxAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u7a0e\u989d\u4e0d\u76f8\u7b49!");
            }
            BigDecimal taxCurAmt = taxAmt.multiply(this.exchangeRate).setScale(2, RoundingMode.HALF_UP);
            if (taxCurAmt.compareTo(inputInvDtl.getTaxCurAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u7a0e\u989d\u672c\u4f4d\u5e01\u4e0d\u76f8\u7b49!");
            }
            BigDecimal exclTaxAmt = totalAmount.subtract(taxAmt).setScale(2, RoundingMode.HALF_UP);
            if (exclTaxAmt.compareTo(inputInvDtl.getExclTaxAmt()) != 0) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u76f8\u7b49!");
            }
            BigDecimal excelCurAmt = totalCurAmount.subtract(taxCurAmt).setScale(2, RoundingMode.HALF_UP);
            if (excelCurAmt.compareTo(inputInvDtl.getExclTaxCurAmt()) == 0) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u884c\u4e0d\u542b\u7a0e\u91d1\u989d\u672c\u4f4d\u5e01\u4e0d\u76f8\u7b49!");
        }
        BigDecimal totalAmount = this.dtlList.stream().map(InputInvDtl::getTotalAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        if (this.totalAmt.compareTo(totalAmount) != 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u660e\u7ec6\u603b\u91d1\u989d\u4e0e\u5355\u636e\u603b\u91d1\u989d\u4e0d\u76f8\u7b49!");
        }
    }

    public void checkOrderState() {
        if (!this.orderState.equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u7f16\u8f91\u5355\u636e\u4e3a\u8349\u7a3f\u72b6\u6001\u7684\u5355\u636e!");
        }
    }

    public void checkNotNull() {
        if (this.createMode.equals(UdcEnum.FIN_PINV_CREATE_MODE_GR.getValueCode())) {
            Assert.notNull((Object)this.totalAmt, (String)"\u5f00\u7968\u603b\u91d1\u989d", (Object[])new Object[0]);
            Assert.notNull((Object)this.localCurrCode, (String)"\u672c\u4f4d\u5e01\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)this.localCurrName, (String)"\u672c\u4f4d\u5e01\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.taxRate, (String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.taxNumber, (String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (Object[])new Object[0]);
            Assert.notNull((Object)this.suppAddress, (String)"\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.suppTel, (String)"\u4f9b\u5e94\u5546\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.openBank, (String)"\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)this.bankAccount, (String)"\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Assert.notNull((Object)this.ouId, (String)"\u516c\u53f8ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)this.exchangeRate, (String)"\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)this.ouName, (String)"\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)this.ouCode, (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)this.currCode, (String)"\u5e01\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)this.currName, (String)"\u5e01\u79cd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)this.suppId, (String)"\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)this.suppCode, (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)this.suppName, (String)"\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.dtlList.forEach(x -> x.checkNotNull(this.createMode));
    }

    public Long getId() {
        return this.id;
    }

    public String getSourceNo() {
        return this.sourceNo;
    }

    public String getOuCode() {
        return this.ouCode;
    }

    public Long getOuId() {
        return this.ouId;
    }

    public String getOuName() {
        return this.ouName;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public String getInvRegNo() {
        return this.invRegNo;
    }

    public String getCurrCode() {
        return this.currCode;
    }

    public String getCurrName() {
        return this.currName;
    }

    public String getLocalCurrCode() {
        return this.localCurrCode;
    }

    public String getLocalCurrName() {
        return this.localCurrName;
    }

    public BigDecimal getTotalAmt() {
        return this.totalAmt;
    }

    public BigDecimal getTotalCurAmt() {
        return this.totalCurAmt;
    }

    public String getOpenBank() {
        return this.openBank;
    }

    public String getBankAccount() {
        return this.bankAccount;
    }

    public String getSuppAddress() {
        return this.suppAddress;
    }

    public String getSuppRemark() {
        return this.suppRemark;
    }

    public Long getSuppId() {
        return this.suppId;
    }

    public String getSuppName() {
        return this.suppName;
    }

    public String getSuppCode() {
        return this.suppCode;
    }

    public String getSuppTel() {
        return this.suppTel;
    }

    public String getInvUser() {
        return this.invUser;
    }

    public String getRecUser() {
        return this.recUser;
    }

    public String getRevUser() {
        return this.revUser;
    }

    public Long getAuditUserId() {
        return this.auditUserId;
    }

    public String getAuditUser() {
        return this.auditUser;
    }

    public LocalDateTime getAuditDate() {
        return this.auditDate;
    }

    public String getOrderState() {
        return this.orderState;
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public String getAuditRejection() {
        return this.auditRejection;
    }

    public String getCreateMode() {
        return this.createMode;
    }

    public String getTaxNumber() {
        return this.taxNumber;
    }

    public String getCreator() {
        return this.creator;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getProcInstId() {
        return this.procInstId;
    }

    public ProcInstStatus getProcInstStatus() {
        return this.procInstStatus;
    }

    public LocalDateTime getSubmitTime() {
        return this.submitTime;
    }

    public LocalDateTime getApprovedTime() {
        return this.approvedTime;
    }

    public List<InputInvDtl> getDtlList() {
        return this.dtlList;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public void setOuCode(String ouCode) {
        this.ouCode = ouCode;
    }

    public void setOuId(Long ouId) {
        this.ouId = ouId;
    }

    public void setOuName(String ouName) {
        this.ouName = ouName;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public void setInvRegNo(String invRegNo) {
        this.invRegNo = invRegNo;
    }

    public void setCurrCode(String currCode) {
        this.currCode = currCode;
    }

    public void setCurrName(String currName) {
        this.currName = currName;
    }

    public void setLocalCurrCode(String localCurrCode) {
        this.localCurrCode = localCurrCode;
    }

    public void setLocalCurrName(String localCurrName) {
        this.localCurrName = localCurrName;
    }

    public void setTotalAmt(BigDecimal totalAmt) {
        this.totalAmt = totalAmt;
    }

    public void setTotalCurAmt(BigDecimal totalCurAmt) {
        this.totalCurAmt = totalCurAmt;
    }

    public void setOpenBank(String openBank) {
        this.openBank = openBank;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public void setSuppAddress(String suppAddress) {
        this.suppAddress = suppAddress;
    }

    public void setSuppRemark(String suppRemark) {
        this.suppRemark = suppRemark;
    }

    public void setSuppId(Long suppId) {
        this.suppId = suppId;
    }

    public void setSuppName(String suppName) {
        this.suppName = suppName;
    }

    public void setSuppCode(String suppCode) {
        this.suppCode = suppCode;
    }

    public void setSuppTel(String suppTel) {
        this.suppTel = suppTel;
    }

    public void setInvUser(String invUser) {
        this.invUser = invUser;
    }

    public void setRecUser(String recUser) {
        this.recUser = recUser;
    }

    public void setRevUser(String revUser) {
        this.revUser = revUser;
    }

    public void setAuditUserId(Long auditUserId) {
        this.auditUserId = auditUserId;
    }

    public void setAuditUser(String auditUser) {
        this.auditUser = auditUser;
    }

    public void setAuditDate(LocalDateTime auditDate) {
        this.auditDate = auditDate;
    }

    public void setOrderState(String orderState) {
        this.orderState = orderState;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public void setAuditRejection(String auditRejection) {
        this.auditRejection = auditRejection;
    }

    public void setCreateMode(String createMode) {
        this.createMode = createMode;
    }

    public void setTaxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setProcInstId(String procInstId) {
        this.procInstId = procInstId;
    }

    public void setProcInstStatus(ProcInstStatus procInstStatus) {
        this.procInstStatus = procInstStatus;
    }

    public void setSubmitTime(LocalDateTime submitTime) {
        this.submitTime = submitTime;
    }

    public void setApprovedTime(LocalDateTime approvedTime) {
        this.approvedTime = approvedTime;
    }

    public void setDtlList(List<InputInvDtl> dtlList) {
        this.dtlList = dtlList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputInv)) {
            return false;
        }
        InputInv other = (InputInv)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$ouId = this.getOuId();
        Long other$ouId = other.getOuId();
        if (this$ouId == null ? other$ouId != null : !((Object)this$ouId).equals(other$ouId)) {
            return false;
        }
        Long this$suppId = this.getSuppId();
        Long other$suppId = other.getSuppId();
        if (this$suppId == null ? other$suppId != null : !((Object)this$suppId).equals(other$suppId)) {
            return false;
        }
        Long this$auditUserId = this.getAuditUserId();
        Long other$auditUserId = other.getAuditUserId();
        if (this$auditUserId == null ? other$auditUserId != null : !((Object)this$auditUserId).equals(other$auditUserId)) {
            return false;
        }
        String this$sourceNo = this.getSourceNo();
        String other$sourceNo = other.getSourceNo();
        if (this$sourceNo == null ? other$sourceNo != null : !this$sourceNo.equals(other$sourceNo)) {
            return false;
        }
        String this$ouCode = this.getOuCode();
        String other$ouCode = other.getOuCode();
        if (this$ouCode == null ? other$ouCode != null : !this$ouCode.equals(other$ouCode)) {
            return false;
        }
        String this$ouName = this.getOuName();
        String other$ouName = other.getOuName();
        if (this$ouName == null ? other$ouName != null : !this$ouName.equals(other$ouName)) {
            return false;
        }
        BigDecimal this$taxRate = this.getTaxRate();
        BigDecimal other$taxRate = other.getTaxRate();
        if (this$taxRate == null ? other$taxRate != null : !((Object)this$taxRate).equals(other$taxRate)) {
            return false;
        }
        String this$invRegNo = this.getInvRegNo();
        String other$invRegNo = other.getInvRegNo();
        if (this$invRegNo == null ? other$invRegNo != null : !this$invRegNo.equals(other$invRegNo)) {
            return false;
        }
        String this$currCode = this.getCurrCode();
        String other$currCode = other.getCurrCode();
        if (this$currCode == null ? other$currCode != null : !this$currCode.equals(other$currCode)) {
            return false;
        }
        String this$currName = this.getCurrName();
        String other$currName = other.getCurrName();
        if (this$currName == null ? other$currName != null : !this$currName.equals(other$currName)) {
            return false;
        }
        String this$localCurrCode = this.getLocalCurrCode();
        String other$localCurrCode = other.getLocalCurrCode();
        if (this$localCurrCode == null ? other$localCurrCode != null : !this$localCurrCode.equals(other$localCurrCode)) {
            return false;
        }
        String this$localCurrName = this.getLocalCurrName();
        String other$localCurrName = other.getLocalCurrName();
        if (this$localCurrName == null ? other$localCurrName != null : !this$localCurrName.equals(other$localCurrName)) {
            return false;
        }
        BigDecimal this$totalAmt = this.getTotalAmt();
        BigDecimal other$totalAmt = other.getTotalAmt();
        if (this$totalAmt == null ? other$totalAmt != null : !((Object)this$totalAmt).equals(other$totalAmt)) {
            return false;
        }
        BigDecimal this$totalCurAmt = this.getTotalCurAmt();
        BigDecimal other$totalCurAmt = other.getTotalCurAmt();
        if (this$totalCurAmt == null ? other$totalCurAmt != null : !((Object)this$totalCurAmt).equals(other$totalCurAmt)) {
            return false;
        }
        String this$openBank = this.getOpenBank();
        String other$openBank = other.getOpenBank();
        if (this$openBank == null ? other$openBank != null : !this$openBank.equals(other$openBank)) {
            return false;
        }
        String this$bankAccount = this.getBankAccount();
        String other$bankAccount = other.getBankAccount();
        if (this$bankAccount == null ? other$bankAccount != null : !this$bankAccount.equals(other$bankAccount)) {
            return false;
        }
        String this$suppAddress = this.getSuppAddress();
        String other$suppAddress = other.getSuppAddress();
        if (this$suppAddress == null ? other$suppAddress != null : !this$suppAddress.equals(other$suppAddress)) {
            return false;
        }
        String this$suppRemark = this.getSuppRemark();
        String other$suppRemark = other.getSuppRemark();
        if (this$suppRemark == null ? other$suppRemark != null : !this$suppRemark.equals(other$suppRemark)) {
            return false;
        }
        String this$suppName = this.getSuppName();
        String other$suppName = other.getSuppName();
        if (this$suppName == null ? other$suppName != null : !this$suppName.equals(other$suppName)) {
            return false;
        }
        String this$suppCode = this.getSuppCode();
        String other$suppCode = other.getSuppCode();
        if (this$suppCode == null ? other$suppCode != null : !this$suppCode.equals(other$suppCode)) {
            return false;
        }
        String this$suppTel = this.getSuppTel();
        String other$suppTel = other.getSuppTel();
        if (this$suppTel == null ? other$suppTel != null : !this$suppTel.equals(other$suppTel)) {
            return false;
        }
        String this$invUser = this.getInvUser();
        String other$invUser = other.getInvUser();
        if (this$invUser == null ? other$invUser != null : !this$invUser.equals(other$invUser)) {
            return false;
        }
        String this$recUser = this.getRecUser();
        String other$recUser = other.getRecUser();
        if (this$recUser == null ? other$recUser != null : !this$recUser.equals(other$recUser)) {
            return false;
        }
        String this$revUser = this.getRevUser();
        String other$revUser = other.getRevUser();
        if (this$revUser == null ? other$revUser != null : !this$revUser.equals(other$revUser)) {
            return false;
        }
        String this$auditUser = this.getAuditUser();
        String other$auditUser = other.getAuditUser();
        if (this$auditUser == null ? other$auditUser != null : !this$auditUser.equals(other$auditUser)) {
            return false;
        }
        LocalDateTime this$auditDate = this.getAuditDate();
        LocalDateTime other$auditDate = other.getAuditDate();
        if (this$auditDate == null ? other$auditDate != null : !((Object)this$auditDate).equals(other$auditDate)) {
            return false;
        }
        String this$orderState = this.getOrderState();
        String other$orderState = other.getOrderState();
        if (this$orderState == null ? other$orderState != null : !this$orderState.equals(other$orderState)) {
            return false;
        }
        BigDecimal this$exchangeRate = this.getExchangeRate();
        BigDecimal other$exchangeRate = other.getExchangeRate();
        if (this$exchangeRate == null ? other$exchangeRate != null : !((Object)this$exchangeRate).equals(other$exchangeRate)) {
            return false;
        }
        String this$auditRejection = this.getAuditRejection();
        String other$auditRejection = other.getAuditRejection();
        if (this$auditRejection == null ? other$auditRejection != null : !this$auditRejection.equals(other$auditRejection)) {
            return false;
        }
        String this$createMode = this.getCreateMode();
        String other$createMode = other.getCreateMode();
        if (this$createMode == null ? other$createMode != null : !this$createMode.equals(other$createMode)) {
            return false;
        }
        String this$taxNumber = this.getTaxNumber();
        String other$taxNumber = other.getTaxNumber();
        if (this$taxNumber == null ? other$taxNumber != null : !this$taxNumber.equals(other$taxNumber)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$procInstId = this.getProcInstId();
        String other$procInstId = other.getProcInstId();
        if (this$procInstId == null ? other$procInstId != null : !this$procInstId.equals(other$procInstId)) {
            return false;
        }
        ProcInstStatus this$procInstStatus = this.getProcInstStatus();
        ProcInstStatus other$procInstStatus = other.getProcInstStatus();
        if (this$procInstStatus == null ? other$procInstStatus != null : !this$procInstStatus.equals(other$procInstStatus)) {
            return false;
        }
        LocalDateTime this$submitTime = this.getSubmitTime();
        LocalDateTime other$submitTime = other.getSubmitTime();
        if (this$submitTime == null ? other$submitTime != null : !((Object)this$submitTime).equals(other$submitTime)) {
            return false;
        }
        LocalDateTime this$approvedTime = this.getApprovedTime();
        LocalDateTime other$approvedTime = other.getApprovedTime();
        if (this$approvedTime == null ? other$approvedTime != null : !((Object)this$approvedTime).equals(other$approvedTime)) {
            return false;
        }
        List<InputInvDtl> this$dtlList = this.getDtlList();
        List<InputInvDtl> other$dtlList = other.getDtlList();
        return !(this$dtlList == null ? other$dtlList != null : !((Object)this$dtlList).equals(other$dtlList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputInv;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $ouId = this.getOuId();
        result = result * 59 + ($ouId == null ? 43 : ((Object)$ouId).hashCode());
        Long $suppId = this.getSuppId();
        result = result * 59 + ($suppId == null ? 43 : ((Object)$suppId).hashCode());
        Long $auditUserId = this.getAuditUserId();
        result = result * 59 + ($auditUserId == null ? 43 : ((Object)$auditUserId).hashCode());
        String $sourceNo = this.getSourceNo();
        result = result * 59 + ($sourceNo == null ? 43 : $sourceNo.hashCode());
        String $ouCode = this.getOuCode();
        result = result * 59 + ($ouCode == null ? 43 : $ouCode.hashCode());
        String $ouName = this.getOuName();
        result = result * 59 + ($ouName == null ? 43 : $ouName.hashCode());
        BigDecimal $taxRate = this.getTaxRate();
        result = result * 59 + ($taxRate == null ? 43 : ((Object)$taxRate).hashCode());
        String $invRegNo = this.getInvRegNo();
        result = result * 59 + ($invRegNo == null ? 43 : $invRegNo.hashCode());
        String $currCode = this.getCurrCode();
        result = result * 59 + ($currCode == null ? 43 : $currCode.hashCode());
        String $currName = this.getCurrName();
        result = result * 59 + ($currName == null ? 43 : $currName.hashCode());
        String $localCurrCode = this.getLocalCurrCode();
        result = result * 59 + ($localCurrCode == null ? 43 : $localCurrCode.hashCode());
        String $localCurrName = this.getLocalCurrName();
        result = result * 59 + ($localCurrName == null ? 43 : $localCurrName.hashCode());
        BigDecimal $totalAmt = this.getTotalAmt();
        result = result * 59 + ($totalAmt == null ? 43 : ((Object)$totalAmt).hashCode());
        BigDecimal $totalCurAmt = this.getTotalCurAmt();
        result = result * 59 + ($totalCurAmt == null ? 43 : ((Object)$totalCurAmt).hashCode());
        String $openBank = this.getOpenBank();
        result = result * 59 + ($openBank == null ? 43 : $openBank.hashCode());
        String $bankAccount = this.getBankAccount();
        result = result * 59 + ($bankAccount == null ? 43 : $bankAccount.hashCode());
        String $suppAddress = this.getSuppAddress();
        result = result * 59 + ($suppAddress == null ? 43 : $suppAddress.hashCode());
        String $suppRemark = this.getSuppRemark();
        result = result * 59 + ($suppRemark == null ? 43 : $suppRemark.hashCode());
        String $suppName = this.getSuppName();
        result = result * 59 + ($suppName == null ? 43 : $suppName.hashCode());
        String $suppCode = this.getSuppCode();
        result = result * 59 + ($suppCode == null ? 43 : $suppCode.hashCode());
        String $suppTel = this.getSuppTel();
        result = result * 59 + ($suppTel == null ? 43 : $suppTel.hashCode());
        String $invUser = this.getInvUser();
        result = result * 59 + ($invUser == null ? 43 : $invUser.hashCode());
        String $recUser = this.getRecUser();
        result = result * 59 + ($recUser == null ? 43 : $recUser.hashCode());
        String $revUser = this.getRevUser();
        result = result * 59 + ($revUser == null ? 43 : $revUser.hashCode());
        String $auditUser = this.getAuditUser();
        result = result * 59 + ($auditUser == null ? 43 : $auditUser.hashCode());
        LocalDateTime $auditDate = this.getAuditDate();
        result = result * 59 + ($auditDate == null ? 43 : ((Object)$auditDate).hashCode());
        String $orderState = this.getOrderState();
        result = result * 59 + ($orderState == null ? 43 : $orderState.hashCode());
        BigDecimal $exchangeRate = this.getExchangeRate();
        result = result * 59 + ($exchangeRate == null ? 43 : ((Object)$exchangeRate).hashCode());
        String $auditRejection = this.getAuditRejection();
        result = result * 59 + ($auditRejection == null ? 43 : $auditRejection.hashCode());
        String $createMode = this.getCreateMode();
        result = result * 59 + ($createMode == null ? 43 : $createMode.hashCode());
        String $taxNumber = this.getTaxNumber();
        result = result * 59 + ($taxNumber == null ? 43 : $taxNumber.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $procInstId = this.getProcInstId();
        result = result * 59 + ($procInstId == null ? 43 : $procInstId.hashCode());
        ProcInstStatus $procInstStatus = this.getProcInstStatus();
        result = result * 59 + ($procInstStatus == null ? 43 : $procInstStatus.hashCode());
        LocalDateTime $submitTime = this.getSubmitTime();
        result = result * 59 + ($submitTime == null ? 43 : ((Object)$submitTime).hashCode());
        LocalDateTime $approvedTime = this.getApprovedTime();
        result = result * 59 + ($approvedTime == null ? 43 : ((Object)$approvedTime).hashCode());
        List<InputInvDtl> $dtlList = this.getDtlList();
        result = result * 59 + ($dtlList == null ? 43 : ((Object)$dtlList).hashCode());
        return result;
    }

    public String toString() {
        return "InputInv(id=" + this.getId() + ", sourceNo=" + this.getSourceNo() + ", ouCode=" + this.getOuCode() + ", ouId=" + this.getOuId() + ", ouName=" + this.getOuName() + ", taxRate=" + this.getTaxRate() + ", invRegNo=" + this.getInvRegNo() + ", currCode=" + this.getCurrCode() + ", currName=" + this.getCurrName() + ", localCurrCode=" + this.getLocalCurrCode() + ", localCurrName=" + this.getLocalCurrName() + ", totalAmt=" + this.getTotalAmt() + ", totalCurAmt=" + this.getTotalCurAmt() + ", openBank=" + this.getOpenBank() + ", bankAccount=" + this.getBankAccount() + ", suppAddress=" + this.getSuppAddress() + ", suppRemark=" + this.getSuppRemark() + ", suppId=" + this.getSuppId() + ", suppName=" + this.getSuppName() + ", suppCode=" + this.getSuppCode() + ", suppTel=" + this.getSuppTel() + ", invUser=" + this.getInvUser() + ", recUser=" + this.getRecUser() + ", revUser=" + this.getRevUser() + ", auditUserId=" + this.getAuditUserId() + ", auditUser=" + this.getAuditUser() + ", auditDate=" + this.getAuditDate() + ", orderState=" + this.getOrderState() + ", exchangeRate=" + this.getExchangeRate() + ", auditRejection=" + this.getAuditRejection() + ", createMode=" + this.getCreateMode() + ", taxNumber=" + this.getTaxNumber() + ", creator=" + this.getCreator() + ", createTime=" + this.getCreateTime() + ", remark=" + this.getRemark() + ", procInstId=" + this.getProcInstId() + ", procInstStatus=" + this.getProcInstStatus() + ", submitTime=" + this.getSubmitTime() + ", approvedTime=" + this.getApprovedTime() + ", dtlList=" + this.getDtlList() + ")";
    }
}

