/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.utils.excel.convert;

import cn.hutool.core.collection.ConcurrentHashSet;
import com.elitesland.fin.utils.excel.convert.Converter;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ExcelConverterManager {
    private final Map<Class<? extends Converter>, Converter> converterMap = new ConcurrentHashMap<Class<? extends Converter>, Converter>();
    private static volatile ExcelConverterManager instance;
    private static final Set<Converter> notRequiredRefreshSet;
    private volatile long lastRefreshTime = 0L;
    private static final long refreshIntervalMills = 300000L;

    public static ExcelConverterManager instance() {
        return ExcelConverterManager.instance(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ExcelConverterManager instance(boolean refresh) {
        if (instance == null) {
            Class<ExcelConverterManager> clazz = ExcelConverterManager.class;
            // MONITORENTER : com.elitesland.fin.utils.excel.convert.ExcelConverterManager.class
            if (instance == null) {
                instance = new ExcelConverterManager();
            }
            // MONITOREXIT : clazz
        }
        if (!refresh) return instance;
        ExcelConverterManager.instance.lastRefreshTime = System.currentTimeMillis();
        notRequiredRefreshSet.clear();
        return instance;
    }

    public static void refresh() {
        if (instance == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= ExcelConverterManager.instance.lastRefreshTime + 300000L) {
            ExcelConverterManager.instance.lastRefreshTime = currentTime;
            notRequiredRefreshSet.clear();
        }
    }

    public Converter getConverter(Class<? extends Converter> clz) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (this.converterMap.containsKey(clz)) {
            return this.refreshConverter(this.converterMap.get(clz));
        }
        Converter converter = this.initConverter(clz);
        this.converterMap.put(clz, converter);
        return converter;
    }

    private Converter initConverter(Class<? extends Converter> clz) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Converter converter = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        converter.initBaseValue();
        notRequiredRefreshSet.add(converter);
        return converter;
    }

    private Converter refreshConverter(Converter converter) {
        if (notRequiredRefreshSet.contains(converter)) {
            return converter;
        }
        notRequiredRefreshSet.add(converter);
        converter.refreshBaseValue();
        return converter;
    }

    static {
        notRequiredRefreshSet = new ConcurrentHashSet();
    }
}

