/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.payorder;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.payorder.PayOrderConvert;
import com.elitesland.fin.application.convert.payorder.PayOrderDtlConvert;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.payorder.PayOrder;
import com.elitesland.fin.domain.entity.payorder.PayOrderDO;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtl;
import com.elitesland.fin.domain.entity.payorder.PayOrderDtlDO;
import com.elitesland.fin.domain.param.payorder.PayOrderPageParam;
import com.elitesland.fin.domain.param.payorder.PayOrderParam;
import com.elitesland.fin.domain.service.payorder.PayOrderDomainService;
import com.elitesland.fin.infr.dto.common.ApVerDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDtlDTO;
import com.elitesland.fin.infr.factory.payorder.PayOrderFactory;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepo;
import com.elitesland.fin.infr.repo.payorder.PayOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepo;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.fin.utils.BigDecimalUtils;
import com.elitesland.workflow.ProcessInfo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PayOrderDomainServiceImpl
implements PayOrderDomainService {
    private final PayOrderRepo payOrderRepo;
    private final PayOrderRepoProc payOrderRepoProc;
    private final PayOrderFactory payOrderFactory;
    private final PayOrderDtlRepo payOrderDtlRepo;
    private final PayOrderDtlRepoProc payOrderDtlRepoProc;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    public PagingVO<PayOrderDTO> page(PayOrderPageParam param) {
        if (param.getBuDateStart() == null || param.getBuDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u4e1a\u52a1\u65e5\u671f!");
        }
        return this.payOrderFactory.payOrderPage(param);
    }

    @Override
    public PagingVO<PayOrderDTO> writeoffPage(PayOrderPageParam param) {
        if (param.getBuDateStart() == null || param.getBuDateEnd() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u9009\u62e9\u4e1a\u52a1\u65e5\u671f!");
        }
        return this.payOrderFactory.writeoffPage(param);
    }

    @Override
    public PayOrderDTO queryById(Long id, Boolean flag) {
        if (flag.booleanValue()) {
            PayOrderDTO payOrderDTO = this.payOrderRepoProc.queryById(id);
            List<PayOrderDtlDTO> payOrderDtlDTOS = this.payOrderDtlRepoProc.queryByMasId(id);
            payOrderDTO.setPayOrderDtlVOList(payOrderDtlDTOS);
            return payOrderDTO;
        }
        return this.payOrderRepoProc.queryById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> deleteByIds(List<Long> ids) {
        List<PayOrderDTO> payOrderDTOS = this.payOrderRepoProc.queryByIds(ids);
        payOrderDTOS.forEach(dto -> {
            if (!dto.getOrderState().equals(UdcEnum.APPLY_STATUS_DRAFT.getValueCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u8349\u7a3f\u7684\u4ed8\u6b3e\u5355!");
            }
            if (Objects.nonNull(dto.getRedSourceNo())) {
                this.payOrderRepoProc.setRedFlag(dto.getRedSourceId(), false);
            }
        });
        this.payOrderRepoProc.deleteByIds(ids);
        this.payOrderDtlRepoProc.deleteByMasIds(ids);
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(PayOrder payOrder) {
        if (payOrder.getId() != null) {
            payOrder.checkOrderState();
        } else {
            String payOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "FKD", null);
            payOrder.setPayOrderNo(payOrderNo);
        }
        payOrder.checkNotNull(payOrder.getCreateMode());
        if (!payOrder.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_MANU.getValueCode())) {
            if (payOrder.getId() == null) {
                if (payOrder.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_AP.getValueCode())) {
                    payOrder.checkDtl(false);
                    payOrder.countMoney();
                    payOrder.checkTotalMoney();
                }
                if (payOrder.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_PO.getValueCode())) {
                    payOrder.setPoDef();
                    payOrder.checkDtl(false);
                    payOrder.countMoney();
                }
            }
        } else {
            payOrder.checkTotalMoney();
        }
        payOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        if (payOrder.getVerAmt() == null) {
            payOrder.defaultVer();
        }
        return this.updateOrSave(payOrder).getId();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long submit(PayOrder payOrder) {
        if (payOrder.getId() != null) {
            payOrder.checkOrderState();
        } else {
            String payOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "FKD", null);
            payOrder.setPayOrderNo(payOrderNo);
        }
        if (payOrder.getVerAmt() == null) {
            payOrder.defaultVer();
        }
        payOrder.checkNotNull(payOrder.getCreateMode());
        if (!payOrder.getCreateMode().equals(UdcEnum.FIN_PAY_DOC_CLS_MANU.getValueCode())) {
            payOrder.checkTotalMoney();
        }
        payOrder.checkMoney();
        payOrder.checkDtl(true);
        payOrder.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        PayOrderDO payOrderDO = this.updateOrSave(payOrder);
        return payOrderDO.getId();
    }

    @Override
    public List<PayOrderDTO> queryByPayTypeId(List<Long> ids) {
        return this.payOrderRepoProc.queryByPayTypeId(ids);
    }

    @Override
    public List<PayOrderDO> queryByIds(List<Long> ids) {
        return this.payOrderRepo.findAllById(ids);
    }

    @Override
    public void saveAll(List<PayOrderDO> payOrderDOS) {
        this.payOrderRepo.saveAll(payOrderDOS);
    }

    @Override
    public List<PayOrderDTO> queryByParam(PayOrderParam payOrderParam) {
        return this.payOrderRepoProc.queryByParam(payOrderParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Retryable(value={BusinessException.class}, maxAttempts=5, backoff=@Backoff(value=500L))
    public void updateVerAmt(Long id, BigDecimal amt) {
        ApVerDTO apVerDTO = this.payOrderRepoProc.queryVerAmtById(id);
        BigDecimal totalAmt = apVerDTO.getTotalAmt();
        if (apVerDTO.getVerAmt().add(amt).compareTo(totalAmt) > 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u6838\u9500\u91d1\u989d\u5927\u4e8e\u4ed8\u6b3e\u5355\u91d1\u989d\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u8f93\u5165");
        }
        apVerDTO.setAmtAndVerState(amt);
        long rows = this.payOrderRepoProc.updateVerAmt(apVerDTO);
        if (rows == 0L) {
            throw new BusinessException("\u4ed8\u6b3e\u5355\u66f4\u65b0\u5df2\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWorkInfo(ProcessInfo processInfo, Long id) {
        this.payOrderRepoProc.updateWorkInfo(processInfo, id);
    }

    private PayOrderDO updateOrSave(PayOrder payOrder) {
        PayOrderDO payOrderDO = PayOrderConvert.INSTANCE.convertToDo(payOrder);
        if (payOrder.getId() != null) {
            this.payOrderDtlRepoProc.deleteByMasIds(List.of(payOrder.getId()));
        } else {
            payOrderDO.setAuditDataVersion(0);
        }
        PayOrderDO save = (PayOrderDO)this.payOrderRepo.save(payOrderDO);
        List<PayOrderDtlDO> payOrderDtlDOS = PayOrderDtlConvert.INSTANCE.convertToDO(payOrder.getDtlList());
        payOrderDtlDOS.forEach(dtl -> dtl.setMasId(save.getId()));
        this.payOrderDtlRepo.saveAll(payOrderDtlDOS);
        return save;
    }

    @Override
    public PayOrder redPunchCreate(Long id) {
        PayOrderDO payOrderDO = (PayOrderDO)this.payOrderRepo.getReferenceById(id);
        payOrderDO.setRedState(Boolean.TRUE);
        this.payOrderRepo.save(payOrderDO);
        PayOrder newPayOrder = (PayOrder)BeanUtils.toBean((Object)payOrderDO, PayOrder.class);
        newPayOrder.setOrderState(UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
        newPayOrder.setProcInstId(null);
        newPayOrder.setProcInstStatus(null);
        newPayOrder.setRedState(null);
        newPayOrder.setRedSourceNo(payOrderDO.getPayOrderNo());
        newPayOrder.setRedSourceId(payOrderDO.getId());
        newPayOrder.setRealPayAmt(BigDecimalUtils.negate(newPayOrder.getRealPayAmt()));
        newPayOrder.setTotalAmt(BigDecimalUtils.negate(newPayOrder.getTotalAmt()));
        newPayOrder.setTotalCurAmt(BigDecimalUtils.negate(newPayOrder.getTotalCurAmt()));
        newPayOrder.setRealPayCurAmt(BigDecimalUtils.negate(newPayOrder.getRealPayCurAmt()));
        newPayOrder.setId(null);
        newPayOrder.setPayOrderNo(null);
        newPayOrder.setProposedStatus(null);
        newPayOrder.setAuditUser(null);
        newPayOrder.setApprovedTime(null);
        newPayOrder.setAuditUserId(null);
        newPayOrder.setRemark(null);
        List<PayOrderDtlDO> dtls = this.payOrderDtlRepo.findAllByMasId(id);
        List<PayOrderDtl> newDtls = dtls.stream().map(dtl -> {
            PayOrderDtl dtlDO = (PayOrderDtl)BeanUtils.toBean((Object)dtl, PayOrderDtl.class);
            dtlDO.setId(null);
            dtlDO.setTotalAmt(BigDecimalUtils.negate(dtl.getTotalAmt()));
            dtlDO.setTotalCurAmt(BigDecimalUtils.negate(dtl.getTotalCurAmt()));
            dtlDO.setRealPayAmt(BigDecimalUtils.negate(dtl.getRealPayAmt()));
            dtlDO.setRealPayCurAmt(BigDecimalUtils.negate(dtl.getRealPayCurAmt()));
            return dtlDO;
        }).collect(Collectors.toList());
        newPayOrder.setDtlList(newDtls);
        newPayOrder.setCheck(false);
        return newPayOrder;
    }

    public PayOrderDomainServiceImpl(PayOrderRepo payOrderRepo, PayOrderRepoProc payOrderRepoProc, PayOrderFactory payOrderFactory, PayOrderDtlRepo payOrderDtlRepo, PayOrderDtlRepoProc payOrderDtlRepoProc, SeqNumProvider sysNumberRuleService) {
        this.payOrderRepo = payOrderRepo;
        this.payOrderRepoProc = payOrderRepoProc;
        this.payOrderFactory = payOrderFactory;
        this.payOrderDtlRepo = payOrderDtlRepo;
        this.payOrderDtlRepoProc = payOrderDtlRepoProc;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

