/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.flow;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.flow.AccountFlowConvert;
import com.elitesland.fin.application.facade.dto.account.AccountIocDTO;
import com.elitesland.fin.application.facade.param.account.AccountIocParam;
import com.elitesland.fin.application.facade.param.account.AccountRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowDealerParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.vo.account.AccountRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowDealerVO;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.service.account.AccountIocService;
import com.elitesland.fin.application.service.account.AccountRuleConfigService;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.flow.AccountFlowCommonService;
import com.elitesland.fin.application.service.flow.AccountFlowFjbService;
import com.elitesland.fin.application.service.flow.AccountFlowPjService;
import com.elitesland.fin.application.service.flow.AccountFlowService;
import com.elitesland.fin.application.service.flow.AccountFlowTcService;
import com.elitesland.fin.application.service.flow.AccountFlowZcService;
import com.elitesland.fin.common.SysNumberGenerator;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.account.AccountDO;
import com.elitesland.fin.entity.account.AccountRuleConfigDO;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.repo.account.AccountRepo;
import com.elitesland.fin.repo.account.AccountRepoProc;
import com.elitesland.fin.repo.account.AccountRuleConfigRepo;
import com.elitesland.fin.repo.flow.AccountFlowRepo;
import com.elitesland.fin.repo.flow.AccountFlowRepoProc;
import com.elitesland.fin.rocketmq.channel.FinSalMqProcessor;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.support.provider.org.param.OrgOuRpcDtoParam;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AccountFlowServiceImpl
implements AccountFlowService {
    private static final Logger log = LoggerFactory.getLogger(AccountFlowServiceImpl.class);
    @Autowired
    private AccountFlowRepo accountFlowRepo;
    @Autowired
    private AccountFlowRepoProc accountFlowRepoProc;
    @Autowired
    private SysNumberGenerator sysNumberGenerator;
    @Autowired
    private AccountFlowZcService accountFlowZcService;
    @Autowired
    private AccountFlowPjService accountFlowPjService;
    @Autowired
    private AccountFlowFjbService accountFlowFjbService;
    @Autowired
    private AccountFlowTcService accountFlowTcService;
    @Autowired
    private AccountFlowCommonService accountFlowCommonService;
    @Autowired
    private AccountRepoProc accountRepoProc;
    @Autowired
    private AccountRepo accountRepo;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;
    @Autowired
    private AccountRuleConfigRepo accountRuleConfigRepo;
    @Autowired
    private RmiOrderRpcService rmiOrderRpcService;
    @Autowired
    private AccountFlowService accountFlowService;
    @Autowired
    private AccountIocService accountIocService;
    @Autowired
    private SeqNumProvider seqNumProvider;
    @Autowired
    private AccountRuleConfigService accountRuleConfigService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private FinSalMqProcessor finSalMqProcessor;
    private static final BigDecimal ONE_HUNDRED_BIGDECIMAL = new BigDecimal("100");

    @Override
    @SysCodeProc
    public PagingVO<AccountFlowVO> page(AccountFlowPageParam pageParam) {
        PagingVO<AccountFlowVO> pagingVO = this.accountFlowRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List accountFlowVOList = pagingVO.getRecords();
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuCodes(accountFlowVOList.stream().map(AccountFlowVO::getCompanyCode).collect(Collectors.toList()));
        List<OrgOuRpcDTO> orgOuRpcDTOList = this.rmiOrgOuRpcServiceService.findOuDtoByParam(orgOuRpcDtoParam);
        List accountRuleConfigDOList = this.accountRuleConfigRepo.findAll();
        accountFlowVOList.stream().forEach(item -> {
            AccountRuleConfigDO accountRuleConfigDOResult;
            OrgOuRpcDTO orgOuRpcDTOResult = orgOuRpcDTOList.stream().filter(orgOuRpcDTO -> StringUtils.equals((CharSequence)orgOuRpcDTO.getOuCode(), (CharSequence)item.getCompanyCode())).findFirst().orElse(null);
            if (orgOuRpcDTOResult != null) {
                item.setCompanyCodeName(orgOuRpcDTOResult.getOuName());
            }
            if ((accountRuleConfigDOResult = (AccountRuleConfigDO)accountRuleConfigDOList.stream().filter(accountRuleConfigDO -> StringUtils.equals((CharSequence)item.getRuleCode(), (CharSequence)accountRuleConfigDO.getRuleCode())).findFirst().orElse(null)) != null) {
                item.setRuleName(accountRuleConfigDOResult.getRuleName());
            }
        });
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> selectBySourceAndNo(String dataSource, String sourceNo) {
        if (StringUtils.isEmpty((CharSequence)dataSource)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u6765\u6e90\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((CharSequence)sourceNo)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a!");
        }
        AccountFlowPageParam accountFlowPageParam = new AccountFlowPageParam();
        accountFlowPageParam.setDataSource(dataSource);
        accountFlowPageParam.setSourceNoEq(sourceNo);
        List<AccountFlowVO> accountFlowVOList = this.accountFlowRepoProc.selectListByParam(accountFlowPageParam);
        if (CollectionUtils.isEmpty(accountFlowVOList)) {
            return Collections.emptyList();
        }
        return accountFlowVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<AccountFlowVO> dealerPage(AccountFlowPageParam pageParam) {
        this.checkMandatoryField02(pageParam);
        if (StringUtils.isNotBlank((CharSequence)pageParam.getYearMonthStr())) {
            LocalDate transactionDate = this.accountFlowCommonService.transitionYearMonthStr(pageParam.getYearMonthStr());
            this.accountFlowCommonService.splicTransactionTimeSection(transactionDate, pageParam);
        }
        pageParam.setAccIoTypeList(Lists.newArrayList((Object[])new String[]{"ADD", "SUB"}));
        PagingVO<AccountFlowVO> pagingVO = this.accountFlowRepoProc.dealerPage(pageParam);
        if (CollectionUtils.isEmpty((Collection)pagingVO.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        return PagingVO.builder().total(pagingVO.getTotal()).records(pagingVO.getRecords()).build();
    }

    @Override
    public AccountFlowDealerVO dealerSelectAmt(AccountFlowPageParam pageParam) {
        this.checkMandatoryField02(pageParam);
        LocalDate transactionDate = this.accountFlowCommonService.transitionYearMonthStr(pageParam.getYearMonthStr());
        this.accountFlowCommonService.splicTransactionTimeSection(transactionDate, pageParam);
        AccountFlowDealerVO accountFlowDealerVO = new AccountFlowDealerVO();
        accountFlowDealerVO.setUseAmt(BigDecimal.ZERO);
        accountFlowDealerVO.setRecordAmt(BigDecimal.ZERO);
        pageParam.setAccIoType("ADD");
        List<AccountFlowVO> addAmtList = this.accountFlowRepoProc.dealerSelectAmt(pageParam);
        if (!CollectionUtils.isEmpty(addAmtList)) {
            BigDecimal recordAmt = addAmtList.stream().map(AccountFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            accountFlowDealerVO.setRecordAmt(recordAmt);
        }
        pageParam.setAccIoType("SUB");
        List<AccountFlowVO> subAmtList = this.accountFlowRepoProc.dealerSelectAmt(pageParam);
        if (!CollectionUtils.isEmpty(subAmtList)) {
            BigDecimal useAmt = subAmtList.stream().map(AccountFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            accountFlowDealerVO.setUseAmt(useAmt);
        }
        return accountFlowDealerVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AccountFlowVO save(List<AccountFlowParam> paramList) {
        log.info("\u83b7\u53d6\u6d41\u6c34\u5165\u53c2{}", (Object)JSON.toJSONString(paramList));
        this.checkMandatoryFieldList(paramList);
        this.checkRepeatability(paramList);
        this.distinguishAccType(paramList);
        return new AccountFlowVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AccountFlowDO saveAccountFlow(AccountFlowParam accountFlowParam) {
        this.checkMandatoryField(accountFlowParam);
        return (AccountFlowDO)((Object)this.accountFlowRepo.save((Object)AccountFlowConvert.INSTANCE.paramToDo(accountFlowParam)));
    }

    private void distinguishAccType(List<AccountFlowParam> paramList) {
        List<AccountFlowParam> accountFlowTcList;
        List<AccountFlowParam> accountFlowFjbList;
        List<AccountFlowParam> accountFlowPjList;
        List<AccountFlowParam> accountFlowZcList = paramList.stream().filter(param -> this.accountFlowCommonService.judgeZcAccType(param.getAccType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(accountFlowZcList)) {
            this.accountFlowZcService.saveZc(accountFlowZcList);
        }
        if (!CollectionUtils.isEmpty(accountFlowPjList = paramList.stream().filter(param -> this.accountFlowCommonService.judgePjAccType(param.getAccType())).collect(Collectors.toList()))) {
            this.accountFlowPjService.savePj(accountFlowPjList);
        }
        if (!CollectionUtils.isEmpty(accountFlowFjbList = paramList.stream().filter(param -> this.accountFlowCommonService.judgeFjbAccType(param.getAccType())).collect(Collectors.toList()))) {
            this.accountFlowFjbService.saveFjb(accountFlowFjbList);
        }
        if (!CollectionUtils.isEmpty(accountFlowTcList = paramList.stream().filter(param -> this.accountFlowCommonService.judgeTcAccType(param.getAccType())).collect(Collectors.toList()))) {
            this.accountFlowTcService.saveTc(accountFlowTcList);
        }
    }

    @Override
    public void checkMandatoryFieldList(List<AccountFlowParam> paramList) {
        Assert.notEmpty(paramList, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        paramList.stream().forEach(accountFlowParam -> this.checkMandatoryField((AccountFlowParam)((Object)accountFlowParam)));
    }

    @Override
    public void checkMandatoryField(AccountFlowParam param) {
        if (StringUtils.isBlank((CharSequence)param.getAccountType())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getSourceDoc())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u6765\u6e90\u5355\u636e\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getSourceNo())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getTransactionType())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u4ea4\u6613\u7c7b\u578b\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getAmount())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u53d1\u751f\u91d1\u989d\u4e3a\u7a7a!");
        }
        if (Objects.isNull(param.getTransactionTime())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getAccountCode())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)param.getAccountName())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "\u8d26\u6237\u540d\u79f0\u4e3a\u7a7a!");
        }
    }

    @Override
    public void checkRepeatability(List<AccountFlowParam> paramList) {
        List dataSourceList = paramList.stream().map(AccountFlowParam::getDataSource).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(dataSourceList) && dataSourceList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b58\u5728\u591a\u79cd\u6570\u636e\u6765\u6e90!");
        }
        Map<String, List<AccountFlowParam>> accountFlowListMap = paramList.stream().collect(Collectors.groupingBy(i -> i.getAccType() + "-" + i.getDataSource() + "-" + i.getTransactionType()));
        for (String accountFlowKey : accountFlowListMap.keySet()) {
            List<AccountFlowParam> accountFlowList = accountFlowListMap.get(accountFlowKey);
            String[] keyParams = accountFlowKey.split("-");
            String dataSource = keyParams[1];
            if (Objects.equals(dataSource, UdcEnum.FIN_DATA_SOURCE_TYPE_TJD03.getValueCode())) {
                List splitTypeList = accountFlowList.stream().map(AccountFlowParam::getSplitType).distinct().collect(Collectors.toList());
                if (Objects.equals(accountFlowList.size(), splitTypeList.size())) continue;
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8c03\u5242\u5355\u6570\u636e\u4e0d\u552f\u4e00\uff0c\u65e0\u6cd5\u5904\u7406!");
            }
            if (CollectionUtils.isEmpty(accountFlowList) || accountFlowList.size() <= 1) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u4e0d\u552f\u4e00\uff0c\u65e0\u6cd5\u5904\u7406!");
        }
    }

    @Override
    public void checkMandatoryField02(AccountFlowPageParam pageParam) {
        if (StringUtils.isBlank((CharSequence)pageParam.getYearMonthStr())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5e74\u6708\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getAccCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((CharSequence)pageParam.getAccType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a!");
        }
    }

    @Override
    public AccountFlowDealerVO dealerSelectAccAmt(AccountFlowDealerParam param) {
        AccountFlowDealerVO accountFlowDealerVO = new AccountFlowDealerVO();
        accountFlowDealerVO.setCzAccAmt(BigDecimal.ZERO);
        accountFlowDealerVO.setFlAccAmt(BigDecimal.ZERO);
        Optional<AccountFlowVO> czOptional = this.accountFlowCommonService.selectByAccCode(param.getCzAccCode());
        czOptional.ifPresent(accountFlowVO -> accountFlowDealerVO.setCzAccAmt(accountFlowVO.getAccAmt()));
        Optional<AccountFlowVO> flOptional = this.accountFlowCommonService.selectByAccCode(param.getFlAccCode());
        flOptional.ifPresent(accountFlowVO -> accountFlowDealerVO.setFlAccAmt(accountFlowVO.getAccAmt()));
        return accountFlowDealerVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void approve(AccountFlowParam accountFlowParam) {
        this.checkApproveParam(accountFlowParam);
        this.approve(accountFlowParam, UdcEnum.APPLY_STATUS_COMPLETE.getValueCode(), true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reject(AccountFlowParam accountFlowParam) {
        this.checkApproveParam(accountFlowParam);
        this.approve(accountFlowParam, UdcEnum.APPLY_STATUS_REJECTED.getValueCode(), false);
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> queryByAccountFlowQueryParam(AccountFlowQueryParam accountFlowQueryParam) {
        List<AccountFlowVO> flowVOList = this.accountFlowRepoProc.queryByAccountFlowQueryParam(accountFlowQueryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    public void accountFlowCallBack(String doc, AccountFlowDO accountFlowDO, boolean isApprove) {
        if (UdcEnum.DOC_CLS_SVO.getValueCode().equals(doc) || UdcEnum.DOC_CLS_AO.getValueCode().equals(doc)) {
            return;
        }
    }

    private void checkApproveParam(AccountFlowParam accountFlowParam) {
        Assert.notNull((Object)((Object)accountFlowParam), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)accountFlowParam.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getAccountCode(), (String)"\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getTransactionType(), (String)"\u4ea4\u6613\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)accountFlowParam.getAmount(), (String)"\u53d1\u751f\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void approve(AccountFlowParam accountFlowParam, String state, boolean isApprove) {
        Optional accountFlowDOOptional = this.accountFlowRepo.findById(accountFlowParam.getId());
        AccountFlowDO accountFlowDO = (AccountFlowDO)((Object)accountFlowDOOptional.get());
        Assert.equals((Object)UdcEnum.APPLY_STATUS_DOING.getValueCode(), (Object)accountFlowDO.getOrderState(), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u72b6\u6001\u5355\u636e\u624d\u53ef\u5ba1\u6279", (Object[])new Object[0]);
        if (UdcEnum.IO_TYPE_T.getValueCode().equals(accountFlowParam.getTransactionType())) {
            this.updateAccountAmountFor_IO_TYPE_T(accountFlowParam, state);
        } else {
            this.updateAccountAmountOther(accountFlowParam, state);
        }
        SysUserDTO user = this.getUser();
        accountFlowParam.setOrderState(state);
        accountFlowParam.setAuditDate(LocalDateTime.now());
        accountFlowParam.setAuditUserName("SYSTEM");
        if (user != null) {
            accountFlowParam.setAuditUserId(user.getId());
            accountFlowParam.setAuditUserName(user.getLastName());
        }
        this.accountFlowRepoProc.approveAccountFlow(accountFlowParam);
    }

    private void updateAccountAmount(AccountFlowParam accountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            AccountDO accountDO = this.accountRepoProc.findByAccountCode(accountFlowParam.getAccountCode());
            BigDecimal accountAmount = accountDO.getAccountAmount();
            BigDecimal accountOccupancyAmount = accountDO.getAccountOccupancyAmount();
            Assert.equals((Object)accountDO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowParam.getTransactionType())) {
                accountAmount = accountAmount.add(accountFlowParam.getAmount());
            }
            if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowParam.getTransactionType())) {
                accountAmount = accountAmount.subtract(accountFlowParam.getAmount());
            }
            if (UdcEnum.IO_TYPE_T.getValueCode().equals(accountFlowParam.getTransactionType())) {
                accountOccupancyAmount = accountOccupancyAmount.add(accountFlowParam.getAmount());
            }
            if (UdcEnum.IO_TYPE_R.getValueCode().equals(accountFlowParam.getTransactionType())) {
                accountOccupancyAmount = accountOccupancyAmount.subtract(accountFlowParam.getAmount());
            }
            accountDO.setAccountAmount(accountAmount);
            accountDO.setAccountOccupancyAmount(accountOccupancyAmount);
            accountDO.setAccountAvailableAmount(accountAmount.subtract(accountOccupancyAmount));
            accountFlowParam.setAccountAmount(accountAmount);
            accountFlowParam.setAccountOccupancyAmount(accountOccupancyAmount);
            accountFlowParam.setAccountAvailableAmount(accountAmount.subtract(accountOccupancyAmount));
            accountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            this.accountFlowRepoProc.updateAccountFlowAmount(accountFlowParam);
        }
    }

    private void updateAccountAmountFor_IO_TYPE_T(AccountFlowParam accountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            AccountVO accountVOOld = this.accountRepoProc.getVOByCode(accountFlowParam.getAccountCode());
            Assert.equals((Object)accountVOOld.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            int res = this.accountRepo.updateAccountOccupancyAmountAndAccountAvailableAmountById(accountVOOld.getId(), accountFlowParam.getAmount());
            log.info("\u8d26\u6237\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
            if (res < 1) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
                throw new BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25,\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
            }
            AccountVO accountVO = this.accountRepoProc.get(accountVOOld.getId());
            if (accountVO == null) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
                throw new BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
            }
            accountFlowParam.setAccountAmount(accountVO.getAccountAmount());
            accountFlowParam.setAccountOccupancyAmount(accountVO.getAccountOccupancyAmount());
            accountFlowParam.setAccountAvailableAmount(accountVO.getAccountAvailableAmount());
            accountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            this.accountFlowRepoProc.updateAccountFlowAmount(accountFlowParam);
        }
    }

    private void updateAccountAmountOther(AccountFlowParam accountFlowParam, String state) {
        if (UdcEnum.APPLY_STATUS_COMPLETE.getValueCode().equals(state)) {
            AccountVO newAccountVO;
            int res;
            AccountVO oldAccountVO = this.accountRepoProc.getVOByCode(accountFlowParam.getAccountCode());
            Assert.equals((Object)oldAccountVO.getState(), (Object)UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode(), (String)"\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528", (Object[])new Object[0]);
            if (UdcEnum.IO_TYPE_I.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateAddAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new BusinessException("\u8d26\u6237\u589e\u52a0\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_O.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateSubtractAccountAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new BusinessException("\u8d26\u6237\u6263\u51cf\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else if (UdcEnum.IO_TYPE_R.getValueCode().equals(accountFlowParam.getTransactionType())) {
                res = this.accountRepo.updateSubtractAccountOccupancyAmountAndAccountAvailableAmountById(oldAccountVO.getId(), accountFlowParam.getAmount());
                log.info("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55\u6570\uff1a{}", (Object)res);
                if (res < 1) {
                    log.error("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                    throw new BusinessException("\u8d26\u6237\u5360\u7528\u91ca\u653e\u6d41\u6c34\u751f\u6210,\u66f4\u65b0\u8d26\u6237\u91d1\u989d\u5931\u8d25!");
                }
            } else {
                throw new BusinessException("\u8d26\u6237\u672a\u5339\u914d\u5230\u4ea4\u6613\u7c7b\u578b!");
            }
            if ((newAccountVO = this.accountRepoProc.get(oldAccountVO.getId())) == null) {
                log.error("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
                throw new BusinessException("\u8d26\u6237\u6d41\u6c34\u751f\u6210,\u67e5\u8be2\u66f4\u65b0\u540e\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
            }
            accountFlowParam.setAccountAmount(newAccountVO.getAccountAmount());
            accountFlowParam.setAccountOccupancyAmount(newAccountVO.getAccountOccupancyAmount());
            accountFlowParam.setAccountAvailableAmount(newAccountVO.getAccountAvailableAmount());
            accountFlowParam.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
            this.accountFlowRepoProc.updateAccountFlowAmount(accountFlowParam);
        }
    }

    private SysUserDTO getUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        return userDetails.getUser();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String generateAccountFlow(AccountFlowParam param) {
        log.info("\u751f\u6210\u8d26\u6237\u6d41\u6c34\uff0c{}", (Object)JSONUtil.toJsonStr((Object)((Object)param)));
        this.checkGenerateAccountFlowParam(param);
        AccountFlowParam accountFlowParam = AccountFlowConvert.INSTANCE.copyParam(param);
        this.buildAccountFlowParam(accountFlowParam);
        AccountDO accountDO = this.getAccountMsg(accountFlowParam);
        if (StrUtil.isEmpty((CharSequence)param.getWorkflowProcInstId())) {
            this.checkIdempotent(accountDO, accountFlowParam);
        }
        List<AccountRuleConfigPageVO> accountRuleConfigPageVOList = this.getAccountRuleMsg(accountDO, accountFlowParam);
        List<AccountIocDTO> accountIocDTOList = this.getAccountIocMsg(accountRuleConfigPageVOList);
        accountRuleConfigPageVOList = accountRuleConfigPageVOList.stream().sorted(Comparator.comparing(AccountRuleConfigPageVO::getPriorityNo)).collect(Collectors.toList());
        this.checkAccountAmount(accountRuleConfigPageVOList, accountDO, accountFlowParam, accountIocDTOList);
        List<AccountFlowParam> accountFlowParamList = this.generateAccountFlow(accountRuleConfigPageVOList, accountDO, accountIocDTOList, accountFlowParam);
        this.accountFlowReview(accountFlowParamList);
        return accountFlowParamList.get(0).getFlowNo();
    }

    private void accountFlowReview(List<AccountFlowParam> accountFlowParamList) {
        accountFlowParamList.stream().forEach(item -> {
            if (item.isAutomaticReview()) {
                this.accountFlowService.approve((AccountFlowParam)((Object)item));
            }
        });
    }

    private void sendAccountFlowReviewMsg(List<AccountFlowParam> accountFlowParamList) {
        accountFlowParamList.stream().forEach(item -> {
            if (item.isAutomaticReview()) {
                try {
                    boolean result = this.finSalMqProcessor.approveAccountFlowOutput().send(MessageBuilder.withPayload((Object)item).build());
                    if (!result) {
                        log.error("\u6d41\u6c34\u81ea\u52a8\u5ba1\u6279\u6d88\u606f\u53d1\u9001\u5931\u8d25");
                    }
                }
                catch (Exception e) {
                    log.error("\u6d41\u6c34\u81ea\u52a8\u5ba1\u6279\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private List<AccountFlowParam> generateAccountFlow(List<AccountRuleConfigPageVO> accountRuleConfigPageVOList, AccountDO accountDO, List<AccountIocDTO> accountIocDTOList, AccountFlowParam accountFlowParam) {
        List<AccountRuleConfigPageVO> finalAccountRuleConfigPageVOList = accountRuleConfigPageVOList;
        ArrayList<AccountFlowParam> accountFlowParamList = new ArrayList<AccountFlowParam>();
        finalAccountRuleConfigPageVOList.stream().forEach(accountRuleConfigPageVO -> {
            AccountFlowParam param = this.buildAccountFlowParam(accountFlowParam, accountDO, accountIocDTOList, (AccountRuleConfigPageVO)accountRuleConfigPageVO);
            AccountFlowDO accountFlowDO = this.accountFlowService.saveAccountFlow(param);
            param.setId(accountFlowDO.getId());
            param.setFlowNo(accountFlowDO.getFlowNo());
            accountFlowParamList.add(param);
        });
        return accountFlowParamList;
    }

    @Override
    public Boolean checkAccountBalance(AccountFlowParam param) {
        this.checkGenerateAccountFlowParam(param);
        AccountFlowParam accountFlowParam = AccountFlowConvert.INSTANCE.copyParam(param);
        this.buildAccountFlowParam(accountFlowParam);
        AccountDO accountDO = this.getAccountMsg(accountFlowParam);
        this.checkIdempotent(accountDO, accountFlowParam);
        List<AccountRuleConfigPageVO> accountRuleConfigPageVOList = this.getAccountRuleMsg(accountDO, accountFlowParam);
        List<AccountIocDTO> accountIocDTOList = this.getAccountIocMsg(accountRuleConfigPageVOList);
        accountRuleConfigPageVOList = accountRuleConfigPageVOList.stream().sorted(Comparator.comparing(AccountRuleConfigPageVO::getPriorityNo)).collect(Collectors.toList());
        this.checkAccountAmount(accountRuleConfigPageVOList, accountDO, accountFlowParam, accountIocDTOList);
        return true;
    }

    private void buildAccountFlowParam(AccountFlowParam accountFlowParam) {
        accountFlowParam.setSourceDocType(accountFlowParam.getSourceDoc().concat("_").concat(accountFlowParam.getSourceDocType()));
        accountFlowParam.setSourceDocStatus(accountFlowParam.getSourceDoc().concat("_").concat(accountFlowParam.getSourceDocStatus()));
    }

    private void checkAccountAmount(List<AccountRuleConfigPageVO> accountRuleConfigPageVOList, AccountDO accountDO, AccountFlowParam accountFlowParam, List<AccountIocDTO> accountIocDTOList) {
        accountRuleConfigPageVOList.stream().forEach(item -> {
            AccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(accountIocRespVO -> accountIocRespVO.getIoCode().equals(item.getIoCode())).findFirst().orElse(null);
            Assert.notNull((Object)accountIocDTO, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u542f\u7528\u7684\u8d26\u6237\u4e8b\u52a1", (Object[])new Object[0]);
            if (UdcEnum.IO_TYPE_T.getValueCode().equals(accountIocDTO.getIoType())) {
                Assert.isTrue((accountDO.getAccountAvailableAmount().compareTo(accountFlowParam.getSourceDocAmount().multiply(item.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL)) >= 0 ? 1 : 0) != 0, (String)"\u8d26\u6237\u53ef\u7528\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
            }
        });
    }

    private void checkIdempotent(AccountDO accountDO, AccountFlowParam accountFlowParam) {
        AccountFlowQueryParam accountFlowQueryParam = new AccountFlowQueryParam();
        accountFlowQueryParam.setSourceId(accountFlowParam.getSourceId());
        accountFlowQueryParam.setSourceDoc(accountFlowParam.getSourceDoc());
        accountFlowQueryParam.setSourceDocStatus(accountFlowParam.getSourceDocStatus());
        accountFlowQueryParam.setSourceNo(accountFlowParam.getSourceNo());
        accountFlowQueryParam.setAccountType(accountDO.getAccountType());
        if (ObjUtil.equals((Object)accountFlowParam.getOverOneFlow(), (Object)Boolean.TRUE)) {
            accountFlowQueryParam.setAccountCode(accountFlowParam.getAccountCode());
        }
        Assert.isTrue((boolean)CollectionUtils.isEmpty(this.accountFlowService.queryByAccountFlowQueryParam(accountFlowQueryParam)), (String)"\u8ba2\u5355\u5df2\u7ecf\u751f\u6210\u8fc7\u6d41\u6c34", (Object[])new Object[0]);
    }

    private List<AccountIocDTO> getAccountIocMsg(List<AccountRuleConfigPageVO> accountRuleConfigPageVOList) {
        HashSet<String> ioCodeSet = new HashSet<String>();
        accountRuleConfigPageVOList.stream().forEach(item -> ioCodeSet.add(item.getIoCode()));
        AccountIocParam accountIocParam = new AccountIocParam();
        accountIocParam.setIoCodeSet(ioCodeSet);
        accountIocParam.setState(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<AccountIocDTO> accountIocDTOList = this.accountIocService.queryByAccountIocParam(accountIocParam);
        Assert.notEmpty(accountIocDTOList, (String)"\u67e5\u8be2\u8d26\u6237\u4e8b\u52a1\u7801\u5931\u8d25", (Object[])new Object[0]);
        return accountIocDTOList;
    }

    public AccountFlowParam buildAccountFlowParam(AccountFlowParam accountFlowParam, AccountDO accountDO, List<AccountIocDTO> accountIocDTOList, AccountRuleConfigPageVO accountRuleConfigPageVO) {
        AccountFlowParam result = new AccountFlowParam();
        result.setCompanyCode(accountDO.getSecOuCode());
        result.setSecFranchiseeCode(accountDO.getSecFranchiseeCode());
        result.setFlowNo(this.seqNumProvider.generateCode("yst-fin", "ACCOUNT_FLOW_NO", Collections.emptyList()));
        AccountIocDTO accountIocDTO = accountIocDTOList.stream().filter(accountIocRespVO -> accountIocRespVO.getIoCode().equals(accountRuleConfigPageVO.getIoCode())).findFirst().orElse(null);
        Assert.notNull((Object)accountIocDTO, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u542f\u7528\u7684\u8d26\u6237\u4e8b\u52a1", (Object[])new Object[0]);
        result.setTransactionType(accountIocDTO.getIoType());
        result.setAmount(accountFlowParam.getSourceDocAmount().multiply(accountRuleConfigPageVO.getCalculatePercent()).divide(ONE_HUNDRED_BIGDECIMAL));
        result.setTransactionTime(LocalDateTime.now());
        result.setAccountHolderName(accountDO.getAccountHolderName());
        result.setAccountType(accountDO.getAccountType());
        result.setAccountCode(accountDO.getAccountCode());
        result.setAccountName(accountDO.getAccountName());
        result.setSourceDoc(accountFlowParam.getSourceDoc());
        result.setSourceNo(accountFlowParam.getSourceNo());
        result.setSourceId(accountFlowParam.getSourceId());
        result.setRuleCode(accountRuleConfigPageVO.getRuleCode());
        result.setPriorityNo(accountRuleConfigPageVO.getPriorityNo());
        result.setOrderState(UdcEnum.APPLY_STATUS_DOING.getValueCode());
        result.setSourceDocStatus(accountFlowParam.getSourceDocStatus());
        result.setAutomaticReview(accountRuleConfigPageVO.isAutomaticReview());
        result.setAccountAmount(accountDO.getAccountAmount());
        result.setAccountOccupancyAmount(accountDO.getAccountOccupancyAmount());
        result.setAccountAvailableAmount(accountDO.getAccountAvailableAmount());
        return result;
    }

    private List<AccountRuleConfigPageVO> getAccountRuleMsg(AccountDO accountDO, AccountFlowParam accountFlowParam) {
        AccountRuleConfigQueryParam accountRuleConfigQueryParam = new AccountRuleConfigQueryParam();
        accountRuleConfigQueryParam.setOptDoc(accountFlowParam.getSourceDoc());
        accountRuleConfigQueryParam.setOptDocType(accountFlowParam.getSourceDocType());
        accountRuleConfigQueryParam.setOptDocStatus(accountFlowParam.getSourceDocStatus());
        accountRuleConfigQueryParam.setOptAccountType(accountDO.getAccountType());
        accountRuleConfigQueryParam.setSpecificAccount(accountDO.getAccountCode());
        accountRuleConfigQueryParam.setStatus(UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        PagingVO<AccountRuleConfigPageVO> accountRuleConfigPageVOPagingVO = this.accountRuleConfigService.searchPage(accountRuleConfigQueryParam);
        Assert.notNull(accountRuleConfigPageVOPagingVO, (String)"\u67e5\u8be2\u8ba2\u5355\u80fd\u5339\u914d\u5230\u7684\u89c4\u5219\u5931\u8d25", (Object[])new Object[0]);
        Assert.notEmpty((Iterable)accountRuleConfigPageVOPagingVO.getRecords(), (String)"\u6ca1\u6709\u5339\u914d\u5230\u8d26\u6237\u89c4\u5219\u914d\u7f6e", (Object[])new Object[0]);
        return accountRuleConfigPageVOPagingVO.getRecords();
    }

    private AccountDO getAccountMsg(AccountFlowParam accountFlowParam) {
        return this.accountRepoProc.findByAccountCode(accountFlowParam.getAccountCode());
    }

    private void checkGenerateAccountFlowParam(AccountFlowParam accountFlowParam) {
        Assert.notNull((Object)((Object)accountFlowParam), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getSourceDoc(), (String)"\u6765\u6e90\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getSourceDocType(), (String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getSourceDocStatus(), (String)"\u6765\u6e90\u5355\u636e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)accountFlowParam.getSourceDocAmount(), (String)"\u6765\u6e90\u5355\u636e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)accountFlowParam.getSourceId(), (String)"\u6765\u6e90\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getSourceNo(), (String)"\u6765\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)accountFlowParam.getAccountCode(), (String)"\u8d26\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> selectListByQueryParam(AccountFlowQueryParam queryParam) {
        List<AccountFlowVO> flowVOList = this.accountFlowRepoProc.selectListByQueryParam(queryParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> selectRepairAfterPage(AccountFlowPageParam pageParam) {
        List<AccountFlowVO> flowVOList = this.accountFlowRepoProc.selectRepairAfterPage(pageParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }

    @Override
    @SysCodeProc
    public List<AccountFlowVO> selectRepairAfter(AccountFlowPageParam pageParam) {
        List<AccountFlowVO> flowVOList = this.accountFlowRepoProc.selectRepairAfter(pageParam);
        if (CollectionUtils.isEmpty(flowVOList)) {
            return Collections.EMPTY_LIST;
        }
        return flowVOList;
    }
}

