/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.recorder;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.recorder.RecOrderConvert;
import com.elitesland.fin.application.convert.rectype.RecTypeConvert;
import com.elitesland.fin.application.facade.dto.writeoff.RecOrderAmtUpdateDTO;
import com.elitesland.fin.application.facade.param.recorder.RecOrderSaveParam;
import com.elitesland.fin.application.facade.vo.recorder.RecOrderVO;
import com.elitesland.fin.application.service.recorder.RecOrderService;
import com.elitesland.fin.application.service.workflow.WorkFlowDefKey;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.recorder.RecOrder;
import com.elitesland.fin.domain.entity.recorder.RecOrderDtlDO;
import com.elitesland.fin.domain.param.recorder.RecOrderPageParam;
import com.elitesland.fin.domain.service.recorder.RecOrderDomainService;
import com.elitesland.fin.domain.service.rectype.RecTypeDomainService;
import com.elitesland.fin.infr.dto.recorder.RecOrderDTO;
import com.elitesland.fin.infr.dto.recorder.RecOrderDtlDTO;
import com.elitesland.fin.infr.dto.rectype.RecTypeDTO;
import com.elitesland.fin.infr.repo.recorder.RecOrderDtlRepoProc;
import com.elitesland.fin.repo.writeoff.RecOrderDetailRepoProc;
import com.elitesland.fin.rpc.system.SystemRpcService;
import com.elitesland.fin.rpc.workflow.WorkflowRpcService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

@Service
public class RecOrderServiceImpl
implements RecOrderService {
    private static final Logger log = LoggerFactory.getLogger(RecOrderServiceImpl.class);
    private final RecOrderDomainService recOrderDomainService;
    private final RecTypeDomainService recTypeDomainService;
    private final SystemRpcService systemRpcService;
    private final WorkflowRpcService workflowRpcService;
    private final TransactionTemplate transactionTemplate;
    private final RecOrderDtlRepoProc recOrderDtlRepoProc;
    final RecOrderDetailRepoProc recOrderDetailRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<RecOrderVO> page(RecOrderPageParam param) {
        PagingVO<RecOrderDTO> page = this.recOrderDomainService.page(param);
        PagingVO<RecOrderVO> recOrderVOPagingVO = RecOrderConvert.INSTANCE.convertPage(page);
        recOrderVOPagingVO.getRecords().forEach(vo -> {
            if (vo.getVerAmt() != null && vo.getTotalAmt() != null) {
                vo.setUnVerAmt(vo.getTotalAmt().subtract(vo.getVerAmt()));
            }
        });
        return recOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<RecOrderVO> writeoffPage(RecOrderPageParam param) {
        PagingVO<RecOrderDTO> page = this.recOrderDomainService.writeoffPage(param);
        PagingVO<RecOrderVO> recOrderVOPagingVO = RecOrderConvert.INSTANCE.convertPage(page);
        if (recOrderVOPagingVO.isEmpty()) {
            return recOrderVOPagingVO;
        }
        List<Long> masIds = recOrderVOPagingVO.getRecords().stream().map(RecOrderVO::getId).collect(Collectors.toList());
        Map recOrderDtlDTOMap = this.recOrderDtlRepoProc.queryByMasIds(masIds).stream().collect(Collectors.groupingBy(RecOrderDtlDTO::getMasId, Collectors.toList()));
        recOrderVOPagingVO.getRecords().forEach(vo -> {
            BigDecimal verAmt = BigDecimal.ZERO;
            BigDecimal verAmting = BigDecimal.ZERO;
            BigDecimal unVerAmt = BigDecimal.ZERO;
            List recOrderDtlDTOS = (List)recOrderDtlDTOMap.get(vo.getId());
            if (CollUtil.isNotEmpty((Collection)recOrderDtlDTOS)) {
                for (RecOrderDtlDTO recOrderDtlDTO : recOrderDtlDTOS) {
                    verAmt = verAmt.add(recOrderDtlDTO.getVerAmt());
                    verAmting = verAmting.add(recOrderDtlDTO.getApplyVerAmTing());
                    unVerAmt = unVerAmt.add(recOrderDtlDTO.getUnVerAmt());
                }
            }
            vo.setVerAmt(verAmt);
            vo.setApplyVerAmTing(verAmting);
            vo.setUnVerAmt(unVerAmt);
            if (unVerAmt.add(verAmting).compareTo(BigDecimal.ZERO) == 0) {
                vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_YES.getValueCode());
            } else if (unVerAmt.add(verAmting).compareTo(vo.getTotalAmt()) == 0) {
                vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_AWAIT.getValueCode());
            } else {
                vo.setVerState(UdcEnum.FIN_VERIFY_STATUS_PART.getValueCode());
            }
        });
        return recOrderVOPagingVO;
    }

    @Override
    @SysCodeProc
    public RecOrderVO queryById(Long id) {
        RecOrderDTO recOrderDTO = this.recOrderDomainService.queryById(id, false);
        RecOrderVO recOrderVO = RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO);
        return recOrderVO;
    }

    @Override
    @SysCodeProc
    public RecOrderVO queryDetailsById(Long id) {
        RecOrderDTO recOrderDTO = this.recOrderDomainService.queryById(id, true);
        RecOrderVO recOrderVO = RecOrderConvert.INSTANCE.dtoToVo(recOrderDTO);
        return recOrderVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> deleteByIds(List<Long> ids) {
        List<Long> deleteByIds = this.recOrderDomainService.deleteByIds(ids);
        return ApiResult.ok(deleteByIds);
    }

    @Override
    public ApiResult<RecOrderVO> defaultValue() {
        RecTypeDTO recTypeDTO = this.recTypeDomainService.defaultValue();
        RecOrderVO recOrderVO = RecTypeConvert.INSTANCE.typeToOrder(recTypeDTO);
        if (recOrderVO == null) {
            return ApiResult.ok((Object)new RecOrderVO());
        }
        return ApiResult.ok((Object)recOrderVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(RecOrderSaveParam param) {
        RecOrder order = RecOrderConvert.INSTANCE.convertParam(param);
        Long id = this.recOrderDomainService.save(order);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> submit(RecOrderSaveParam param) {
        Boolean auto = this.recTypeDomainService.getAuto(param.getRecTypeId());
        RecOrder order = RecOrderConvert.INSTANCE.convertParam(param);
        if (auto.booleanValue()) {
            order.setAuditDate(LocalDateTime.now());
            order.setAuditUser("admin");
            SysUserDTO user = this.systemRpcService.getUserByName("admin");
            order.setAuditUserId(user.getId());
        }
        this.transactionTemplate.setPropagationBehavior(3);
        Long id = (Long)this.transactionTemplate.execute(transactionStatus -> this.recOrderDomainService.submit(order, auto));
        if (!auto.booleanValue()) {
            this.startWorkFlow(order, id);
        }
        return ApiResult.ok((Object)id);
    }

    private void startWorkFlow(RecOrder order, Long id) {
        if (order.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(order.getProcInstStatus())) {
            String procInstName = "\u6536\u6b3e\u5355\u5ba1\u6838-" + order.getRecOrderNo();
            String procKey = WorkFlowDefKey.FIN_REC_ORDER.name();
            ProcessInfo processInfo = this.workflowRpcService.startProcess(procKey, procInstName, id.toString(), new HashMap<String, Object>());
            this.recOrderDomainService.updateWorkInfo(processInfo, id);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMiddleVerAmt(Long recDId, BigDecimal amt) {
        RecOrderDtlDO detail = this.findDetail(recDId);
        this.doUpdateVerAmt(this.getUpdateMiddleVerAmtBuilder(amt, detail).build());
    }

    private RecOrderDtlDO findDetail(Long recDId) {
        RecOrderDtlDO detail = this.recOrderDetailRepoProc.getExtRecOrderDetailAmt(recDId);
        Assert.notNull((Object)detail, (String)("\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u5355\u660e\u7ec6\uff0c\u660e\u7ec6ID:" + recDId));
        return detail;
    }

    private void doUpdateVerAmt(RecOrderAmtUpdateDTO update) {
        if (this.recOrderDetailRepoProc.updateExtVerAmt(update) == 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateMiddleVerAmtBuilder(BigDecimal amt, RecOrderDtlDO detail) {
        BigDecimal unVerAmt = detail.getUnVerAmt().subtract(amt);
        BigDecimal verAmting = detail.getApplyVerAmTing().add(amt);
        if (detail.getTotalAmt().compareTo(unVerAmt.add(verAmting).add(detail.getVerAmt())) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return RecOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(unVerAmt).verAmting(verAmting).verAmt(detail.getVerAmt()).version(detail.getVersion());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerAmt(Long recDId, BigDecimal amt, String verType) {
        RecOrderDtlDO detail = this.findDetail(recDId);
        this.doUpdateVerAmt(this.getUpdateVerAmtBuilder(amt, detail, verType).build());
    }

    @NotNull
    private RecOrderAmtUpdateDTO.RecOrderAmtUpdateDTOBuilder getUpdateVerAmtBuilder(BigDecimal amt, RecOrderDtlDO detail, String verType) {
        String infoStr = JSONUtil.toJsonStr((Object)detail);
        log.info("\u8ba1\u7b97\u6536\u6b3e\u5355\u6838\u9500\u91d1\u989d,{}-{}", (Object)amt, (Object)infoStr);
        if ("2".equals(verType)) {
            BigDecimal verAmt = detail.getVerAmt().subtract(amt);
            BigDecimal unVerAmt = detail.getUnVerAmt().add(amt);
            log.info("\u53d6\u6d88\u6838\u9500,{}-{}-{}", new Object[]{infoStr, verAmt, unVerAmt});
            if (detail.getTotalAmt().compareTo(unVerAmt.add(detail.getApplyVerAmTing()).add(verAmt)) != 0) {
                throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
            }
            return RecOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(unVerAmt).verAmting(detail.getApplyVerAmTing()).verAmt(verAmt).version(detail.getAuditDataVersion());
        }
        BigDecimal verAmting = detail.getApplyVerAmTing().subtract(amt);
        BigDecimal verAmt = detail.getVerAmt().add(amt);
        log.info("\u6838\u9500\u901a\u8fc7,{}-{}-{}", new Object[]{infoStr, verAmting, verAmt});
        if (detail.getTotalAmt().compareTo(detail.getUnVerAmt().add(verAmting).add(verAmt)) != 0) {
            throw new BusinessException("\u8bf7\u6838\u5bf9\u91d1\u989d\u6570\u636e");
        }
        return RecOrderAmtUpdateDTO.builder().arDId(detail.getId()).unVerAmt(detail.getUnVerAmt()).verAmting(verAmting).verAmt(verAmt).version(detail.getAuditDataVersion());
    }

    public RecOrderServiceImpl(RecOrderDomainService recOrderDomainService, RecTypeDomainService recTypeDomainService, SystemRpcService systemRpcService, WorkflowRpcService workflowRpcService, TransactionTemplate transactionTemplate, RecOrderDtlRepoProc recOrderDtlRepoProc, RecOrderDetailRepoProc recOrderDetailRepoProc) {
        this.recOrderDomainService = recOrderDomainService;
        this.recTypeDomainService = recTypeDomainService;
        this.systemRpcService = systemRpcService;
        this.workflowRpcService = workflowRpcService;
        this.transactionTemplate = transactionTemplate;
        this.recOrderDtlRepoProc = recOrderDtlRepoProc;
        this.recOrderDetailRepoProc = recOrderDetailRepoProc;
    }
}

