/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.workflow.adjust;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.log.model.bo.OperationLogDTO;
import com.elitescloud.boot.log.service.OperationLogMqMessageService;
import com.elitesland.fin.application.service.workflow.adjust.FinAdjustOrderProcessService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjustorder.AdjustOrderDO;
import com.elitesland.fin.entity.adjustorder.QAdjustOrderDO;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import com.elitesland.fin.repo.adjustorder.AdjustOrderRepo;
import com.elitesland.fin.service.flow.AccountFlowRpcService;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinAdjustOrderProcessServiceImpl
implements FinAdjustOrderProcessService {
    private static final Logger log = LoggerFactory.getLogger(FinAdjustOrderProcessServiceImpl.class);
    private final AdjustOrderRepo adjustOrderRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final AccountFlowRpcService accountFlowRpcService;
    private final OperationLogMqMessageService operationLogMqMessageService;
    public static String FIRST_TASK_DEF_KEY = "createrSubmit";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(String businessKey, ProcInstStatus procInstStatus, CommentInfo commentInfo) {
        OperationLogDTO dto;
        AdjustOrderDO adjustOrderDO = this.getAdjustOrderDO(businessKey);
        log.info("\u5f00\u59cb\u8d22\u52a1\u8c03\u6574\u5355\u5de5\u4f5c\u6d41\u56de\u8c03\uff0c\u6d41\u7a0b\u72b6\u6001\u4e3a:" + procInstStatus.getDesc());
        QAdjustOrderDO qAdjustOrderDo = QAdjustOrderDO.adjustOrderDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qAdjustOrderDo).set(qAdjustOrderDo.workflowProcInstStatus, (Object)procInstStatus).set((Path)qAdjustOrderDo.auditUser, (Object)commentInfo.getUserName()).set(qAdjustOrderDo.auditTime, (Object)commentInfo.getTime()).where(new Predicate[]{qAdjustOrderDo.id.eq((Object)adjustOrderDO.getId())});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)qAdjustOrderDo.state, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_Adjust:\u8d26\u6237\u8c03\u6574\u5355", adjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_WITHDRAWAL, OperationTypeEnum.APPROVE_WITHDRAWAL.getDescription());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qAdjustOrderDo.state, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                jpaUpdateClause.setNull((Path)qAdjustOrderDo.workflowProcInstId);
                jpaUpdateClause.set((Path)qAdjustOrderDo.state, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_Adjust:\u8d26\u6237\u8c03\u6574\u5355", adjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_WITHDRAWAL, OperationTypeEnum.APPROVE_WITHDRAWAL.getDescription());
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qAdjustOrderDo.state, (Object)UdcEnum.APPLY_STATUS_DRAFT.getValueCode());
                jpaUpdateClause.set((Path)qAdjustOrderDo.auditRejectReason, (Object)commentInfo.getComment());
                dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_Adjust:\u8d26\u6237\u8c03\u6574\u5355", adjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_REJECT, OperationTypeEnum.APPROVE_REJECT.getDescription());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qAdjustOrderDo.state, (Object)UdcEnum.APPLY_STATUS_VOID.getValueCode()).setNull((Path)qAdjustOrderDo.workflowProcInstId);
                jpaUpdateClause.set((Path)qAdjustOrderDo.state, (Object)UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
                jpaUpdateClause.set((Path)qAdjustOrderDo.auditRejectReason, (Object)commentInfo.getComment());
                dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_Adjust:\u8d26\u6237\u8c03\u6574\u5355", adjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_CANCELLATION, OperationTypeEnum.APPROVE_CANCELLATION.getDescription());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qAdjustOrderDo.state, (Object)UdcEnum.APPLY_STATUS_DOING.getValueCode()).set(qAdjustOrderDo.workflowSubmitTime, (Object)LocalDateTime.now());
                dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_Adjust:\u8d26\u6237\u8c03\u6574\u5355", adjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_SUBMIT, OperationTypeEnum.APPROVE_SUBMIT.getDescription());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qAdjustOrderDo.state, (Object)UdcEnum.APPLY_STATUS_COMPLETE.getValueCode()).set(qAdjustOrderDo.workflowEndTime, (Object)commentInfo.getTime());
                dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_Adjust:\u8d26\u6237\u8c03\u6574\u5355", adjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_OK, OperationTypeEnum.APPROVE_OK.getDescription());
                break;
            }
            default: {
                dto = this.operationLogMqMessageService.quickNewOperationLogDTO("Fin_Adjust:\u8d26\u6237\u8c03\u6574\u5355", adjustOrderDO.getDocNo(), OperationTypeEnum.APPROVE_OK, "\u6d41\u7a0b\u72b6\u6001:" + procInstStatus.getDesc());
            }
        }
        log.info("\u5f00\u59cb\u5904\u7406\u5de5\u4f5c\u6d41\u56de\u8c03\u4e1a\u52a1--------");
        log.info(" \u6d41\u7a0b\u5b9e\u4f8bID:{} , \n\u5ba1\u6279\u72b6\u6001:{}, \n\u5ba1\u6279\u4fe1\u606f {}", new Object[]{adjustOrderDO.getWorkflowProcInstId(), procInstStatus, commentInfo});
        AccountFlowRpcParam flowRpcParam = new AccountFlowRpcParam();
        if (StrUtil.equals((CharSequence)adjustOrderDO.getAdjType(), (CharSequence)UdcEnum.ADJUST_TYPE_1.getValueCode())) {
            if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
                flowRpcParam = this.adjustDoToFlowParam(adjustOrderDO, UdcEnum.ADJUST_TYPE_1.getValueCode(), UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            }
        }
        if (StrUtil.equals((CharSequence)adjustOrderDO.getAdjType(), (CharSequence)UdcEnum.ADJUST_TYPE_2.getValueCode())) {
            if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
                flowRpcParam = this.adjustDoToFlowParam(adjustOrderDO, UdcEnum.ADJUST_TYPE_2.getValueCode(), UdcEnum.APPLY_STATUS_COMPLETE.getValueCode());
            }
            if (procInstStatus.equals((Object)ProcInstStatus.REJECTED)) {
                flowRpcParam = this.adjustDoToFlowParam(adjustOrderDO, UdcEnum.ADJUST_TYPE_2.getValueCode(), UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
            }
            if (procInstStatus.equals((Object)ProcInstStatus.NOTSUBMIT) || procInstStatus.equals((Object)ProcInstStatus.INTERRUPT)) {
                flowRpcParam = this.adjustDoToFlowParam(adjustOrderDO, UdcEnum.ADJUST_TYPE_2.getValueCode(), UdcEnum.APPLY_STATUS_REJECTED.getValueCode());
            }
        }
        jpaUpdateClause.execute();
        if (ObjectUtil.isNotNull((Object)flowRpcParam.getSourceId())) {
            this.accountFlowRpcService.generateAccountFlow(flowRpcParam);
        }
        this.operationLogMqMessageService.sendAsyncOperationLogMqMessage(dto);
    }

    @Override
    public ArrayList<String> taskAssignee(String businessKey, String customParams) {
        return null;
    }

    private AccountFlowRpcParam adjustDoToFlowParam(AdjustOrderDO adjustOrderDO, String sourceDcoType, String sourceDocStatus) {
        AccountFlowRpcParam flowRpcParam = new AccountFlowRpcParam();
        flowRpcParam.setSourceNo(adjustOrderDO.getDocNo());
        flowRpcParam.setSourceId(adjustOrderDO.getId());
        flowRpcParam.setSourceDoc(UdcEnum.DOC_CLS_AO.getValueCode());
        flowRpcParam.setSourceDocType(sourceDcoType);
        flowRpcParam.setSourceDocStatus(sourceDocStatus);
        flowRpcParam.setSourceDocAmount(adjustOrderDO.getTotalAmt());
        flowRpcParam.setAccountCode(adjustOrderDO.getAccCode());
        flowRpcParam.setWorkflowProcInstId(adjustOrderDO.getWorkflowProcInstId());
        return flowRpcParam;
    }

    private AdjustOrderDO getAdjustOrderDO(String businessKey) {
        String docNo = businessKey.split("#")[0].trim();
        AdjustOrderDO adjustOrderDO = (AdjustOrderDO)((Object)((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QAdjustOrderDO.adjustOrderDO).where((Predicate)QAdjustOrderDO.adjustOrderDO.docNo.eq((Object)docNo))).fetchOne());
        if (adjustOrderDO == null) {
            throw new RuntimeException("\u8c03\u6574\u5355(\u7f16\u7801:" + docNo + ")\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5ba1\u6279");
        }
        return adjustOrderDO;
    }

    public FinAdjustOrderProcessServiceImpl(AdjustOrderRepo adjustOrderRepo, JPAQueryFactory jpaQueryFactory, AccountFlowRpcService accountFlowRpcService, OperationLogMqMessageService operationLogMqMessageService) {
        this.adjustOrderRepo = adjustOrderRepo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.accountFlowRpcService = accountFlowRpcService;
        this.operationLogMqMessageService = operationLogMqMessageService;
    }
}

